package com.ejianc.business.consts;

import java.util.HashMap;
import java.util.Map;

/**
 * @description: 常量名字转化
 * @author songlx
 * @date 2023/9/22
 * @version 1.0
 */
public class ZatopConstsUtil {

    /**
     * 是否 1是0否
     */
    private static Map<String, String> yesOrNoMap = new HashMap<>();

    /**
     * 合同状态 1-未签订，2-履约中，3-已封账
     */
    private static Map<String, String> contractStateMap = new HashMap<>();


    /**
     * 采购方式:1-公司集采，2-项目自采合同
     */
    private static Map<String, String> purchaseModeMap = new HashMap<>();


    /**
     * 结算类型:0-过程结算，1-最终结算
     */
    private static Map<String, String> settleTypeMap = new HashMap<>();


    /**
     * 材料定标 计价方式: 1-采购，2-租赁
     */
    private static Map<String, String> pricingTypeMap = new HashMap<>();


    /**
     * 签证洽商索赔 变更类型: 1-现场签证，2-变更洽商，3-索赔
     */
    private static Map<String, String> claimChangeTypeMap = new HashMap<>();




    /**
     * correctionType
     * 进度管理 延误纠偏 处置单位: 0-项目自行解决，1-区域公司处理，2-总部处理
     */
    private static Map<String, String> dayFillCorrectionTypeMap = new HashMap<>();


    /**
     * quotationAuthority
     * 报价权限
     */
    private static Map<String, String> quotationAuthorityMap = new HashMap<>();




    static {
        yesOrNoMap.put("1", "是");
        yesOrNoMap.put("0", "否");

        contractStateMap.put("1", "未签订");
        contractStateMap.put("2", "履约中");
        contractStateMap.put("3", "已封账");

        purchaseModeMap.put("1", "公司集采");
        purchaseModeMap.put("2", "项目自采");

        settleTypeMap.put("1", "最终结算");
        settleTypeMap.put("0", "过程结算");

        pricingTypeMap.put("1", "采购");
        pricingTypeMap.put("2", "租赁");

        claimChangeTypeMap.put("1", "现场签证");
        claimChangeTypeMap.put("2", "变更洽商");
        claimChangeTypeMap.put("3", "索赔");
        claimChangeTypeMap.put("4", "商务策划");


        dayFillCorrectionTypeMap.put("0", "项目自行解决");
        dayFillCorrectionTypeMap.put("1", "区域公司处理");
        dayFillCorrectionTypeMap.put("2", "总部处理");

        quotationAuthorityMap.put("1", "指定供应商");
        quotationAuthorityMap.put("2", "所有供应商");

    }

    public static String getQuotationAuthorityName(String key) {
        return quotationAuthorityMap.get(key);
    }

    public static String getDayFillCorrectionTypeName(String key) {
        return dayFillCorrectionTypeMap.get(key);
    }


    public static String getYesOrNoName(String key) {
        return yesOrNoMap.get(key);
    }


    public static String getContractStateName(String key) {
        return contractStateMap.get(key);
    }


    public static String getPurchaseModeName(String key) {
        return purchaseModeMap.get(key);
    }

    public static String getSettleTypeName(String key) {
        return settleTypeMap.get(key);
    }

    public static String getPricingTypeName(String key) {
        return pricingTypeMap.get(key);
    }


    public static String getClaimChangeTypeName(String key) {
        return claimChangeTypeMap.get(key);
    }
}
