package com.ejianc.business.supplier;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ejianc.business.common.CommonZatopDataDealService;
import com.ejianc.business.market.vo.SupplierCooperateVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.EnvironmentTools;
import com.ejianc.zatopbpm.service.common.ICommonZatopBusinessService;
import com.google.common.collect.Lists;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

/**
 * 供应商评估
 * */
@Service("ejc-support-web-estimateZatop")
public class EstimateBpmServiceImpl extends CommonZatopDataDealService implements ICommonZatopBusinessService {

    private final Logger logger = LoggerFactory.getLogger(getClass());
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private EnvironmentTools environmentTools;
    private final static String INDEX_NAME_PAY_CONTRACT ="pay_contract";

    @Autowired(required = false)
    private RestHighLevelClient client;

    private final static Integer QUERY_TIMEOUT = 60;

    /**
     * 数据单独处理
     *
     * @param billId
     * @param billData 单据信息---从数据库中查询出来的信息
     * @return billData需要将单据信息+处理的信息返回
     */
    @Override
    public JSONObject dealBillData(Long billId, JSONObject billData) {
        logger.info("{}-billData:{}", getClass().getName(), JSON.toJSONString(billData, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));
        List<Long> supplierIds = Lists.asList(billData.getLong("supplierId"),new Long[]{});
        Map<Long,List<SupplierCooperateVO>> map = querySupplierCooperate(supplierIds);
        if(map!=null && map.get(billData.getLong("supplierId"))!=null){
            List<SupplierCooperateVO> supplierCooperateVOS = map.get(billData.getLong("supplierId"));
            /** 历史合作项目 */
            billData.put("cooperateVOS",supplierCooperateVOS);
        }
        return billData;
    }

    /**
     * 主表添加额外的表单中的字段
     *
     * @param billId
     * @param fields 主表信息集合---经过处理后的
     * @return fields 推送给第三方的最后数据,按格式返回
     * @return"fields": [
     *  {
     *  "id": "TITLE",
     *  "name": "流程主题",
     *  "value": "XXX 项目合同流程",
     *  "modifyStatus": ""
     *  },
     *  {
     *  "id": "ContractName",
     *  "name": "合同名称",
     *  "value": "XXX 项目合同",
     *  "modifyStatus": ""
     *  }
     *  ]
     */
    public JSONArray addFields(Long billId, JSONObject billData, JSONArray fields) {
        return addFieldsForBillData(billId, billData, fields);
    }

    /**
     * 子表数据库数据单独处理----子表多个时会遍历循环此方法
     *
     * @param billId
     * @param entityName 子表实体名
     * @param childrenData 单据子表信息---从数据库中查询出来的信息，一个子表的
     * @return billData需要将单据信息+处理的信息返回
     * @return
     */
    public JSONArray dealBillchldrenData(Long billId, String entityName, JSONArray childrenData) {
        return childrenData;
    }

    /**
     * 子表数据单独处理
     *
     * @param billId
     * @param lists  子表信息集合---经过处理后的
     * @return lists 推送给第三方的最后数据,按格式返回
     * @return "lists": [[
     * {
     * "listId": "ContractPaymentDetail",
     * "listName": "合同付款比例明细",
     * "items": [
     * {
     * "id": "FKBL",
     * "name": "付款比例",
     * "value": "30%",
     * "modifyStatus": ""
     * },
     * {
     * "id": "FKBL",
     * "name": "付款比例",
     * "value": "30%",
     * "modifyStatus": ""
     * },
     * {
     * "id": "FKBL",
     * "name": "付款比例",
     * "value": "30%",
     * "modifyStatus": ""
     * }
     * ]
     * }
     * ]]]
     */
    @Override
    public JSONArray dealBillChildrenData(Long billId, JSONArray lists) {
        return lists;
    }

    /**
     * 主表数据单独处理
     *
     * @param billId
     * @param sourceType 附件类型
     * @param attachments 单据附件信息---经过处理后的
     * @return attachments 推送给第三方的最后数据,按格式返回
     * @return "attachments": [
     * {
     * "fileId": "92535855-A661-E911-80BD-90E2BABD62D1",
     * "fileName": "【打印 3 份】南京公司-璞樾钟山-大区除 24 号楼家用除霾新风设备采购合同.docx",
     * "fileType": "合同登记",
     * "fileUrl": "http:/",
     * "uploadUserId":"kook.zhang",
     * "uploadUserName":"张亮",
     * "modifyStatus":""
     * }]
     */
    @Override
    public JSONArray dealBillAttachmentsData(Long billId, String billTypeCode, String sourceType, JSONArray attachments) {
        attachments = new JSONArray();
        CommonResponse<List<AttachmentVO>> attachmentResponse = attachmentApi.queryListBySourceId(billId, null, null, null);
        if(attachmentResponse.isSuccess() && attachmentResponse.getData()!=null && attachmentResponse.getData().size()>0){
            for(AttachmentVO attachmentVO : attachmentResponse.getData()){
                JSONObject attachment = new JSONObject();
                attachment.put("fileName", attachmentVO.getFileName());
                attachment.put("fileId", attachmentVO.getId());
                String fileType = "";
                if(attachmentVO.getFileName().contains(".")){
                    fileType = attachmentVO.getFileName().split("\\.")[1];
                }
                attachment.put("fileType", fileType);
                String fileUrl = environmentTools.getBaseHost() + "ejc-file-web/attachment/filePreview?fileId=" + attachmentVO.getId();
                attachment.put("uploadUserId", attachmentVO.getCreateUserCode());
                attachment.put("fileUrl", fileUrl);
                attachment.put("uploadUserName", attachmentVO.getCreateUserName());
                attachments.add(attachment);
            }
        }
        return attachments;
    }

    public Map<Long,List<SupplierCooperateVO>> querySupplierCooperate(List<Long> supplierIds) {
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        boolQuery.must(QueryBuilders.termsQuery("supplierId", supplierIds));
        boolQuery.must(QueryBuilders.termQuery("tenantId", InvocationInfoProxy.getTenantid().toString()));
        SearchRequest searchRequest = new SearchRequest(INDEX_NAME_PAY_CONTRACT);
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        sourceBuilder.trackTotalHits(true);
        sourceBuilder.query(boolQuery);
        sourceBuilder.timeout(new TimeValue(QUERY_TIMEOUT, TimeUnit.SECONDS)); //设置超时时间
        searchRequest.source(sourceBuilder);
        Map<Long, List<SupplierCooperateVO>> map = new HashMap<>();
        List<SupplierCooperateVO> list = new ArrayList<>();
        SearchResponse response = null;
        try {
            response = client.search(searchRequest, RequestOptions.DEFAULT);
            SearchHits hits = response.getHits();
            for (SearchHit hit : hits) {
                String sourceAsString = hit.getSourceAsString();
                list.add(JSON.parseObject(sourceAsString, SupplierCooperateVO.class));
            }
            map = list.stream().collect(Collectors.groupingBy(SupplierCooperateVO::getSupplierId));
        } catch (IOException e) {
            logger.error("查询历史业绩失败！",e);
            e.printStackTrace();
        }
        return map;
    }
}
