package com.ejianc.zatopbpm.controller;

import java.io.Serializable;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.zatopbpm.bean.ErrorCallbackEntity;
import com.ejianc.zatopbpm.service.IErrorCallbackService;
import com.ejianc.zatopbpm.vo.ErrorCallbackVO;

/**
 * 错误回调事件实体
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("errorCallback")
public class ErrorCallbackController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IErrorCallbackService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ErrorCallbackVO> saveOrUpdate(@RequestBody ErrorCallbackVO saveOrUpdateVO) {
    	ErrorCallbackEntity entity = BeanMapper.map(saveOrUpdateVO, ErrorCallbackEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
        }
    	service.saveOrUpdate(entity, false);
    	ErrorCallbackVO vo = BeanMapper.map(entity, ErrorCallbackVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ErrorCallbackVO> queryDetail(Long id) {
    	ErrorCallbackEntity entity = service.selectById(id);
    	ErrorCallbackVO vo = BeanMapper.map(entity, ErrorCallbackVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ErrorCallbackVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (ErrorCallbackVO vo : vos) {
            }
        }
        service.removeByIds(vos.stream().map(ErrorCallbackVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ErrorCallbackVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        IPage<ErrorCallbackVO> page = service.queryData(param);
        return CommonResponse.success("查询列表数据成功！",page);
    }

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/deal", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> deal(@RequestBody ErrorCallbackVO vo) {
        return service.deal(vo);
    }

}
