package com.ejianc.zatopbpm.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.zatopbpm.bean.BpmInfoEntity;
import com.ejianc.zatopbpm.mapper.BpmInfoMapper;
import com.ejianc.zatopbpm.service.IBpmInfoService;
import com.ejianc.zatopbpm.utils.BillState;
import com.ejianc.zatopbpm.utils.UpdateBillStateUtils;
import com.ejianc.zatopbpm.vo.BpmConfigVO;
import com.ejianc.zatopbpm.vo.BpmInfoVO;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * 审批信息表
 * 
 * @author generator
 * 
 */
@Service("bpmInfoService")
public class BpmInfoServiceImpl extends BaseServiceImpl<BpmInfoMapper, BpmInfoEntity> implements IBpmInfoService{

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private UpdateBillStateUtils updateBillStateUtils;

    @Override
    public BpmInfoEntity selectByBpmId(String bpmId) {
        QueryWrapper<BpmInfoEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("dr", 0);
        wrapper.eq("bpm_id", bpmId);
        List<BpmInfoEntity> list = this.list(wrapper);
        if(list!=null && list.size()>0){
            return list.get(0);
        }
        return null;
    }

    @Override
    public CommonResponse<String> regainFree(BpmInfoVO vo) {
        if(InvocationInfoProxy.getExtendAttribute("authority")==null){
            HttpServletRequest request = ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
            InvocationInfoProxy.setExtendAttribute("authority", request.getHeader("authority"));
        }
        CommonResponse<String> beforeAbstainingResponse = updateBillStateUtils.beforeAbstainingProcessor(
                vo.getBillId(), vo.getBillTypeCode(), BillState.UNCOMMITED_STATE);
        if (!beforeAbstainingResponse.isSuccess()) {
            logger.error("弃审前事件回调报错， 请检查对应服务是否正常！");
            throw new BusinessException(beforeAbstainingResponse.getMsg());
        }
        // 修改单据状态
        CommonResponse<String> oldData = updateBillStateUtils.updateBillState(vo.getBillId(), vo.getBillTypeCode(),
                BillState.UNCOMMITED_STATE);
        if (oldData.isSuccess()) {
            CommonResponse<String> afterAbstainingResponse = updateBillStateUtils.afterAbstainingProcessor(
                    vo.getBillId(), vo.getBillTypeCode(), BillState.UNCOMMITED_STATE);
            if (!afterAbstainingResponse.isSuccess()) {
                String oldBillState = oldData.getData();
                if (StringUtils.isNotBlank(oldBillState)) {
                    CommonResponse<String> resu = updateBillStateUtils.updateBillState(vo.getBillId(), vo.getBillTypeCode(),
                            Integer.parseInt(oldBillState));
                    if(!resu.isSuccess()){
                        //为了预防第一次没有执行成功，故再执行一次
                        updateBillStateUtils.updateBillState(vo.getBillId(), vo.getBillTypeCode(),Integer.parseInt(oldBillState));
                    }
                }
                logger.error("弃审后事件回调报错， 请检查对应服务是否正常！");
                throw new BusinessException(afterAbstainingResponse.getMsg());
            }
        }
        vo.setType("withdraw");
        BpmInfoEntity entity = BeanMapper.map(vo, BpmInfoEntity.class);
        this.saveOrUpdate(entity, false);
        return CommonResponse.success("弃审成功！");
    }
}
