package com.ejianc.zatopbpm.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.zatopbpm.bean.BpmOrgRelationEntity;
import com.ejianc.zatopbpm.mapper.BpmOrgRelationMapper;
import com.ejianc.zatopbpm.service.IBpmOrgRelationService;
import com.ejianc.zatopbpm.vo.BpmOrgRelationVO;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class BpmOrgRelationServiceImpl extends BaseServiceImpl<BpmOrgRelationMapper, BpmOrgRelationEntity> implements IBpmOrgRelationService {

	@Override
	public BpmOrgRelationVO queryDetail(Long id) {
		BpmOrgRelationEntity entity = super.getById(id);
		if(entity != null) {
			return BeanMapper.map(entity, BpmOrgRelationVO.class);
		}
		throw new BusinessException("未查询到该主键对应的详情");
	}
	
	@Override
	public void delete(List<Long> ids) {
		QueryWrapper<BpmOrgRelationEntity> wrapper = new QueryWrapper<>();
		wrapper.in("config_id", ids);
		this.remove(wrapper);
	}

	@Override
	public List<BpmOrgRelationEntity> querylist(QueryWrapper<BpmOrgRelationEntity> queryWrapper) {
		return this.list(queryWrapper);
	}

}
