package com.ejianc.zatopbpm.utils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.metadata.api.IMdApi;
import com.ejianc.foundation.metadata.api.IMdAttributeApi;
import com.ejianc.foundation.metadata.api.IMdClassApi;
import com.ejianc.foundation.metadata.vo.MdAttributeVO;
import com.ejianc.foundation.metadata.vo.MdClassVO;
import com.ejianc.foundation.metadata.vo.MdReferVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillTypeVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.EnvironmentTools;
import com.ejianc.framework.skeleton.refer.util.ContextUtil;
import com.ejianc.framework.skeleton.refer.util.ReferObjectUtil;
import com.ejianc.support.idworker.util.IdWorker;
import com.ejianc.zatopbpm.mapper.CommenMapper;
import com.ejianc.zatopbpm.service.common.ICommonZatopBusinessService;
import com.google.gson.Gson;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@SuppressWarnings("unchecked")
@Component
public class GetBillDataUtil {

    // 日志
    private final Logger logger = LoggerFactory.getLogger(getClass());

    private Gson gson = new Gson();

    @Value("${zatop.businessObjectUrl:https://auth.zatop.cn/oauth/authorize?client_id=web&redirect_uri=https%3A%2F%2Fpm.zatop.cn%2Fportal%2Fno_auth%2Fzatop%2FssoLogin&scope=server&response_type=code&state=}")
    private String businessObjectUrl;

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IMdApi mdApi;
    @Autowired
    private CacheManager cacheManager;
    @Autowired
    private EnvironmentTools environmentTools;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private CommenMapper commenMapper;
    @Autowired
    private IMdAttributeApi mdAttributeApi;
    @Autowired
    private IMdClassApi mdClassApi;

    public JSONObject getBillData(Long billId, String billTypeCode, String sourceType) {
        String billTypeName = "";
        CommonResponse<BillTypeVO> billTypeResponse = billTypeApi.getByCode(billTypeCode);
        if(billTypeResponse.isSuccess()) {
            BillTypeVO billTypeVo = billTypeResponse.getData();
            billTypeName = billTypeVo.getBillName();
        }
        String url = businessObjectUrl+billId;
        //获取单据信息
        JSONObject businessObject = new JSONObject();
        businessObject.put("businessObjectId", billTypeCode);//业务对象 ID
        businessObject.put("businessObjectName", billTypeName);//业务对象名称
        businessObject.put("businessObjectUrl", url);//业务系统提供的业务单据查看 URL
        businessObject.put("businessObjectModifyUrl", url);//业务系统提供的业务单据修改 URL
        businessObject.put("businessObjectVersion", String.valueOf(IdWorker.getId()));//业务数据版本，业务系统可传业务数据 hash

        JSONObject billData = this.queryBillDetail(billId, billTypeCode, sourceType);

        logger.info("查询单据详情返回的结果：---------------"+billData.toJSONString());

        JSONArray fields = (JSONArray) billData.get("fields");
        JSONObject field = new JSONObject();
        field.put("id", "TITLE");
        field.put("name", "流程主题");
        field.put("value", sessionManager.getUserContext().getUserName() + "提交的" + billTypeName);
        fields.add(field);
        businessObject.put("fields", fields);//主表字段集合（流程主题字段为TITLE）
        businessObject.put("lists", billData.get("lists"));//明细表集合
        businessObject.put("attachments", billData.get("attachments"));//附件集合

        businessObject.put("relatedProcess", null);//相关流程集合

        JSONObject result = new JSONObject();
        result.put("businessObject", businessObject);
        return result;
    }

    /**
     * 根据单据主键ID和单据类型， 查询单据详情
     *
     * @param businessKey  单据主键ID
     * @param billTypeCode 单据类型ID
     * @return
     */
    public JSONObject queryBillDetail(Long businessKey, String billTypeCode, String sourceType) {
        logger.info("查询单据详情api开始参数：------businessKey："+businessKey+"billType:"+billTypeCode);

        JSONObject referVo = this.getMdByTypeCode(billTypeCode);
        if(referVo==null||referVo.get("tableName")==null){
            logger.info("根据单据类型code："+billTypeCode+"查询获取元数据失败:");
            throw new BusinessException("网络异常， 查询元数据失败");
        }
        return this.queryBillDetail(businessKey, referVo.get("projectName").toString(), referVo.get("entityName").toString(), referVo.get("databaseName").toString(),
                referVo.get("tableName").toString(), Long.parseLong(referVo.get("metadataId").toString()), sourceType, billTypeCode);
    }

    public JSONObject getMdByTypeCode(String billTypeCode) {
        JSONObject json = new JSONObject();
        String key = "btd-md-"+billTypeCode;
        if(cacheManager.get(key)!=null){
            json = cacheManager.get(key);
        }else{
            CommonResponse<BillTypeVO> billTypeResponse = billTypeApi.getByCode(billTypeCode);
            if(billTypeResponse.isSuccess()) {
                BillTypeVO billTypeVo = billTypeResponse.getData();
                logger.info("调用元数据api参数：---------------"+billTypeVo.getMetadataId());
                if(billTypeVo.getMetadataId()!=null){
                    CommonResponse<MdReferVO> referResponse = mdApi.queryMetadataById(billTypeVo.getMetadataId());
                    if(referResponse.isSuccess()) {
                        MdReferVO vo = referResponse.getData();
                        json.put("metadataId", billTypeVo.getMetadataId());
                        json.put("entityName", vo.getEntityName());
                        json.put("billTypeCode", billTypeVo.getBillCode());
                        json.put("databaseName", vo.getDatabaseName());
                        json.put("projectName", vo.getProjectName());
                        json.put("tableName", vo.getTableName());
                        cacheManager.setex(key, json, 3000);
                    }else{
                        logger.info("调用查询元数据服务异常：---------------"+referResponse.getMsg());
                    }
                }
            }
        }
        return json;
    }

    public JSONObject queryBillDetail(Long billId, String projectName, String entityName, String databaseName, String tableName, Long metadataId, String sourceType, String billTypeCode) {
        JSONObject result = new JSONObject();

        ICommonZatopBusinessService commonZatopBusinessService = obtainBusinessService(entityName, projectName);
        /***************获取单据主表信息*************************/
        //查询元数据表结构
        List<String> columnList = commenMapper.queryTableAttrList(databaseName, tableName);
        Map<String, String> columnMap = new HashMap<String, String>();
        if(columnList != null && columnList.size() > 0) {
            for(String column:columnList) {
                columnMap.put(column, column);
            }
        }
        JSONArray fields = new JSONArray();
        JSONObject billData = new JSONObject();

        CommonResponse<List<MdAttributeVO>> attributeResponse = mdAttributeApi.queryMainAttributeList(metadataId);
        if(attributeResponse.isSuccess()) {
            Map<String, MdAttributeVO> attributeMap = new HashMap<>();
            List<MdAttributeVO> mdAttributeVos = attributeResponse.getData();
            StringBuffer paramBuffer = new StringBuffer("");
            if(mdAttributeVos != null && mdAttributeVos.size() > 0) {
                for(MdAttributeVO mdAttributeVo:mdAttributeVos) {
                    attributeMap.put(mdAttributeVo.getAttributeName(), mdAttributeVo);
                    if(columnMap.containsKey(mdAttributeVo.getColumnName())) {
                        paramBuffer.append(("`"+mdAttributeVo.getColumnName()+"`")).append(" as ").append(("`"+mdAttributeVo.getAttributeName()+"`")).append(",");
                    }
                }
                if(StringUtils.isNotBlank(paramBuffer)) {
                    String parameter = paramBuffer.substring(0, paramBuffer.length() - 1);
                    JSONObject jsonObject = commenMapper.queryBillDetail(databaseName, tableName, parameter, String.valueOf(billId));
                    billData = jsonObject;
                    jsonObject = commonZatopBusinessService.dealBillData(billId, jsonObject);
                    for(String key : attributeMap.keySet()){
                        MdAttributeVO mdAttributeVO = attributeMap.get(key);
                        Object value = jsonObject.get(key);
                        JSONObject field = new JSONObject();
                        field.put("id", key);
                        field.put("name", mdAttributeVO.getDisplayName());
                        if(jsonObject.get(key)!=null){

                            if("datetime".equals(mdAttributeVO.getDataType()) && !(value instanceof String)){
                                value = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(value);
                            }else if("date".equals(mdAttributeVO.getDataType()) && !(value instanceof String)){
                                value = new SimpleDateFormat("yyyy-MM-dd").format(value);
                            }else if("long".equals(mdAttributeVO.getDataType()) && !(value instanceof String)){
                                if(StringUtils.isNotBlank(mdAttributeVO.getReferCode())){
                                    try {
                                        JSONArray jArray = ReferObjectUtil.getReferEntityValue(value.toString(), mdAttributeVO.getReferCode());
                                        if(jArray!=null&&jArray.size()>0){
                                            JSONObject json = (JSONObject) jArray.get(0);
                                            value = json.get("name")!=null?json.get("name").toString():"";
                                        }
                                    }catch (Exception e){

                                    }
                                }
                            }else if("decimal".equals(mdAttributeVO.getDataType()) && !(value instanceof String)){
                                if(mdAttributeVO.getDecimalPlace()!=null && mdAttributeVO.getDecimalPlace()>2){
                                    value = getBigDecimal(value).setScale(2, BigDecimal.ROUND_HALF_UP);
                                }
                            }else if("float".equals(mdAttributeVO.getDataType()) && !(value instanceof String)){
                                if(mdAttributeVO.getDecimalPlace()!=null && mdAttributeVO.getDecimalPlace()>2){
                                    value = getBigDecimal(value).setScale(2, BigDecimal.ROUND_HALF_UP);
                                    float i = (float) value;
                                    BigDecimal b = new BigDecimal(i);
                                    value = b.setScale(2, BigDecimal.ROUND_HALF_UP).floatValue();
                                }
                            }else if("double".equals(mdAttributeVO.getDataType()) && !(value instanceof String)){
                                if(mdAttributeVO.getDecimalPlace()!=null && mdAttributeVO.getDecimalPlace()>2){
                                    value = getBigDecimal(value).setScale(2, BigDecimal.ROUND_HALF_UP);
                                    double i = (double) value;
                                    BigDecimal b = new BigDecimal(i);
                                    value = b.setScale(2, BigDecimal.ROUND_HALF_UP).floatValue();
                                }
                            }

                        }
                        field.put("value", value);
                        fields.add(field);
                    }
                }
            }
        }
        fields = commonZatopBusinessService.addFields(billId, billData, fields);
        result.put("fields", fields);

        /***************获取单据子表信息*************************/
        JSONArray lists = new JSONArray();
        //获取所有的子表信息
        CommonResponse<List<MdClassVO>> classChildrenResponse = mdClassApi.findAllByParentEntityId(metadataId);
        if(classChildrenResponse.isSuccess() && classChildrenResponse.getData()!=null && classChildrenResponse.getData().size()>0){
            List<MdClassVO> classChildren = classChildrenResponse.getData();
            for(MdClassVO mdClassVO : classChildren){
                JSONObject list = new JSONObject();
                list.put("listId", mdClassVO.getMainAttributeField());
                list.put("listName", mdClassVO.getDisplayName());
                JSONArray items = new JSONArray();

                //查询元数据表结构
                List<String> columnChildrenList = commenMapper.queryTableAttrList(databaseName, mdClassVO.getTableName());
                Map<String, String> columnChildrenMap = new HashMap<String, String>();
                if(columnChildrenList != null && columnChildrenList.size() > 0) {
                    for(String column:columnChildrenList) {
                        columnChildrenMap.put(column, column);
                    }
                }
                CommonResponse<List<MdAttributeVO>> attributeChildrenResponse = mdAttributeApi.queryMainAttributeList(mdClassVO.getId());
                if(attributeChildrenResponse.isSuccess()) {
                    Map<String, MdAttributeVO> attributeMap = new HashMap<>();
                    List<MdAttributeVO> mdAttributeVos = attributeChildrenResponse.getData();
                    StringBuffer paramBuffer = new StringBuffer("");
                    String param = "";
                    if(mdAttributeVos != null && mdAttributeVos.size() > 0) {
                        for(MdAttributeVO mdAttributeVo:mdAttributeVos) {
                            attributeMap.put(mdAttributeVo.getAttributeName(), mdAttributeVo);
                            if(columnChildrenMap.containsKey(mdAttributeVo.getColumnName())) {
                                paramBuffer.append(("`"+mdAttributeVo.getColumnName()+"`")).append(" as ").append(("`"+mdAttributeVo.getAttributeName()+"`")).append(",");
                            }
                            if(mdAttributeVo.getForeignKeyFlag()){
                                param = "dr = 0 and " + mdAttributeVo.getColumnName() + "=" + billId;
                            }
                        }
                        if(StringUtils.isNotBlank(paramBuffer)) {
                            String parameter = paramBuffer.substring(0, paramBuffer.length() - 1);
                            JSONArray childrenData = commenMapper.queryBillInfoByProperty(databaseName, mdClassVO.getTableName(), parameter.toString(), param);
                            childrenData = commonZatopBusinessService.dealBillchldrenData(billId, mdClassVO.getEntityName(), childrenData);

                            for(Object object : childrenData){
                                JSONObject jsonObject = (JSONObject) object;
                                JSONArray children = new JSONArray();
                                for(String key : attributeMap.keySet()){
                                    MdAttributeVO mdAttributeVO = attributeMap.get(key);
                                    Object value = jsonObject.get(key);
                                    JSONObject field = new JSONObject();
                                    field.put("id", key);
                                    field.put("name", mdAttributeVO.getDisplayName());
                                    if(jsonObject.get(key)!=null){
                                        if("datetime".equals(mdAttributeVO.getDataType()) && !(value instanceof String)){
                                            value = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(value);
                                        }else if("date".equals(mdAttributeVO.getDataType()) && !(value instanceof String)){
                                            value = new SimpleDateFormat("yyyy-MM-dd").format(value);
                                        }else if("long".equals(mdAttributeVO.getDataType()) && !(value instanceof String)){
                                            if(StringUtils.isNotBlank(mdAttributeVO.getReferCode())){
                                                try {
                                                    JSONArray jArray = ReferObjectUtil.getReferEntityValue(value.toString(), mdAttributeVO.getReferCode());
                                                    if(jArray!=null&&jArray.size()>0){
                                                        JSONObject json = (JSONObject) jArray.get(0);
                                                        value = json.get("name")!=null?json.get("name").toString():"";
                                                    }
                                                }catch (Exception e){

                                                }
                                            }
                                        }else if("decimal".equals(mdAttributeVO.getDataType()) && !(value instanceof String)){
                                            if(mdAttributeVO.getDecimalPlace()!=null && mdAttributeVO.getDecimalPlace()>2){
                                                value = getBigDecimal(value).setScale(2, BigDecimal.ROUND_HALF_UP);
                                            }
                                        }else if("float".equals(mdAttributeVO.getDataType()) && !(value instanceof String)){
                                            if(mdAttributeVO.getDecimalPlace()!=null && mdAttributeVO.getDecimalPlace()>2){
                                                value = getBigDecimal(value).setScale(2, BigDecimal.ROUND_HALF_UP);
                                                float i = (float) value;
                                                BigDecimal b = new BigDecimal(i);
                                                value = b.setScale(2, BigDecimal.ROUND_HALF_UP).floatValue();
                                            }
                                        }else if("double".equals(mdAttributeVO.getDataType()) && !(value instanceof String)){
                                            if(mdAttributeVO.getDecimalPlace()!=null && mdAttributeVO.getDecimalPlace()>2){
                                                value = getBigDecimal(value).setScale(2, BigDecimal.ROUND_HALF_UP);
                                                double i = (double) value;
                                                BigDecimal b = new BigDecimal(i);
                                                value = b.setScale(2, BigDecimal.ROUND_HALF_UP).floatValue();
                                            }
                                        }
                                    }
                                    field.put("value", value);
                                    children.add(field);
                                }
                                items.add(children);
                            }

                        }
                    }
                }
                list.put("items", items);
                lists.add(list);
            }
        }
        lists = commonZatopBusinessService.dealBillChildrenData(billId, lists);
        result.put("lists", lists);
        /***************获取单据附件信息*************************/
        JSONArray attachments = new JSONArray();
        CommonResponse<List<AttachmentVO>> attachmentResponse = attachmentApi.queryListBySourceId(billId, billTypeCode, sourceType, null);
        if(attachmentResponse.isSuccess() && attachmentResponse.getData()!=null && attachmentResponse.getData().size()>0){
            for(AttachmentVO attachmentVO : attachmentResponse.getData()){
                JSONObject attachment = new JSONObject();
                attachment.put("fileId", attachmentVO.getId());
                attachment.put("fileName", attachmentVO.getFileName());
                String fileType = "";
                if(attachmentVO.getFileName().contains(".")){
                    fileType = attachmentVO.getFileName().split("\\.")[1];
                }
                attachment.put("fileType", fileType);
                String fileUrl = environmentTools.getBaseHost() + "ejc-file-web/attachment/filePreview?fileId=" + attachmentVO.getId();
                attachment.put("fileUrl", fileUrl);
                attachment.put("uploadUserId", attachmentVO.getCreateUserCode());
                attachment.put("uploadUserName", attachmentVO.getCreateUserName());
                attachments.add(attachment);
            }
        }
        attachments = commonZatopBusinessService.dealBillAttachmentsData(billId, billTypeCode, sourceType, attachments);

        result.put("attachments", attachments);
        return result;
    }

    public static BigDecimal getBigDecimal(Object value) {
        BigDecimal ret = null;
        if (value != null) {
            if (value instanceof BigDecimal) {
                ret = (BigDecimal) value;
            } else if (value instanceof String) {
                ret = new BigDecimal((String) value);
            } else if (value instanceof Number) {
                ret = new BigDecimal(((Number) value).doubleValue());
            } else {
                throw new ClassCastException("Not possible to coerce [" + value + "] from class " + value.getClass() + " into a BigDecimal.");
            }
        }
        return ret;
    }

    public static String toLowerCaseFirstOne(String param) {
        if (Character.isLowerCase(param.charAt(0))) {
            return param;
        } else {
            return (new StringBuilder()).append(Character.toLowerCase(param.charAt(0))).append(param.substring(1)).toString();
        }
    }

    private ICommonZatopBusinessService obtainBusinessService(String entityName, String projectName) {
        String serviceName = toLowerCaseFirstOne(entityName.replace("Entity", "Zatop"));
        serviceName = projectName + "-" + serviceName;
        ICommonZatopBusinessService businessService = null;
        try{
            businessService = ContextUtil.getBean(serviceName, ICommonZatopBusinessService.class);
        }catch (Exception e){
            businessService = ContextUtil.getBean("defaultZatopBusinessService", ICommonZatopBusinessService.class);
        }
        return businessService;
    }
}
