package com.ejianc.business.zdkcg.vo;

import java.util.Date;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 帮助中心
 * 
 * @author liyj
 * 
 */
public class WebsiteHelpVO extends BaseVO {
    private static final long serialVersionUID = 1L;

	/**
	 * 版本
	 */
    private String edition;

	/**
	 * 标题
	 */
    private String title;

	/**
	 * 试用区域
	 */
    private String trialArea;

	/**
	 * 状态(1启用，0停用)
	 */
    private String state;

	/**
	 * 发布人
	 */
    private String publisher;

	/**
	 * 发布时间
	 */
	@JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
	private Date publishTime;

	private Long orgId; // 发布组织ID

	private Integer publishFlag; // 是否发布 ， 1：发布 ， 0：未发布

	private Integer topFlag; // 是否置顶, 1:置顶 ， 0： 取消置顶

	/**
	 * 说明
	 */
    private String explanation;

	/**
	 * 文件大小
	 */
    private String fileSize;

	/**
	 * 文件名称
	 */
    private String fileName;

	/**
	 * 文件地址
	 */
    private String filePath;

	/**
	 * 文件大小
	 */
    private String file;

	/**
	 * 类型：tool:工具软件下载，operatevideo：操作视频，operateguide：操作指引
	 */
    private String type;

	public String getEdition() {
		return edition;
	}

	public void setEdition(String edition) {
		this.edition = edition;
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public String getTrialArea() {
		return trialArea;
	}

	public void setTrialArea(String trialArea) {
		this.trialArea = trialArea;
	}

	public String getState() {
		return state;
	}

	public void setState(String state) {
		this.state = state;
	}

	public String getPublisher() {
		return publisher;
	}

	public void setPublisher(String publisher) {
		this.publisher = publisher;
	}

	public String getExplanation() {
		return explanation;
	}

	public void setExplanation(String explanation) {
		this.explanation = explanation;
	}

	public String getFileSize() {
		return fileSize;
	}

	public void setFileSize(String fileSize) {
		this.fileSize = fileSize;
	}

	public Date getPublishTime() {
		return publishTime;
	}

	public void setPublishTime(Date publishTime) {
		this.publishTime = publishTime;
	}

    @ReferSerialTransfer(referCode="idm-org")
	public Long getOrgId() {
		return orgId;
	}

    @ReferDeserialTransfer
	public void setOrgId(Long orgId) {
		this.orgId = orgId;
	}

	public Integer getPublishFlag() {
		return publishFlag;
	}

	public void setPublishFlag(Integer publishFlag) {
		this.publishFlag = publishFlag;
	}

	public Integer getTopFlag() {
		return topFlag;
	}

	public void setTopFlag(Integer topFlag) {
		this.topFlag = topFlag;
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	public String getFile() {
		return file;
	}

	public void setFile(String file) {
		this.file = file;
	}

	public String getFileName() {
		return fileName;
	}

	public void setFileName(String fileName) {
		this.fileName = fileName;
	}

	public String getFilePath() {
		return filePath;
	}

	public void setFilePath(String filePath) {
		this.filePath = filePath;
	}

}
