package com.ejianc.business.zdkcg.vo;

import java.util.Date;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 咨询动态、招标公告、党的建设、关于我们
 * 
 * @author liyj
 * 
 */
public class WebsiteNewsVO extends BaseVO {
    private static final long serialVersionUID = 1L;

	private String title; // 新闻标题

	private Long orgId; // 发布组织ID

	private String orgName; // 发布组织ID

	private Integer shelvesFlag; // 是否上架 ， 1：上架 ， 0：下架

	private String publishUser; // 发布人

	@JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
	private Date publishTime; // 发布时间

	private String introduce; // 简介

	private Integer topFlag; // 是否置顶, 1:置顶 ， 0： 取消置顶

	private String content; // 内容

	private String author; // 作者

	private Integer billState; // 单据状态

	/**
	 * 类型（资讯动态:(info-info：平台资讯，info-industry：行业资讯，info-company：平台信息);
	 * 		招标公告: (bidding-change:变更公告，bidding-error：招标异常，bidding-bidcandidate：中标候选人公示，bidding-bid：中标公示，bidding-announcement：招标公告)
	 * 		（货物：goods，工程：engineering，服务：service----如：变更公告货物：bidding-change-goods）
	 * 		党的建设（party-special:党建专题,party-trends:党建动态,party-cultural:文化园地）
	 * 		关于我们（aboutus）
	 * ）
	 */
	private String type; // 
	
	private String typeName; // 参照显示类型用

	private String picPath; // 首图

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

    @ReferSerialTransfer(referCode="idm-org")
	public Long getOrgId() {
		return orgId;
	}

    @ReferDeserialTransfer
	public void setOrgId(Long orgId) {
		this.orgId = orgId;
	}
	private Integer viewNum = 0; //

	public Integer getShelvesFlag() {
		return shelvesFlag;
	}

	public void setShelvesFlag(Integer shelvesFlag) {
		this.shelvesFlag = shelvesFlag;
	}

	public String getPublishUser() {
		return publishUser;
	}

	public void setPublishUser(String publishUser) {
		this.publishUser = publishUser;
	}

	public Date getPublishTime() {
		return publishTime;
	}

	public void setPublishTime(Date publishTime) {
		this.publishTime = publishTime;
	}

	public String getIntroduce() {
		return introduce;
	}

	public void setIntroduce(String introduce) {
		this.introduce = introduce;
	}

	public Integer getTopFlag() {
		return topFlag;
	}

	public void setTopFlag(Integer topFlag) {
		this.topFlag = topFlag;
	}

	public String getContent() {
		return content;
	}

	public void setContent(String content) {
		this.content = content;
	}

	public String getAuthor() {
		return author;
	}

	public void setAuthor(String author) {
		this.author = author;
	}

	public Integer getBillState() {
		return billState;
	}

	public void setBillState(Integer billState) {
		this.billState = billState;
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	public String getTypeName() {

		 /* 类型（资讯动态:(info-info：资讯动态，info-industry：行业资讯，info-company：平台信息);
		 * 		招标公告: (bidding-change:变更公告，bidding-error：招标异常，bidding-bidcandidate：中标候选人公示，bidding-bid：中标公示，bidding-announcement：招标公告)
		 * 		（货物：goods，工程：engineering，服务：service----如：变更公告货物：bidding-change-goods）
		 * 		党的建设（party-special:党建专题,party-trends:党建动态,party-cultural:文化园地）
		 * 		关于我们（aboutus）
		 */
		String typeNameValue = type;
		switch(type){
			case "info-info":
				typeNameValue = "平台资讯";
				break;
			case "info-industry":
				typeNameValue = "行业资讯";
				break;
			case "info-company":
				typeNameValue = "平台信息";
				break;
			case "bidding-change-goods":
				typeNameValue = "变更公告(货物)";
				break;
			case "bidding-change-engineering":
				typeNameValue = "变更公告(工程)";
				break;
			case "bidding-change-service":
				typeNameValue = "变更公告(服务)";
				break;
			case "bidding-error-goods":
				typeNameValue = "招标异常(货物)";
				break;
			case "bidding-error-engineering":
				typeNameValue = "招标异常(工程)";
				break;
			case "bidding-error-service":
				typeNameValue = "招标异常(服务)";
				break;
			case "bidding-bidcandidate-goods":
				typeNameValue = "中标候选人公示(货物)";
				break;
			case "bidding-bidcandidate-engineering":
				typeNameValue = "中标候选人公示(工程)";
				break;
			case "bidding-bidcandidate-service":
				typeNameValue = "中标候选人公示(服务)";
				break;
			case "bidding-bid-goods":
				typeNameValue = "中标公示(货物)";
				break;
			case "bidding-bid-engineering":
				typeNameValue = "中标公示(工程)";
				break;
			case "bidding-bid-service":
				typeNameValue = "中标公示(服务)";
				break;
			case "bidding-announcement-goods":
				typeNameValue = "招标公告(货物)";
				break;
			case "bidding-announcement-engineering":
				typeNameValue = "招标公告(工程)";
				break;
			case "bidding-announcement-service":
				typeNameValue = "招标公告(服务)";
				break;
			case "party-special":
				typeNameValue = "党建专题";
				break;
			case "party-trends":
				typeNameValue = "党建动态";
				break;
			case "party-cultural":
				typeNameValue = "文化园地";
				break;
			case "aboutus":
				typeNameValue = "关于我们";
				break;
		}
		return typeNameValue;
	}

	public void setTypeName(String typeName) {
		this.typeName = typeName;
	}

	public Integer getViewNum() {
		return viewNum;
	}

	public void setViewNum(Integer viewNum) {
		this.viewNum = viewNum;
	}

	public String getPicPath() {
		return picPath;
	}

	public void setPicPath(String picPath) {
		this.picPath = picPath;
	}

	public String getOrgName() {
		return orgName;
	}

	public void setOrgName(String orgName) {
		this.orgName = orgName;
	}
	
}
