/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdkcg.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdkcg.bean.ApplyEntity;
import com.ejianc.business.zdkcg.service.IApplyService;
import com.ejianc.business.zdkcg.vo.ApplyVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"apply"})
public class ApplyController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String EJC_ZDKCG_APPLY_BILL_CODE = "EJC_ZDKCG_APPLY";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IApplyService service;
    @Autowired
    private IBillCodeApi billCodeApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ApplyVO> saveOrUpdate(@RequestBody ApplyVO saveorUpdateVO) {
        ApplyEntity entity = (ApplyEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, ApplyEntity.class));
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (StringUtils.isEmpty((CharSequence)entity.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(EJC_ZDKCG_APPLY_BILL_CODE, tenantId);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c\u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        ApplyVO vo = (ApplyVO)BeanMapper.map((Object)((Object)entity), ApplyVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ApplyVO> queryDetail(Long id) {
        ApplyEntity entity = (ApplyEntity)((Object)this.service.selectById(id));
        ApplyVO vo = (ApplyVO)BeanMapper.map((Object)((Object)entity), ApplyVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ApplyVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ApplyVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        fuzzyFields.add("orgAgencyName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ApplyVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        fuzzyFields.add("orgAgencyName");
        param.setPageIndex(1);
        param.setPageSize(10000);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage pageData = this.service.queryPage(param, false);
        List list = new ArrayList();
        if (null != pageData.getRecords() && CollectionUtils.isNotEmpty((Collection)pageData.getRecords())) {
            list = BeanMapper.mapList((Iterable)pageData.getRecords(), ApplyVO.class);
            list.forEach(vo -> {
                vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
                if (vo.getPurchaseType() == 0) {
                    vo.setPurchaseTypeName("\u751f\u4ea7\u79d1\u7814\u7c7b");
                }
                if (vo.getPurchaseType() == 1) {
                    vo.setPurchaseTypeName("\u56fa\u5b9a\u8d44\u4ea7\u6295\u8d44\u7c7b");
                }
                if (vo.getPurchaseType() == 2) {
                    vo.setPurchaseTypeName("\u4f01\u4e1a\u7ecf\u8425\u6d88\u8017\u7c7b");
                }
                if (vo.getPurchaseType() == 3) {
                    vo.setPurchaseTypeName("\u79d1\u7814\u5916\u534f\u5916\u5305");
                }
                if (vo.getInvitationType() == 0) {
                    vo.setInvitationTypeName("\u5546\u57ce\u91c7\u8d2d");
                }
                if (vo.getInvitationType() == 1) {
                    vo.setInvitationTypeName("\u62db\u6807\u91c7\u8d2d");
                }
            });
        }
        HashMap beans = new HashMap();
        beans.put("records", list);
        ExcelExport.getInstance().export("applyExport.xlsx", beans, response);
    }

    @GetMapping(value={"/applyRef"})
    @ResponseBody
    public CommonResponse<IPage<ApplyVO>> applyRef(@RequestParam(defaultValue="1") Integer pageNumber, @RequestParam(defaultValue="10") Integer pageSize, @RequestParam(value="condition", required=false) String condition, @RequestParam(value="searchText", required=false) String searchText) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber.intValue());
        queryParam.setPageSize(pageSize.intValue());
        queryParam.setSearchText(searchText);
        queryParam.getFuzzyFields().add("orgName");
        queryParam.getFuzzyFields().add("orgAgencyName");
        ArrayList<Integer> billstate = new ArrayList<Integer>();
        billstate.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        billstate.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        queryParam.getParams().put("bill_state", new Parameter("in", billstate));
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getOrderMap().put("create_time", "desc");
        IPage pageData = this.service.queryPage(queryParam, false);
        List list = new ArrayList();
        if (null != pageData.getRecords() && CollectionUtils.isNotEmpty((Collection)pageData.getRecords())) {
            list = BeanMapper.mapList((Iterable)pageData.getRecords(), ApplyVO.class);
            list.forEach(vo -> {
                if (vo.getPurchaseType() == 0) {
                    vo.setPurchaseName("\u751f\u4ea7\u79d1\u7814\u7c7b");
                }
                if (vo.getPurchaseType() == 1) {
                    vo.setPurchaseName("\u56fa\u5b9a\u8d44\u4ea7\u6295\u8d44\u7c7b");
                }
                if (vo.getPurchaseType() == 2) {
                    vo.setPurchaseName("\u4f01\u4e1a\u7ecf\u8425\u6d88\u8017\u7c7b");
                }
                if (vo.getPurchaseType() == 3) {
                    vo.setPurchaseName("\u79d1\u7814\u5916\u534f\u5916\u5305");
                }
                if (vo.getInvitationType() == 0) {
                    vo.setInvitationTypeName("\u5546\u57ce\u91c7\u8d2d");
                }
                if (vo.getInvitationType() == 1) {
                    vo.setInvitationTypeName("\u62db\u6807\u91c7\u8d2d");
                }
            });
        }
        Page result = new Page(pageData.getCurrent(), pageData.getSize(), pageData.getTotal());
        result.setRecords(list);
        return CommonResponse.success((String)"\u91c7\u8d2d\u7533\u8bf7\u53c2\u7167\u67e5\u8be2\u6210\u529f\uff01", (Object)result);
    }
}

