/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdkcg.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdkcg.bean.ApplyEntity;
import com.ejianc.business.zdkcg.bean.TenderEntity;
import com.ejianc.business.zdkcg.service.IApplyService;
import com.ejianc.business.zdkcg.service.ITenderService;
import com.ejianc.business.zdkcg.vo.TenderDetailVO;
import com.ejianc.business.zdkcg.vo.TenderVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"tender"})
public class TenderController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ITenderService service;
    @Autowired
    private IApplyService applyService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<TenderVO> saveOrUpdate(@RequestBody TenderVO saveorUpdateVO) {
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)this.service.saveOrUpdate(saveorUpdateVO));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<TenderVO> queryDetail(Long id) {
        TenderEntity entity = (TenderEntity)((Object)this.service.selectById(id));
        TenderVO vo = (TenderVO)BeanMapper.map((Object)((Object)entity), TenderVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryCopyDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<TenderVO> queryCopyDetail(Long id) {
        ApplyEntity applyEntity = (ApplyEntity)((Object)this.applyService.selectById(id));
        TenderVO vo = (TenderVO)BeanMapper.map((Object)((Object)applyEntity), TenderVO.class);
        vo.setApplyId(applyEntity.getId());
        vo.setApplyCode(applyEntity.getBillCode());
        vo.setId(null);
        vo.setCreateTime(null);
        vo.setCreateUserCode(null);
        vo.setUpdateTime(null);
        vo.setUpdateUserCode(null);
        vo.setBillState(Integer.valueOf(0));
        vo.setBillCode(null);
        List tenderDetail = new ArrayList();
        if (CollectionUtils.isNotEmpty(applyEntity.getApplyDetail())) {
            tenderDetail = BeanMapper.mapList(applyEntity.getApplyDetail(), TenderDetailVO.class);
            tenderDetail.forEach(e -> {
                e.setApplyDetailId(e.getId());
                e.setRowState("add");
            });
            vo.setTenderDetail(tenderDetail);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<TenderVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<TenderVO>> queryList(@RequestBody QueryParam param) {
        param.setFuzzyFields(Arrays.asList("billCode", "projectName", "orgAgencyName", "orgName", "supplierName"));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), TenderVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

