/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdkcg.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdkcg.bean.TenderPublishEntity;
import com.ejianc.business.zdkcg.service.ITenderPublishService;
import com.ejianc.business.zdkcg.vo.TenderPublishVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"publish"})
public class TenderPublishController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String EJC_ZDKCG_PUBLISH_BILL_CODE = "EJC_ZDKCG_PUBLISH";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ITenderPublishService service;
    @Autowired
    private IBillCodeApi billCodeApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<TenderPublishVO> saveOrUpdate(@RequestBody TenderPublishVO saveorUpdateVO) {
        TenderPublishEntity entity = (TenderPublishEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, TenderPublishEntity.class));
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (StringUtils.isEmpty((CharSequence)entity.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(EJC_ZDKCG_PUBLISH_BILL_CODE, tenantId);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c\u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        TenderPublishVO vo = (TenderPublishVO)BeanMapper.map((Object)((Object)entity), TenderPublishVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<TenderPublishVO> queryDetail(Long id) {
        TenderPublishEntity entity = (TenderPublishEntity)((Object)this.service.selectById(id));
        TenderPublishVO vo = (TenderPublishVO)BeanMapper.map((Object)((Object)entity), TenderPublishVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<TenderPublishVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<TenderPublishVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        fuzzyFields.add("orgAgencyName");
        fuzzyFields.add("billCode");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), TenderPublishVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        fuzzyFields.add("orgAgencyName");
        param.setPageIndex(1);
        param.setPageSize(10000);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage pageData = this.service.queryPage(param, false);
        List list = new ArrayList();
        if (null != pageData.getRecords() && CollectionUtils.isNotEmpty((Collection)pageData.getRecords())) {
            list = BeanMapper.mapList((Iterable)pageData.getRecords(), TenderPublishVO.class);
            list.forEach(vo -> {
                vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
                if (vo.getPurchaseType() == 0) {
                    vo.setPurchaseTypeName("\u751f\u4ea7\u79d1\u7814\u7c7b");
                }
                if (vo.getPurchaseType() == 1) {
                    vo.setPurchaseTypeName("\u56fa\u5b9a\u8d44\u4ea7\u6295\u8d44\u7c7b");
                }
                if (vo.getPurchaseType() == 2) {
                    vo.setPurchaseTypeName("\u4f01\u4e1a\u7ecf\u8425\u6d88\u8017\u7c7b");
                }
                if (vo.getPurchaseType() == 3) {
                    vo.setPurchaseTypeName("\u79d1\u7814\u5916\u534f\u5916\u5305");
                }
                if (vo.getZbType() == 0) {
                    vo.setZbTypeName("\u516c\u5f00\u62db\u6807");
                }
                if (vo.getZbType() == 1) {
                    vo.setZbTypeName("\u9080\u8bf7\u62db\u6807");
                }
                if (vo.getZbType() == 2) {
                    vo.setZbTypeName("\u8be2\u4ef7");
                }
                if (vo.getZbType() == 3) {
                    vo.setZbTypeName("\u5e94\u6025\u91c7\u8d2d");
                }
                if (vo.getZbType() == 4) {
                    vo.setZbTypeName("\u5355\u4e00\u6765\u6e90");
                }
            });
        }
        HashMap beans = new HashMap();
        beans.put("records", list);
        ExcelExport.getInstance().export("publishExport.xlsx", beans, response);
    }
}

