package com.ejianc.business.zdscost.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import com.ejianc.business.zdscost.vo.BudgetProjectDetailChangeVO;

/**
 * 切包清单变更
 *
 * @author generator
 *
 */
@ApiModel("切包清单变更")
public class BudgetProjectChangeVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("单据编号")
    private String billCode;
    @ApiModelProperty("组织主键")
    private Long orgId;
    @ApiModelProperty("组织名称")
    private String orgName;
    @ApiModelProperty("erp项目id")
    private String projectSid;
    @ApiModelProperty("项目")
    private Long projectId;
    @ApiModelProperty("项目编码")
    private String projectCode;
    @ApiModelProperty("项目名称")
    private String projectName;
    @ApiModelProperty("工程包数量")
    private Integer engineeringPackNum;
    @ApiModelProperty("材料包数量")
    private Integer materialPackNum;
    @ApiModelProperty("单据状态")
    private Integer billState;
    @ApiModelProperty("单据日期")
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    private Date billDate;
    @ApiModelProperty("经办人")
    private Long employeeId;
    @ApiModelProperty("经办人")
    private String employeeName;
    @ApiModelProperty("变更状态(1-未变更 2-变更中 3-已变更)")
    private Integer changeStatus;
    @ApiModelProperty("变更版本号")
    private Integer changeVersion;
    @ApiModelProperty("变更主键")
    private Long changeId;
    @ApiModelProperty("变更单号")
    private String changeCode;
    @ApiModelProperty("变更原因")
    private String changeReason;
    @ApiModelProperty("生效时间")
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date effectiveTime;
    @ApiModelProperty("备注")
    private String memo;
    private String orgCode; // 单据组织编码
    private Long parentOrgId; // 上级组织id
    private String parentOrgName; // 上级组织名称
    private String parentOrgCode; // 上级组织编码
    private String optType; // 操作类型
    private String identificationId; // 物料识别唯一标识
    private Integer identificationState; // 物料识别状态

    @ApiModelProperty("切包清单变更-明细")
    private List<BudgetProjectDetailChangeVO> budgetProjectDetailList = new ArrayList<>();

    // 按包展示，树形结构
    private List<BudgetProjectDetailPackageVO> packageTreeData = new ArrayList<>();

    public String getIdentificationId() {
        return identificationId;
    }

    public void setIdentificationId(String identificationId) {
        this.identificationId = identificationId;
    }

    public Integer getIdentificationState() {
        return identificationState;
    }

    public void setIdentificationState(Integer identificationState) {
        this.identificationState = identificationState;
    }

    public List<BudgetProjectDetailPackageVO> getPackageTreeData() {
        return packageTreeData;
    }

    public void setPackageTreeData(List<BudgetProjectDetailPackageVO> packageTreeData) {
        this.packageTreeData = packageTreeData;
    }

    public String getOptType() {
        return optType;
    }

    public void setOptType(String optType) {
        this.optType = optType;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    /**
     * 组织主键
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织主键
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    /**
     * erp项目id
     */
    public String getProjectSid() {
        return projectSid;
    }

    /**
     * erp项目id
     */
    public void setProjectSid(String projectSid) {
        this.projectSid = projectSid;
    }

    @ReferSerialTransfer(referCode = "project-set")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    /**
     * 项目编码
     */
    public String getProjectCode() {
        return projectCode;
    }

    /**
     * 项目编码
     */
    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    /**
     * 工程包数量
     */
    public Integer getEngineeringPackNum() {
        return engineeringPackNum;
    }

    /**
     * 工程包数量
     */
    public void setEngineeringPackNum(Integer engineeringPackNum) {
        this.engineeringPackNum = engineeringPackNum;
    }

    /**
     * 材料包数量
     */
    public Integer getMaterialPackNum() {
        return materialPackNum;
    }

    /**
     * 材料包数量
     */
    public void setMaterialPackNum(Integer materialPackNum) {
        this.materialPackNum = materialPackNum;
    }

    /**
     * 单据状态
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    /**
     * 单据日期
     */
    public Date getBillDate() {
        return billDate;
    }

    /**
     * 单据日期
     */
    public void setBillDate(Date billDate) {
        this.billDate = billDate;
    }

    /**
     * 经办人
     */
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 经办人
     */
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    /**
     * 经办人
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 经办人
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    /**
     * 变更状态(1-未变更 2-变更中 3-已变更)
     */
    public Integer getChangeStatus() {
        return changeStatus;
    }

    /**
     * 变更状态(1-未变更 2-变更中 3-已变更)
     */
    public void setChangeStatus(Integer changeStatus) {
        this.changeStatus = changeStatus;
    }

    /**
     * 变更版本号
     */
    public Integer getChangeVersion() {
        return changeVersion;
    }

    /**
     * 变更版本号
     */
    public void setChangeVersion(Integer changeVersion) {
        this.changeVersion = changeVersion;
    }

    /**
     * 变更主键
     */
    public Long getChangeId() {
        return changeId;
    }

    /**
     * 变更主键
     */
    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }

    /**
     * 变更单号
     */
    public String getChangeCode() {
        return changeCode;
    }

    /**
     * 变更单号
     */
    public void setChangeCode(String changeCode) {
        this.changeCode = changeCode;
    }

    /**
     * 变更原因
     */
    public String getChangeReason() {
        return changeReason;
    }

    /**
     * 变更原因
     */
    public void setChangeReason(String changeReason) {
        this.changeReason = changeReason;
    }

    /**
     * 生效时间
     */
    public Date getEffectiveTime() {
        return effectiveTime;
    }

    /**
     * 生效时间
     */
    public void setEffectiveTime(Date effectiveTime) {
        this.effectiveTime = effectiveTime;
    }

    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }

    public List<BudgetProjectDetailChangeVO> getBudgetProjectDetailList() {
        return budgetProjectDetailList;
    }

    public void setBudgetProjectDetailList(List<BudgetProjectDetailChangeVO> budgetProjectDetailList) {
        this.budgetProjectDetailList = budgetProjectDetailList;
    }
}
