package com.ejianc.business.zdsmaterial.accept;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.ArrayList;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 物资验收
 * 
 * @author generator
 * 
 */
public class AcceptVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long contractId; // 合同id
    private String contractName; // 合同
    private String contractCode; // 合同编码
    private Long supplierId; // 供应商id
    private String supplierName; // 供应商
    private String supplierCode; // 供应商编码
    private Long siteAcceptorId; // 现场验收人id
    private String siteAcceptorName; // 现场验收人name
    private String siteAcceptorCode; // 现场验收人编码
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date pickupDate; // 验收日期
    private String deliveryBillCode; // 发货单编码
    private Long deliveryBillId; // 发货单id
    private String orderBillCode; // 订单编码
    private String orderBillName; // 订单名称
    private Long orderBillId; // 订单id
    private Integer finalAcceptFlag; // 基于发货单的全部验收（最终验收标识）：0-否，1-是 [如果发货单数量与验收数量匹配，则自动全部验收]，自制验收时为0
    private Integer sourceType; // 来源类型：0:来源发货单;1:自制;2:其他验收
    private Integer closeDelivery; // 0 不关闭 ；1 关闭
    private Long projectId; // 项目id
    private String projectName; // 项目名称
    private String projectCode; // 项目编码
    private Long orgId; // 单据组织id
    private String orgName; // 单据组织名称
    private String orgCode; // 单据组织编码
    private Long parentOrgId; // 上级组织id
    private String parentOrgName; // 上级组织名称
    private String parentOrgCode; // 上级组织编码
    private String billCode; // 单据编码
    private Integer billState; // 单据状态
    private String supplierLinkName; // 供应商联系人
    private String supplierLinkPhone; // 供应商联系人手机号
    private String carCode; // 车牌号
    private Integer acceptType; // 验收方式 0:正常验收;1:直入直出; 
    private Integer billType; // 业务类型：0-采购验收；1:甲供材入库(选档案库); 2:临建入库(选档案库)
    private Integer newMatFlag; // 是否有新增材料编码：0-否，1-是
    private Integer hasNewPropertyVal; // 是否有新增属性：0-否，1-是
    private Long storeId; // 仓库id
    private String storeName; // 仓库名称
    private Integer storeType; // 仓库类型：1-主材库；2-临建材料，3-甲供材
    private String partUsed; // 使用部位
    private String memo; // 备注
    private String acceptMemo; // 验收说明
    private String originalFileIds; // 原始单据图片ids
    private String sceneFileIds; // 现场图片ids

    private Long pickContractId; // 领料合同id
    private String pickContractName; // 领料合同
    private String pickContractCode; // 领料合同编码

    private Long subcontractorId; // 分包商id
    private String subcontractorName; // 分包商
    private String subcontractorCode; // 分包商编码

    private Long subcontractorUserId; // 分包领料人
    private String subcontractorUserName; // 分包领料人名称
    private Long subcontractorUserPhone; // 分包领料人手机号

    private BigDecimal acceptTaxMny;//验收金额

    private String acceptTypeStr;
    private String storeTypeStr;
    private String sourceTypeStr;
    private String signatureStatusStr;
    private String billStateName;
//    private String createUserName;// 编制者名称
    private String materialNames; // 验收材料字段拼接
    private String deliveryBillCodeString; // 来源发货单编码
    private String acceptContent; // 验收内容
    private String siteAcceptorLinkPhone; //现场验收人电话


    //项目方签字信息
    private Long signatureUserId;//签字人id
    private Long signatureId;//签字id
    private String signatureUserName;//签字人名称
    private String signatureUserPhone;//签字人手机号
    @JsonFormat(pattern = "yyyy-MM-dd HH-mm-ss", timezone = "GMT+8")
    private Date signatureDate ;//签字人签字时间
    private Integer signatureStatus; // 签字状态 0:未签字;1:已签字;
    //物资分包商签字信息
    private Long materialSignatureUserId;//签字人id
    private Long materialSignatureId;//签字id
    private String materialSignatureUserName;//签字人名称
    private String materialSignatureUserPhone;//签字人手机号
    @JsonFormat(pattern = "yyyy-MM-dd HH-mm-ss", timezone = "GMT+8")
    private Date materialSignatureDate ;//签字人签字时间
    private Integer materialSignatureStatus; // 签字状态 0:未签字;1:已签字;
    //分包合同分包商签字信息
    private Long subSignatureUserId;//签字人id
    private Long subSignatureId;//签字id
    private String subSignatureUserName;//签字人名称
    private String subSignatureUserPhone;//签字人手机号
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date subSignatureDate;//签字人签字时间
    private Integer subSignatureStatus; // 签

    @JsonFormat(pattern = "yyyy-MM-dd HH-mm-ss", timezone = "GMT+8")
    private Date exactTime; // 确认时间

    public Date getExactTime() {
        return exactTime;
    }

    public void setExactTime(Date exactTime) {
        this.exactTime = exactTime;
    }
    public Long getSignatureUserId() {
        return signatureUserId;
    }

    public void setSignatureUserId(Long signatureUserId) {
        this.signatureUserId = signatureUserId;
    }

    public Long getSignatureId() {
        return signatureId;
    }

    public void setSignatureId(Long signatureId) {
        this.signatureId = signatureId;
    }

    public String getSignatureUserName() {
        return signatureUserName;
    }

    public void setSignatureUserName(String signatureUserName) {
        this.signatureUserName = signatureUserName;
    }

    public String getSignatureUserPhone() {
        return signatureUserPhone;
    }

    public void setSignatureUserPhone(String signatureUserPhone) {
        this.signatureUserPhone = signatureUserPhone;
    }

    public Date getSignatureDate() {
        return signatureDate;
    }

    public void setSignatureDate(Date signatureDate) {
        this.signatureDate = signatureDate;
    }

    public Integer getSignatureStatus() {
        return signatureStatus;
    }

    public void setSignatureStatus(Integer signatureStatus) {
        this.signatureStatus = signatureStatus;
    }

    public Long getMaterialSignatureUserId() {
        return materialSignatureUserId;
    }

    public void setMaterialSignatureUserId(Long materialSignatureUserId) {
        this.materialSignatureUserId = materialSignatureUserId;
    }

    public Long getMaterialSignatureId() {
        return materialSignatureId;
    }

    public void setMaterialSignatureId(Long materialSignatureId) {
        this.materialSignatureId = materialSignatureId;
    }

    public String getMaterialSignatureUserName() {
        return materialSignatureUserName;
    }

    public void setMaterialSignatureUserName(String materialSignatureUserName) {
        this.materialSignatureUserName = materialSignatureUserName;
    }

    public String getMaterialSignatureUserPhone() {
        return materialSignatureUserPhone;
    }

    public void setMaterialSignatureUserPhone(String materialSignatureUserPhone) {
        this.materialSignatureUserPhone = materialSignatureUserPhone;
    }

    public Date getMaterialSignatureDate() {
        return materialSignatureDate;
    }

    public void setMaterialSignatureDate(Date materialSignatureDate) {
        this.materialSignatureDate = materialSignatureDate;
    }

    public Integer getMaterialSignatureStatus() {
        return materialSignatureStatus;
    }

    public void setMaterialSignatureStatus(Integer materialSignatureStatus) {
        this.materialSignatureStatus = materialSignatureStatus;
    }

    public Long getSubSignatureUserId() {
        return subSignatureUserId;
    }

    public void setSubSignatureUserId(Long subSignatureUserId) {
        this.subSignatureUserId = subSignatureUserId;
    }

    public Long getSubSignatureId() {
        return subSignatureId;
    }

    public void setSubSignatureId(Long subSignatureId) {
        this.subSignatureId = subSignatureId;
    }

    public String getSubSignatureUserName() {
        return subSignatureUserName;
    }

    public void setSubSignatureUserName(String subSignatureUserName) {
        this.subSignatureUserName = subSignatureUserName;
    }

    public String getSubSignatureUserPhone() {
        return subSignatureUserPhone;
    }

    public void setSubSignatureUserPhone(String subSignatureUserPhone) {
        this.subSignatureUserPhone = subSignatureUserPhone;
    }

    public Date getSubSignatureDate() {
        return subSignatureDate;
    }

    public void setSubSignatureDate(Date subSignatureDate) {
        this.subSignatureDate = subSignatureDate;
    }

    public Integer getSubSignatureStatus() {
        return subSignatureStatus;
    }

    public void setSubSignatureStatus(Integer subSignatureStatus) {
        this.subSignatureStatus = subSignatureStatus;
    }

    public String getSiteAcceptorLinkPhone() {
        return siteAcceptorLinkPhone;
    }

    public void setSiteAcceptorLinkPhone(String siteAcceptorLinkPhone) {
        this.siteAcceptorLinkPhone = siteAcceptorLinkPhone;
    }

    public String getAcceptContent() {
        return acceptContent;
    }

    public void setAcceptContent(String acceptContent) {
        this.acceptContent = acceptContent;
    }

    public String getDeliveryBillCodeString() {
        return deliveryBillCodeString;
    }

    public void setDeliveryBillCodeString(String deliveryBillCodeString) {
        this.deliveryBillCodeString = deliveryBillCodeString;
    }

    public String getMaterialNames() {
        return materialNames;
    }

    public void setMaterialNames(String materialNames) {
        this.materialNames = materialNames;
    }


    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public String getAcceptTypeStr() {
        return acceptTypeStr;
    }

    public void setAcceptTypeStr(String acceptTypeStr) {
        this.acceptTypeStr = acceptTypeStr;
    }

    public String getStoreTypeStr() {
        return storeTypeStr;
    }

    public void setStoreTypeStr(String storeTypeStr) {
        this.storeTypeStr = storeTypeStr;
    }

    public String getSourceTypeStr() {
        return sourceTypeStr;
    }

    public void setSourceTypeStr(String sourceTypeStr) {
        this.sourceTypeStr = sourceTypeStr;
    }

    public String getSignatureStatusStr() {
        return signatureStatusStr;
    }

    public void setSignatureStatusStr(String signatureStatusStr) {
        this.signatureStatusStr = signatureStatusStr;
    }

    public Integer getCloseDelivery() {
        return closeDelivery;
    }

    public void setCloseDelivery(Integer closeDelivery) {
        this.closeDelivery = closeDelivery;
    }

    public BigDecimal getAcceptTaxMny() {
        return acceptTaxMny;
    }

    public void setAcceptTaxMny(BigDecimal acceptTaxMny) {
        this.acceptTaxMny = acceptTaxMny;
    }

    private List<AcceptDetailVO> detailList = new ArrayList<>(); // 物资验收-清单

    public String getOrderBillName() {
        return orderBillName;
    }

    public void setOrderBillName(String orderBillName) {
        this.orderBillName = orderBillName;
    }
    @ReferSerialTransfer(referCode="zds-ref-cont")
    public Long getContractId() {
        return contractId;
    }
    @ReferDeserialTransfer
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    @ReferSerialTransfer(referCode="zds-mat-supplier")
    public Long getSupplierId() {
        return supplierId;
    }
    @ReferDeserialTransfer
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public String getSupplierCode() {
        return supplierCode;
    }

    public void setSupplierCode(String supplierCode) {
        this.supplierCode = supplierCode;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getSiteAcceptorId() {
        return siteAcceptorId;
    }
    @ReferDeserialTransfer
    public void setSiteAcceptorId(Long siteAcceptorId) {
        this.siteAcceptorId = siteAcceptorId;
    }
    public String getSiteAcceptorName() {
        return siteAcceptorName;
    }

    public void setSiteAcceptorName(String siteAcceptorName) {
        this.siteAcceptorName = siteAcceptorName;
    }
    public String getSiteAcceptorCode() {
        return siteAcceptorCode;
    }

    public void setSiteAcceptorCode(String siteAcceptorCode) {
        this.siteAcceptorCode = siteAcceptorCode;
    }
    public Date getPickupDate() {
        return pickupDate;
    }

    public void setPickupDate(Date pickupDate) {
        this.pickupDate = pickupDate;
    }
    public String getDeliveryBillCode() {
        return deliveryBillCode;
    }

    public void setDeliveryBillCode(String deliveryBillCode) {
        this.deliveryBillCode = deliveryBillCode;
    }
    @ReferSerialTransfer(referCode="zds-deli-ref")
    public Long getDeliveryBillId() {
        return deliveryBillId;
    }
    @ReferDeserialTransfer
    public void setDeliveryBillId(Long deliveryBillId) {
        this.deliveryBillId = deliveryBillId;
    }
    public String getOrderBillCode() {
        return orderBillCode;
    }

    public void setOrderBillCode(String orderBillCode) {
        this.orderBillCode = orderBillCode;
    }

    @ReferSerialTransfer(referCode="zds-ref-order")
    public Long getOrderBillId() {
        return orderBillId;
    }
    @ReferDeserialTransfer
    public void setOrderBillId(Long orderBillId) {
        this.orderBillId = orderBillId;
    }
    public Integer getFinalAcceptFlag() {
        return finalAcceptFlag;
    }

    public void setFinalAcceptFlag(Integer finalAcceptFlag) {
        this.finalAcceptFlag = finalAcceptFlag;
    }
    public Integer getSourceType() {
        return sourceType;
    }

    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }
    @ReferSerialTransfer(referCode="project-set")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getSupplierLinkName() {
        return supplierLinkName;
    }

    public void setSupplierLinkName(String supplierLinkName) {
        this.supplierLinkName = supplierLinkName;
    }
    public String getSupplierLinkPhone() {
        return supplierLinkPhone;
    }

    public void setSupplierLinkPhone(String supplierLinkPhone) {
        this.supplierLinkPhone = supplierLinkPhone;
    }
    public String getCarCode() {
        return carCode;
    }

    public void setCarCode(String carCode) {
        this.carCode = carCode;
    }
    public Integer getAcceptType() {
        return acceptType;
    }

    public void setAcceptType(Integer acceptType) {
        this.acceptType = acceptType;
    }
    public Integer getBillType() {
        return billType;
    }

    public void setBillType(Integer billType) {
        this.billType = billType;
    }
    public Integer getNewMatFlag() {
        return newMatFlag;
    }

    public void setNewMatFlag(Integer newMatFlag) {
        this.newMatFlag = newMatFlag;
    }
    public Integer getHasNewPropertyVal() {
        return hasNewPropertyVal;
    }

    public void setHasNewPropertyVal(Integer hasNewPropertyVal) {
        this.hasNewPropertyVal = hasNewPropertyVal;
    }
    public Long getStoreId() {
        return storeId;
    }
    @ReferDeserialTransfer
    public void setStoreId(Long storeId) {
        this.storeId = storeId;
    }
    public String getStoreName() {
        return storeName;
    }

    public void setStoreName(String storeName) {
        this.storeName = storeName;
    }
    public Integer getStoreType() {
        return storeType;
    }

    public void setStoreType(Integer storeType) {
        this.storeType = storeType;
    }
    public String getPartUsed() {
        return partUsed;
    }

    public void setPartUsed(String partUsed) {
        this.partUsed = partUsed;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public String getAcceptMemo() {
        return acceptMemo;
    }

    public void setAcceptMemo(String acceptMemo) {
        this.acceptMemo = acceptMemo;
    }
    public String getOriginalFileIds() {
        return originalFileIds;
    }

    public void setOriginalFileIds(String originalFileIds) {
        this.originalFileIds = originalFileIds;
    }
    public String getSceneFileIds() {
        return sceneFileIds;
    }

    public void setSceneFileIds(String sceneFileIds) {
        this.sceneFileIds = sceneFileIds;
    }
    public Long getPickContractId() {
        return pickContractId;
    }
    @ReferDeserialTransfer
    public void setPickContractId(Long pickContractId) {
        this.pickContractId = pickContractId;
    }
    public String getPickContractName() {
        return pickContractName;
    }

    public void setPickContractName(String pickContractName) {
        this.pickContractName = pickContractName;
    }
    public String getPickContractCode() {
        return pickContractCode;
    }

    public void setPickContractCode(String pickContractCode) {
        this.pickContractCode = pickContractCode;
    }
    @ReferSerialTransfer(referCode="sub-contract-ref")
    public Long getSubcontractorId() {
        return subcontractorId;
    }
    @ReferDeserialTransfer
    public void setSubcontractorId(Long subcontractorId) {
        this.subcontractorId = subcontractorId;
    }
    public String getSubcontractorName() {
        return subcontractorName;
    }

    public void setSubcontractorName(String subcontractorName) {
        this.subcontractorName = subcontractorName;
    }
    public String getSubcontractorCode() {
        return subcontractorCode;
    }

    public void setSubcontractorCode(String subcontractorCode) {
        this.subcontractorCode = subcontractorCode;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getSubcontractorUserId() {
        return subcontractorUserId;
    }
    @ReferDeserialTransfer
    public void setSubcontractorUserId(Long subcontractorUserId) {
        this.subcontractorUserId = subcontractorUserId;
    }

    public String getSubcontractorUserName() {
        return subcontractorUserName;
    }

    public void setSubcontractorUserName(String subcontractorUserName) {
        this.subcontractorUserName = subcontractorUserName;
    }

    public Long getSubcontractorUserPhone() {
        return subcontractorUserPhone;
    }

    public void setSubcontractorUserPhone(Long subcontractorUserPhone) {
        this.subcontractorUserPhone = subcontractorUserPhone;
    }
    
     public List<AcceptDetailVO> getDetailList() {
        return detailList;
     }

     public void setDetailList(List<AcceptDetailVO> detailList) {
        this.detailList = detailList;
     }
}
