package com.ejianc.business.zdsmaterial.cons;

import java.util.HashMap;
import java.util.Map;

public class PlanConstant {

    /**
     * 布尔是否
     */
    public static final Integer INTEGER_NO = 0;
    public static final Integer INTEGER_YES = 1;
    public static final String STRING_NO = "0";
    public static final String STRING_YES = "1";
    public static final String SUB_SUPPLIER = "sub";// 分包供应商
    public static final String MAT_SUPPLIER = "material";// 物资供应商
    public static final String NEW_BILL_TYPE = "EJCBT202311000004";// 总控计划编制单据类型
    public static final String CHANGE_BILL_TYPE = "EJCBT202311000010";// 总控计划编制单据类型
    public static final String SUM_BILL_TYPE = "EJCBT202311000011";// 总控计划编制单据类型
    public static final String OUT_STORE_BILL_TYPE = "EJCBT202312000011";// 领料出库单据类型
    public static final String DISPOSE_BILL_TYPE = "EJCBT202312000012";// 处置申请单据类型
    public static final String SUB_FEE_APPLY_BILL_TYPE = "EJCBT202403000001";// 分包费用申请单据类型
    public static final String SUB_INVOICE_BILL_TYPE = "EJCBT202403000027";// 分包发票登记
    public static final String MAT_INVOICE_BILL_TYPE = "EJCBT202404000001";// 采购发票登记

    public static final String MAT_INVOICE_FILE_SOURCE_TYPE = "file01"; //采购发票附件 业务类型
    public static final String FEEDBACK_FILE_SOURCE_TYPE = "file01"; //采购发票附件 业务类型

    public static final String SYNC_MAT_INVOICE_TO_ERP_URL = "/cefoc/yql/AddProcureMEBillLists"; //新增采购发票推送ERP接口地址
    public static final String SYNC_SUB_INVOICE_TO_ERP_URL = "/cefoc/yql/AddSubContractorBillLists"; //新增分包发票推送ERP接口地址

    public static final String noPower = "无权限访问该服务，请先联系管理员进行授权！";

    public static final String UPLOAD_SOURCE_TYPE = "uploadFile";// 上传文件类型
    public static final String BILL_SOURCE_TYPE = "bill";// 附件管理文件类型
    /**
     * 变更状态(1-未变更 2-变更中 3-已变更)
     */
    public static final Integer CHANGE_NO = 1;
    public static final Integer CHANGE_ING = 2;
    public static final Integer CHANGE_OVER = 3;
    public static final Map<Integer, String> CHANGE_STATUS = new HashMap();
    public static final String EMPTY_STR = "00000000-0000-0000-0000-000000000000";

    static {
        CHANGE_STATUS.put(CHANGE_NO, "未变更");
        CHANGE_STATUS.put(CHANGE_ING, "变更中");
        CHANGE_STATUS.put(CHANGE_OVER, "已变更");
    }

    /**
     * 单据类型：1-编制，2-变更
     */
    public static final Integer BILL_TYPE_NEW = 1;
    public static final Integer BILL_TYPE_CHANGE = 2;
    public static final Map<Integer, String> BILL_TYPE = new HashMap();

    static {
        BILL_TYPE.put(BILL_TYPE_NEW, "编制");
        BILL_TYPE.put(BILL_TYPE_CHANGE, "变更");
    }

    /**
     * 行类型：1-新增，2-变更
     */
    public static final Integer ROW_TYPE_NEW = 1;
    public static final Integer ROW_TYPE_CHANGE = 2;
    public static final Integer ROW_TYPE_UNCHANGE = 3;
    public static final Map<Integer, String> ROW_TYPE = new HashMap();

    static {
        ROW_TYPE.put(ROW_TYPE_NEW, "新增");
        ROW_TYPE.put(ROW_TYPE_CHANGE, "变更");
    }

    /**
     * 来源：1-档案，2-新增
     */
    public static final Integer SOURCE_TYPE_REF = 1;
    public static final Integer SOURCE_TYPE_NEW = 2;
    public static final Map<Integer, String> SOURCE_TYPE = new HashMap();

    static {
        SOURCE_TYPE.put(SOURCE_TYPE_REF, "档案");
        SOURCE_TYPE.put(SOURCE_TYPE_NEW, "新增");
    }

    /**
     * 签字状态：0-未签字，1-已签字
     */
    public static final Integer SIGN_STATUS_NO = 0;
    public static final Integer SIGN_STATUS_YES = 1;
    public static final Map<Integer, String> SIGN_STATUS = new HashMap();

    static {
        SIGN_STATUS.put(SIGN_STATUS_NO, "未签字");
        SIGN_STATUS.put(SIGN_STATUS_YES, "已签字");
    }

    /**
     * 处置方式：1-战略,2-询比价
     */
    public static final Integer DISPOSE_TYPE_ONE = 1;
    public static final Integer DISPOSE_TYPE_TWO = 2;
    public static final Map<Integer, String> DISPOSE_TYPE = new HashMap();

    static {
        DISPOSE_TYPE.put(DISPOSE_TYPE_ONE, "战略");
        DISPOSE_TYPE.put(DISPOSE_TYPE_TWO, "询比价");
    }

    /**
     * 资产状态0-待上架，1-已上架，2-已下架
     */
    public static final Integer GOODS_STATUS_UN = 0;
    public static final Integer GOODS_STATUS_ON = 1;
    public static final Integer GOODS_STATUS_OUT = 2;
    public static final Map<Integer, String> GOODS_STATUS = new HashMap();

    static {
        GOODS_STATUS.put(GOODS_STATUS_UN, "待上架");
        GOODS_STATUS.put(GOODS_STATUS_ON, "已上架");
        GOODS_STATUS.put(GOODS_STATUS_OUT, "已下架");
    }

    /**
     * 下架类型0-手动下架，1-售罄下架，2-到期下架
     */
    public static final Integer OUT_TYPE_HAND = 0;
    public static final Integer OUT_TYPE_SALE = 1;
    public static final Integer OUT_TYPE_DATE = 2;
    public static final Map<Integer, String> OUT_TYPE = new HashMap();

    static {
        OUT_TYPE.put(OUT_TYPE_HAND, "手动下架");
        OUT_TYPE.put(OUT_TYPE_SALE, "售罄下架");
        OUT_TYPE.put(OUT_TYPE_DATE, "到期下架");
    }

    /**
     * 仓库属性 1-主材；3-甲供材；2-临建；4-大区
     */
    public static final Integer ATTR_FLAG_MAIN = 1;
    public static final Integer ATTR_FLAG_MATERIAL = 3;
    public static final Integer ATTR_FLAG_TEMP = 2;
    public static final Integer ATTR_FLAG_ORG = 4;

    public static final Map<Integer, String> ATTR_FLAG = new HashMap();

    static {
        ATTR_FLAG.put(ATTR_FLAG_MAIN, "主材");
        ATTR_FLAG.put(ATTR_FLAG_MATERIAL, "甲供材");
        ATTR_FLAG.put(ATTR_FLAG_TEMP, "临建");
        ATTR_FLAG.put(ATTR_FLAG_ORG, "大区");
    }

    /**
     * 仓库类型 1-项目；2-大区
     */
    public static final Integer STORE_TYPE_PROJECT = 1;
    public static final Integer STORE_TYPE_ORG = 2;
    public static final Map<Integer, String> STORE_TYPE = new HashMap();

    static {
        STORE_TYPE.put(STORE_TYPE_PROJECT, "项目");
        STORE_TYPE.put(STORE_TYPE_ORG, "大区");
    }

    /**
     * 来源方式，1-自制,2-供方发起
     */
    public static final Integer SOURCE_TYPE_EL = 1;
    public static final Integer SOURCE_TYPE_SUPPLIER = 2;
    public static final Map<Integer, String> OUT_SOURCE_TYPE = new HashMap();

    static {
        OUT_SOURCE_TYPE.put(SOURCE_TYPE_EL, "自制");
        OUT_SOURCE_TYPE.put(SOURCE_TYPE_SUPPLIER, "供方发起");
    }

    /**
     * 确认状态(0-待确认,1-已确认,2-已驳回）
     */
    public static final String CONFIRM_STATE_UN = "0";
    public static final String CONFIRM_STATE_FINISH = "1";
    public static final String CONFIRM_STATE_BACK = "2";
    public static final Map<String, String> CONFIRM_STATE = new HashMap();

    static {
        CONFIRM_STATE.put(CONFIRM_STATE_UN, "待确认");
        CONFIRM_STATE.put(CONFIRM_STATE_FINISH, "已确认");
        CONFIRM_STATE.put(CONFIRM_STATE_BACK, "已驳回");
    }

    /**
     * 匹配结果：1-完全匹配，2-历史匹配，3-模糊匹配
     */
    public static final Integer MATCH_SAME = 1;
    public static final Integer MATCH_HISTORY = 2;
    public static final Integer MATCH_LIKE = 3;
    public static final Map<Integer, String> MATCH_STATE = new HashMap();

    static {
        MATCH_STATE.put(MATCH_SAME, "完全匹配");
        MATCH_STATE.put(MATCH_HISTORY, "历史匹配");
        MATCH_STATE.put(MATCH_LIKE, "模糊匹配");
    }

    /**
     * 申请状态 0-待提交,1-待审核,2-分包未打印,3-分包已打印,4-已驳回,5-已报审,6-审批通过
     */
    public static final Integer APPLY_TYPE_UN_COMMIT = 0;
    public static final Integer APPLY_TYPE_UN_PROJECT = 1;
    public static final Integer APPLY_TYPE_UN_PRINT = 2;
    public static final Integer APPLY_TYPE_PRINT = 3;
    public static final Integer APPLY_TYPE_BACK = 4;
    public static final Integer APPLY_TYPE_COMMIT = 5;
    public static final Integer APPLY_TYPE_APPROVE = 6;
    public static final Map<Integer, String> APPLY_TYPE = new HashMap();

    static {
        APPLY_TYPE.put(APPLY_TYPE_UN_COMMIT, "待提交");
        APPLY_TYPE.put(APPLY_TYPE_UN_PROJECT, "待审核");
        APPLY_TYPE.put(APPLY_TYPE_UN_PRINT, "分包未打印");
        APPLY_TYPE.put(APPLY_TYPE_PRINT, "分包已打印");
        APPLY_TYPE.put(APPLY_TYPE_BACK, "已驳回");
        APPLY_TYPE.put(APPLY_TYPE_COMMIT, "分包已打印");
        APPLY_TYPE.put(APPLY_TYPE_APPROVE, "分包已打印");
    }

    /**
     * 审核状态(0-待审核,1-已审核,2-已驳回）
     */
    public static final String CHECK_STATE_UN = "0";
    public static final String CHECK_STATE_FINISH = "1";
    public static final String CHECK_STATE_BACK = "2";
    public static final Map<String, String> CHECK_STATE = new HashMap();

    static {
        CHECK_STATE.put(CHECK_STATE_UN, "待审核");
        CHECK_STATE.put(CHECK_STATE_FINISH, "已审核");
        CHECK_STATE.put(CHECK_STATE_BACK, "已驳回");
    }

    public static final String 采购费用申请_预付款 = "1";
    public static final String 采购费用申请_材料设备发货款 = "2";
    public static final String 采购费用申请_材料设备到货款 = "3";
    public static final String 采购费用申请_验收款 = "4";
    public static final String 采购费用申请_调试款 = "5";
    public static final String 采购费用申请_质保金 = "6";
    public static final Map<String, String> MAT_FEE_PATY_TYPE = new HashMap();

    static {
        MAT_FEE_PATY_TYPE.put(采购费用申请_预付款, "预付款");
        MAT_FEE_PATY_TYPE.put(采购费用申请_材料设备发货款, "材料设备发货款");
        MAT_FEE_PATY_TYPE.put(采购费用申请_材料设备到货款, "材料设备到货款");
        MAT_FEE_PATY_TYPE.put(采购费用申请_验收款, "验收款");
        MAT_FEE_PATY_TYPE.put(采购费用申请_调试款, "调试款");
        MAT_FEE_PATY_TYPE.put(采购费用申请_质保金, "质保金");
    }

    public static final String 发票类型_增值税专用发票 = "1";
    public static final String 发票种类_增值税普通发票 = "2";
    public static final String 发票种类_其他 = "3";
    public static final Map<String, String> INVOICE_TYPE = new HashMap();
    static {
        INVOICE_TYPE.put(发票类型_增值税专用发票, "增值税专用发票");
        INVOICE_TYPE.put(发票种类_增值税普通发票, "增值税普通发票");
        INVOICE_TYPE.put(发票种类_其他, "其他");
    }

    /**
     * 信息来源 1-询价反馈、2-履约反馈、3-其他反馈
     */
    public static final String FEEDBACK_TYPE_INQUIRY = "1";
    public static final String FEEDBACK_TYPE_AGREE = "2";
    public static final String FEEDBACK_TYPE_OTH = "3";
    public static final Map<String, String> FEEDBACK_TYPE = new HashMap();

    static {
        FEEDBACK_TYPE.put(FEEDBACK_TYPE_INQUIRY, "询价反馈");
        FEEDBACK_TYPE.put(FEEDBACK_TYPE_AGREE, "履约反馈");
        FEEDBACK_TYPE.put(FEEDBACK_TYPE_OTH, "其他反馈");
    }

}
