package com.ejianc.business.zdsmaterial.material.vo;

import com.ejianc.framework.skeleton.template.BaseVO;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 采购发票登记
 *
 * @author generator
 *
 */
public class MatInvoiceVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private Long contractId; // 合同主键
    private String contractCode; // 合同编码
    private String contractName; // 合同名称
    private String sourceContractId; // 合同来源主键
    private Long supplierId; // 供应商id
    private String supplierCode; // 供应商编码
    private String supplierName; // 供应商名称
    private String execCode; // 执行编码
    private Long projectId; // 项目id
    private String projectCode; // 项目编码
    private String projectName; // 项目名称
    private Long orgId; // 单据组织id
    private String orgCode; // 单据组织编码
    private String orgName; // 单据组织名称
    private Long parentOrgId; // 上级组织id
    private String parentOrgCode; // 上级组织编码
    private String parentOrgName; // 上级组织名称
    private String execHeadquarters; // 执行总部
    private String billCode; // 单据编码
    private Date billDate; // 单据日期
    private Integer billState; // 单据状态（审批必须字段）
    private Long createUserId; // 制单人Id
    private String contractType; // 合同类型
    private BigDecimal mainContMny; // 主合同额
    private BigDecimal childContMny; // 附加合同额
    private String invoiceType; // 合同约定发票类型
    private BigDecimal orderMny; // 订单金额
    private BigDecimal contRate; // 合同税率
    private String invoiceHeader; // 发票抬头
    private Integer taxCreateState; // 是否税务局代开
    private String invoiceCty; // 发票种类：1-增值税专用发票2-增值税普通发票3-其他
    private Long taxCtyId; // 税收分类
    private String taxCtyCode; // 税收分类编码
    private String taxCtyName; // 税收分类名称
    private BigDecimal invoiceRate; // 发票税率
    private BigDecimal totalMny; // 发票金额
    private BigDecimal totalTaxMny; // 发票金额(含税)
    private BigDecimal totalTax; // 税额
    private String adminId; // 发票管理员
    private String adminCode; // 发票管理员编码
    private String adminName; // 发票管理员名称
    private String createUserName; // 创建者名称
    private String memo; // 备注
    private Integer signState; // 申请状态0-待审核1-已审核2-已驳回
    private Long sourceId; // 来源主键
    private Date operateTime; // 操作时间
    private Long operateId; // 操作人id
    private String operateName; // 操作人名称
    private String systemId; // 来源系统主键
    private String billPushFlag; // 单据推送标识：unSucPush-未成功推送供方，sucPushed-已成功推送供方
    private Integer preState; // 是否预付款
    private Integer priceType; // 计价方式：1-单价合同，2-总价合同
    private String rejectReason;//驳回原因

    private List<MatInvoiceDetailVO> detailList = new ArrayList<>(); // 采购发票登记-明细
    private List<MatInvoiceFileVO> fileList = new ArrayList<>(); // 采购发票登记-附件

    public String getRejectReason() {
        return rejectReason;
    }

    public void setRejectReason(String rejectReason) {
        this.rejectReason = rejectReason;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public String getSourceContractId() {
        return sourceContractId;
    }

    public void setSourceContractId(String sourceContractId) {
        this.sourceContractId = sourceContractId;
    }
    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierCode() {
        return supplierCode;
    }

    public void setSupplierCode(String supplierCode) {
        this.supplierCode = supplierCode;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public String getExecCode() {
        return execCode;
    }

    public void setExecCode(String execCode) {
        this.execCode = execCode;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getExecHeadquarters() {
        return execHeadquarters;
    }

    public void setExecHeadquarters(String execHeadquarters) {
        this.execHeadquarters = execHeadquarters;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Date getBillDate() {
        return billDate;
    }

    public void setBillDate(Date billDate) {
        this.billDate = billDate;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getCreateUserId() {
        return createUserId;
    }

    public void setCreateUserId(Long createUserId) {
        this.createUserId = createUserId;
    }
    public String getContractType() {
        return contractType;
    }

    public void setContractType(String contractType) {
        this.contractType = contractType;
    }
    public BigDecimal getMainContMny() {
        return mainContMny;
    }

    public void setMainContMny(BigDecimal mainContMny) {
        this.mainContMny = mainContMny;
    }
    public BigDecimal getChildContMny() {
        return childContMny;
    }

    public void setChildContMny(BigDecimal childContMny) {
        this.childContMny = childContMny;
    }
    public String getInvoiceType() {
        return invoiceType;
    }

    public void setInvoiceType(String invoiceType) {
        this.invoiceType = invoiceType;
    }
    public BigDecimal getOrderMny() {
        return orderMny;
    }

    public void setOrderMny(BigDecimal orderMny) {
        this.orderMny = orderMny;
    }
    public BigDecimal getContRate() {
        return contRate;
    }

    public void setContRate(BigDecimal contRate) {
        this.contRate = contRate;
    }
    public String getInvoiceHeader() {
        return invoiceHeader;
    }

    public void setInvoiceHeader(String invoiceHeader) {
        this.invoiceHeader = invoiceHeader;
    }
    public Integer getTaxCreateState() {
        return taxCreateState;
    }

    public void setTaxCreateState(Integer taxCreateState) {
        this.taxCreateState = taxCreateState;
    }
    public String getInvoiceCty() {
        return invoiceCty;
    }

    public void setInvoiceCty(String invoiceCty) {
        this.invoiceCty = invoiceCty;
    }
    public Long getTaxCtyId() {
        return taxCtyId;
    }

    public void setTaxCtyId(Long taxCtyId) {
        this.taxCtyId = taxCtyId;
    }
    public String getTaxCtyCode() {
        return taxCtyCode;
    }

    public void setTaxCtyCode(String taxCtyCode) {
        this.taxCtyCode = taxCtyCode;
    }
    public String getTaxCtyName() {
        return taxCtyName;
    }

    public void setTaxCtyName(String taxCtyName) {
        this.taxCtyName = taxCtyName;
    }
    public BigDecimal getInvoiceRate() {
        return invoiceRate;
    }

    public void setInvoiceRate(BigDecimal invoiceRate) {
        this.invoiceRate = invoiceRate;
    }
    public BigDecimal getTotalMny() {
        return totalMny;
    }

    public void setTotalMny(BigDecimal totalMny) {
        this.totalMny = totalMny;
    }

    public BigDecimal getTotalTaxMny() {
        return totalTaxMny;
    }

    public void setTotalTaxMny(BigDecimal totalTaxMny) {
        this.totalTaxMny = totalTaxMny;
    }

    public BigDecimal getTotalTax() {
        return totalTax;
    }

    public void setTotalTax(BigDecimal totalTax) {
        this.totalTax = totalTax;
    }
    public String getAdminId() {
        return adminId;
    }

    public void setAdminId(String adminId) {
        this.adminId = adminId;
    }
    public String getAdminCode() {
        return adminCode;
    }

    public void setAdminCode(String adminCode) {
        this.adminCode = adminCode;
    }
    public String getAdminName() {
        return adminName;
    }

    public void setAdminName(String adminName) {
        this.adminName = adminName;
    }
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getSignState() {
        return signState;
    }

    public void setSignState(Integer signState) {
        this.signState = signState;
    }
    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }
    public Date getOperateTime() {
        return operateTime;
    }

    public void setOperateTime(Date operateTime) {
        this.operateTime = operateTime;
    }
    public Long getOperateId() {
        return operateId;
    }

    public void setOperateId(Long operateId) {
        this.operateId = operateId;
    }
    public String getOperateName() {
        return operateName;
    }

    public void setOperateName(String operateName) {
        this.operateName = operateName;
    }
    public String getSystemId() {
        return systemId;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }
    public String getBillPushFlag() {
        return billPushFlag;
    }

    public void setBillPushFlag(String billPushFlag) {
        this.billPushFlag = billPushFlag;
    }
    public Integer getPreState() {
        return preState;
    }

    public void setPreState(Integer preState) {
        this.preState = preState;
    }
    public Integer getPriceType() {
        return priceType;
    }

    public void setPriceType(Integer priceType) {
        this.priceType = priceType;
    }

    public List<MatInvoiceDetailVO> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<MatInvoiceDetailVO> detailList) {
        this.detailList = detailList;
    }

    public List<MatInvoiceFileVO> getFileList() {
        return fileList;
    }

    public void setFileList(List<MatInvoiceFileVO> fileList) {
        this.fileList = fileList;
    }
}
