package com.ejianc.business.zdsmaterial.out.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 处置申请
 * 
 * @author generator
 * 
 */
public class DisposeVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private String billCode; // 单据编号
    private Long projectId; // 项目主键
    private String projectName; // 项目名称
    private String projectCode; // 项目编码
    private Long orgId; // 所属单位主键
    private String orgName; // 所属单位名称
    private String orgCode; // 所属单位编码
    private String materialTypeNames; // 物料分类名称
    private Long employeeId; // 经办人id
    private String employeeName; // 经办人名称
    private Integer billState; // 单据状态（审批必须字段）
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    private Date billDate; // 处置时间
    private String memo; // 备注
    private Long parentOrgId; // 上级组织id
    private String parentOrgName; // 上级组织name
    private String parentOrgCode; // 上级组织编码
    private Integer disposeType; // 处置方式，1-战略,2-询比价
    private BigDecimal applyMny; // 申请金额
    private BigDecimal applyTaxMny; // 申请金额含税
    private BigDecimal disposeMny; // 预估处置金额
    private BigDecimal disposeTaxMny; // 预估处置金额含税
    private BigDecimal actualDisposeMny; // 实际处置金额
    private BigDecimal actualDisposeTaxMny; // 实际处置金额含税
    private Long createUserId;// 制单人Id

    private String recMnyFlag; //收款标识：0-未收款，1-已收款
    private BigDecimal recMny; //收款金额
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    private Date recDate; //收款状态更新日期

    private String recMnyFlagStr; //收款状态名称

    private String billStateName; //
    private String period; //期间
    private String disposeTypeName;

    public String getRecMnyFlagStr() {
        return recMnyFlagStr;
    }

    public void setRecMnyFlagStr(String recMnyFlagStr) {
        this.recMnyFlagStr = recMnyFlagStr;
    }

    public String getPeriod() {
        return period;
    }

    public void setPeriod(String period) {
        this.period = period;
    }

    private List<DisposeDetailVO> disposeDetailList = new ArrayList<>(); // 处置申请明细表

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    @ReferSerialTransfer(referCode = "project-set")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getMaterialTypeNames() {
        return materialTypeNames;
    }

    public void setMaterialTypeNames(String materialTypeNames) {
        this.materialTypeNames = materialTypeNames;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Date getBillDate() {
        return billDate;
    }

    public void setBillDate(Date billDate) {
        this.billDate = billDate;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public Integer getDisposeType() {
        return disposeType;
    }

    public void setDisposeType(Integer disposeType) {
        this.disposeType = disposeType;
    }
    public BigDecimal getApplyMny() {
        return applyMny;
    }

    public void setApplyMny(BigDecimal applyMny) {
        this.applyMny = applyMny;
    }
    public BigDecimal getApplyTaxMny() {
        return applyTaxMny;
    }

    public void setApplyTaxMny(BigDecimal applyTaxMny) {
        this.applyTaxMny = applyTaxMny;
    }
    public BigDecimal getDisposeMny() {
        return disposeMny;
    }

    public void setDisposeMny(BigDecimal disposeMny) {
        this.disposeMny = disposeMny;
    }
    public BigDecimal getDisposeTaxMny() {
        return disposeTaxMny;
    }

    public void setDisposeTaxMny(BigDecimal disposeTaxMny) {
        this.disposeTaxMny = disposeTaxMny;
    }
    public BigDecimal getActualDisposeMny() {
        return actualDisposeMny;
    }

    public void setActualDisposeMny(BigDecimal actualDisposeMny) {
        this.actualDisposeMny = actualDisposeMny;
    }
    public BigDecimal getActualDisposeTaxMny() {
        return actualDisposeTaxMny;
    }

    public void setActualDisposeTaxMny(BigDecimal actualDisposeTaxMny) {
        this.actualDisposeTaxMny = actualDisposeTaxMny;
    }
    
     public List<DisposeDetailVO> getDisposeDetailList() {
        return disposeDetailList;
     }

     public void setDisposeDetailList(List<DisposeDetailVO> disposeDetailList) {
        this.disposeDetailList = disposeDetailList;
     }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public String getDisposeTypeName() {
        return disposeTypeName;
    }

    public void setDisposeTypeName(String disposeTypeName) {
        this.disposeTypeName = disposeTypeName;
    }

    public Long getCreateUserId() {
        return createUserId;
    }

    public void setCreateUserId(Long createUserId) {
        this.createUserId = createUserId;
    }

    public String getRecMnyFlag() {
        return recMnyFlag;
    }

    public void setRecMnyFlag(String recMnyFlag) {
        this.recMnyFlag = recMnyFlag;
    }

    public BigDecimal getRecMny() {
        return recMny;
    }

    public void setRecMny(BigDecimal recMny) {
        this.recMny = recMny;
    }

    public Date getRecDate() {
        return recDate;
    }

    public void setRecDate(Date recDate) {
        this.recDate = recDate;
    }
}
