package com.ejianc.business.zdsmaterial.erp.api;

import com.ejianc.business.zdsmaterial.erp.hystrix.BrandHystrix;
import com.ejianc.business.zdsmaterial.erp.vo.BrandVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;
import java.util.Map;

/**
 * @author CJ
 * @Description:
 * @date 2024/1/26 13:45
 */
@FeignClient(name = "ejc-zdsmaterial-web", url = "${common.env.feign-client-url}", path = "ejc-zdsmaterial-web", fallback = BrandHystrix.class)
public interface IZDSBrandApi {

    @PostMapping(value = "/api/zdsBrand/getAllByIds")
    CommonResponse<List<BrandVO>> getAllByIds(@RequestBody List<Long> ids);

    @PostMapping(value = "/api/zdsBrand/getAllMapBySourceIds")
    CommonResponse<Map<String, BrandVO>> getAllMapBySourceIds(@RequestBody List<String> sourceIds);

    @PostMapping(value = "/api/zdsBrand/getAllMapByNames")
    CommonResponse<Map<String, BrandVO>> getAllMapByNames(@RequestBody List<String> names);

}
