package com.ejianc.business.zdsmaterial.material.api;

import com.ejianc.business.zdsmaterial.material.hystrix.ZDSMaterialHystrix;
import com.ejianc.business.zdsmaterial.material.vo.MaterialCategoryVO;
import com.ejianc.business.zdsmaterial.material.vo.MaterialVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Map;

/**
 * @author 姜轶凯
 * @version 1.0
 * @description: 对账结算api
 * @date 2022/3/9
 */
@FeignClient(name = "ejc-zdsmaterial-web", url = "${common.env.feign-client-url}", path = "ejc-zdsmaterial-web", fallback = ZDSMaterialHystrix.class)
public interface IZDSMaterialApi {

    /**
     * 根据物资名称、规格型号、计量单位、物料分类进行唯一性查询
     *
     * @param materialVO(name,spac,unitName,categoryId,property)
     * @return
     */
    @PostMapping(value = "/api/zdsMaterialApi/queryExitFlag")
    CommonResponse<MaterialVO> queryExitFlag(@RequestBody MaterialVO materialVO);
    /**
     * 根据物资名称、规格型号、计量单位、物料分类名称进行唯一性查询
     *
     * @param materialVO(name,spec,unitName,categoryName,property)
     * @return
     */
    @PostMapping(value = "/api/zdsMaterialApi/queryExcelFlag")
    CommonResponse<List<MaterialVO>> queryExcelFlag(@RequestBody MaterialVO materialVO);

    /**
     * 根据编码查询物料分类详情
     *
     * @param code
     * @return
     */
    @GetMapping(value = "/api/zdsMaterialApi/queryCategoryByCode")
    CommonResponse<MaterialCategoryVO> queryCategoryByCode(@RequestParam(value = "code") String code);

    /**
     * 根据ids查询上级全部分类
     *
     * @param ids
     * @return
     */
    @GetMapping(value = "/api/zdsMaterialApi/queryCategoryListByChildren")
    CommonResponse<List<MaterialCategoryVO>> queryCategoryListByChildren(@RequestParam(value = "ids") List<Long> ids);

    /**
     * 根据父id询全部物料分类
     *
     * @param id
     * @return
     */
    @GetMapping(value = "/api/zdsMaterialApi/queryCategoryListByPid")
    CommonResponse<List<MaterialCategoryVO>> queryCategoryListByPid(@RequestParam(value = "id") Long id);

    /**
     * 根据父id询全部物料下级分类
     * @Author
     * @param id
     * @return
     */
    @GetMapping(value = "/api/zdsMaterialApi/queryCategoryAllListByPid")
    CommonResponse<List<MaterialCategoryVO>> queryCategoryAllListByPid(@RequestParam(value = "id") Long id);


    /**
     * 根据ids查询物资列表（包括物资来源id，物资分类来源id）
     *
     * @param ids
     * @param queryRelations
     * @return
     */
    @GetMapping(value = "/api/zdsMaterialApi/queryMaterialByIds")
    CommonResponse<List<MaterialVO>> queryMaterialByIds(@RequestParam(value = "ids") List<Long> ids,
                                                        @RequestParam(value = "queryRelations", required = false, defaultValue = "false") Boolean queryRelations);

    /**
     * @Author xuannl
     * @Date 2022/04/18 根据id查询物资
     * @Param [id]
     * @Return com.ejianc.framework.core.response.CommonResponse<com.ejianc.foundation.share.vo.MaterialVO>
     */
    @GetMapping(value = "/api/zdsMaterialApi/queryMaterialItemByIds")
    CommonResponse<List<MaterialVO>> queryMaterialItemByIds(@RequestParam(value = "ids") List<Long> ids,
                                                            @RequestParam(value = "queryRelations", required = false, defaultValue = "false") Boolean queryRelations);
    /**
     * 根据主键查询物料分类详情
     * @Author zhangwx
     * @param id
     * @return
     */
    @GetMapping(value = "/api/zdsMaterialApi/queryCategoryById")
    CommonResponse<MaterialCategoryVO> queryCategoryById(@RequestParam(value = "id") Long id);

    /**
     * 根据物资分类主键查询所有物料详情列表
     * @Author zhangwx
     * @param ids
     * @return
     */
    @PostMapping(value = "/api/zdsMaterialApi/queryMaterialByCategoryId")
    CommonResponse<List<MaterialVO>> queryMaterialByCategoryId(@RequestBody List<Long> ids);

    /**
     * 根据编码查询物料详情
     * @Author liyongjia
     * @param code
     * @return
     */
    @GetMapping(value = "/api/zdsMaterialApi/queryMaterialByCode")
    CommonResponse<MaterialVO> queryMaterialByCode(@RequestParam(value = "code") String code);

    /**
     * 根据材料主键查对应的所有上级分类
     *
     * @param ids
     * @return
     */
    @GetMapping(value = "/api/zdsMaterialApi/queryCategoryListByMaterialId")
    CommonResponse<Map<Long, List<MaterialCategoryVO>>> queryCategoryListByMaterialId(@RequestParam(value = "ids") List<Long> ids);

    /**
     * 根据ids查询分类
     *
     * @param ids
     * @return
     */
    @GetMapping(value = "/api/zdsMaterialApi/queryCategoryListByIds")
    CommonResponse<List<MaterialCategoryVO>> queryCategoryListByIds(@RequestParam(value = "ids", required = false) List<Long> ids);

    /**
     * 根据编码集合查询档案列表
     *
     * @param codeList
     * @return
     */
    @GetMapping(value = "/api/zdsMaterialApi/queryMaterialListByCodes")
    CommonResponse<List<MaterialVO>> queryMaterialListByCodes(@RequestParam(value = "codeList") List<String> codeList);

    @PostMapping(value = "/api/zdsMaterialApi/addNewMaterialsFromBill")
    CommonResponse<List<MaterialVO>> addNewMaterialsFromBill(@RequestBody List<MaterialVO> saveList);

    @PostMapping(value = "/api/zdsMaterialApi/deleteMaterialsFromBill")
    CommonResponse<List<MaterialVO>> deleteMaterialsFromBill(@RequestBody List<Long> sourceIds);
}
