package com.ejianc.business.zdsmaterial.material.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.ArrayList;
import java.util.List;


/**
 * 材料明细
 * 
 * @author generator
 * 
 */
@ApiModel("材料明细")
public class MaterialVO extends BaseVO {

    private static final long serialVersionUID = -5526041674154511630L;

    @ApiModelProperty("编码")
    private String code;
    @ApiModelProperty("名称")
    private String name;
    @ApiModelProperty("计量单位Id")
    private Long unitId;
    @ApiModelProperty("计量单位名称")
    private String unitName;
    @ApiModelProperty("所属分类名称")
    private String categoryName;
    @ApiModelProperty("所属分类Id")
    private Long categoryId;
    @ApiModelProperty("所属分类编码")
    private String categoryCode;
    @ApiModelProperty("属性展示名称")
    private String propertyShowName;
    @ApiModelProperty("停启用标识：0-停用，1-启用")
    private Integer enabled;
    @ApiModelProperty("封存状态：0-正常，1-封存")
    private Integer blockedFlag;

    @ApiModelProperty("来源系统Id")
    private String systemId;
    @ApiModelProperty("来源系统业务Id")
    private String sourceId;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("自定义产品代码标识：0-通用产品代码（默认），1-自定义")
    private Integer productCodeCustomFlag;

    @ApiModelProperty("产品代码")
    private String productCode;

    @ApiModelProperty("是否生效：0-未生效（业务单据推送待准入），1-已生效")
    private Integer validFlag;


    @ApiModelProperty("物资属性关系列表")
    List<MaterialPropertyRelationVO> relationList = new ArrayList<>();

    @ApiModelProperty("物资来源单据列表")
    List<MaterialSourceVO> sourceList = new ArrayList<>();

    //标记属性值是否为新增属性值
    private Integer hasNewPropertyVal;
    private String hasNewPropertyValStr;

    //是否匹配
    private boolean matchFlag;

    private String importMsg;

    //导出字段
    private String enabledStr;
    private String blockedFlagStr;


    //修订前旧单位
    private Long oldUnitId;
    //修订前旧属性
    private String oldPropertyShowName;
    private Integer sourceNum;

    public String getHasNewPropertyValStr() {
        return hasNewPropertyValStr;
    }

    public void setHasNewPropertyValStr(String hasNewPropertyValStr) {
        this.hasNewPropertyValStr = hasNewPropertyValStr;
    }

    public Integer getSourceNum() {
        return sourceNum;
    }

    public void setSourceNum(Integer sourceNum) {
        this.sourceNum = sourceNum;
    }

    public Long getOldUnitId() {
        return oldUnitId;
    }

    public void setOldUnitId(Long oldUnitId) {
        this.oldUnitId = oldUnitId;
    }

    public String getOldPropertyShowName() {
        return oldPropertyShowName;
    }

    public void setOldPropertyShowName(String oldPropertyShowName) {
        this.oldPropertyShowName = oldPropertyShowName;
    }

    public List<MaterialSourceVO> getSourceList() {
        return sourceList;
    }

    public void setSourceList(List<MaterialSourceVO> sourceList) {
        this.sourceList = sourceList;
    }

    public Integer getValidFlag() {
        return validFlag;
    }

    public void setValidFlag(Integer validFlag) {
        this.validFlag = validFlag;
    }

    public String getProductCode() {
        return productCode;
    }

    public void setProductCode(String productCode) {
        this.productCode = productCode;
    }

    public Integer getProductCodeCustomFlag() {
        return productCodeCustomFlag;
    }

    public void setProductCodeCustomFlag(Integer productCodeCustomFlag) {
        this.productCodeCustomFlag = productCodeCustomFlag;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getImportMsg() {
        return importMsg;
    }

    public void setImportMsg(String importMsg) {
        this.importMsg = importMsg;
    }

    public Integer getHasNewPropertyVal() {
        return hasNewPropertyVal;
    }

    public void setHasNewPropertyVal(Integer hasNewPropertyVal) {
        this.hasNewPropertyVal = hasNewPropertyVal;
    }

    public String getSourceId() {
        return sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public String getSystemId() {
        return systemId;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public String getEnabledStr() {
        return enabledStr;
    }

    public void setEnabledStr(String enabledStr) {
        this.enabledStr = enabledStr;
    }

    public String getBlockedFlagStr() {
        return blockedFlagStr;
    }

    public void setBlockedFlagStr(String blockedFlagStr) {
        this.blockedFlagStr = blockedFlagStr;
    }

    public boolean isMatchFlag() {
        return matchFlag;
    }

    public void setMatchFlag(boolean matchFlag) {
        this.matchFlag = matchFlag;
    }

    public Integer getBlockedFlag() {
        return blockedFlag;
    }

    public void setBlockedFlag(Integer blockedFlag) {
        this.blockedFlag = blockedFlag;
    }

    public List<MaterialPropertyRelationVO> getRelationList() {
        return relationList;
    }

    public void setRelationList(List<MaterialPropertyRelationVO> relationList) {
        this.relationList = relationList;
    }

    public String getCategoryName() {
        return categoryName;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public Long getUnitId() {
        return unitId;
    }

    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }
    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }

    @ReferSerialTransfer(referCode = "ref-zdsmteral-category")
    public Long getCategoryId() {
        return categoryId;
    }

    @ReferDeserialTransfer
    public void setCategoryId(Long categoryId) {
        this.categoryId = categoryId;
    }
    public String getCategoryCode() {
        return categoryCode;
    }

    public void setCategoryCode(String categoryCode) {
        this.categoryCode = categoryCode;
    }
    public String getPropertyShowName() {
        return propertyShowName;
    }

    public void setPropertyShowName(String propertyShowName) {
        this.propertyShowName = propertyShowName;
    }
    public Integer getEnabled() {
        return enabled;
    }

    public void setEnabled(Integer enabled) {
        this.enabled = enabled;
    }
    
}
