package com.ejianc.business.zdsmaterial.material.vo;

import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;

/**
 * 物资来源明细
 *
 * @author CJ
 * @Description:
 * @date 2024/1/12 11:04
 */
public class MaterialSourceVO extends BaseVO {

    private static final long serialVersionUID = 3922333930080210072L;

    @ApiModelProperty("物资Id")
    private Long materialId;

    @ApiModelProperty("来源单据类型")
    private String billType;

    @ApiModelProperty("来源单据类型名称")
    private String billTypeName;

    @ApiModelProperty("来源单据编码")
    private String sourceBillCode;

    @ApiModelProperty("来源单据主表Id")
    private Long sourcePid;

    @ApiModelProperty("来源单据子表Id")
    private Long sourceDetailId;

    @ApiModelProperty("来源单据PC端详情地址")
    private String sourceBillPcUrl;

    @ApiModelProperty("来源单据移动端详情地址")
    private String sourceBillMobileUrl;

    @ApiModelProperty("创建人编码")
    private String sourceCreateUserCode;

    @ApiModelProperty("创建人名称")
    private String sourceCreateUserName;

    @ApiModelProperty("来源单据所属组织名称")
    private String sourceOrgName;

    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date sourceCreateTime;

    public String getSourceCreateUserName() {
        return sourceCreateUserName;
    }

    public void setSourceCreateUserName(String sourceCreateUserName) {
        this.sourceCreateUserName = sourceCreateUserName;
    }

    public String getSourceOrgName() {
        return sourceOrgName;
    }

    public void setSourceOrgName(String sourceOrgName) {
        this.sourceOrgName = sourceOrgName;
    }

    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }

    public String getBillType() {
        return billType;
    }

    public void setBillType(String billType) {
        this.billType = billType;
    }

    public String getBillTypeName() {
        return billTypeName;
    }

    public void setBillTypeName(String billTypeName) {
        this.billTypeName = billTypeName;
    }

    public String getSourceBillCode() {
        return sourceBillCode;
    }

    public void setSourceBillCode(String sourceBillCode) {
        this.sourceBillCode = sourceBillCode;
    }

    public Long getSourcePid() {
        return sourcePid;
    }

    public void setSourcePid(Long sourcePid) {
        this.sourcePid = sourcePid;
    }

    public Long getSourceDetailId() {
        return sourceDetailId;
    }

    public void setSourceDetailId(Long sourceDetailId) {
        this.sourceDetailId = sourceDetailId;
    }

    public String getSourceBillPcUrl() {
        return sourceBillPcUrl;
    }

    public void setSourceBillPcUrl(String sourceBillPcUrl) {
        this.sourceBillPcUrl = sourceBillPcUrl;
    }

    public String getSourceBillMobileUrl() {
        return sourceBillMobileUrl;
    }

    public void setSourceBillMobileUrl(String sourceBillMobileUrl) {
        this.sourceBillMobileUrl = sourceBillMobileUrl;
    }

    public String getSourceCreateUserCode() {
        return sourceCreateUserCode;
    }

    public void setSourceCreateUserCode(String sourceCreateUserCode) {
        this.sourceCreateUserCode = sourceCreateUserCode;
    }

    public Date getSourceCreateTime() {
        return sourceCreateTime;
    }

    public void setSourceCreateTime(Date sourceCreateTime) {
        this.sourceCreateTime = sourceCreateTime;
    }
}
