package com.ejianc.business.zdsmaterial.erp.api;

import com.ejianc.business.zdsmaterial.erp.hystrix.ZDSMessageInFoHystrix;
import com.ejianc.business.zdsmaterial.erp.vo.MessageInfoVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;


@FeignClient(name = "ejc-zdsmaterial-web", url = "${common.env.feign-client-url}", path = "ejc-zdsmaterial-web", fallback = ZDSMessageInFoHystrix.class)
public interface IZDSMessageInfoApi {

    /**
     *
     * ========================必填数据============================
     * @param userId 审批人ids 多个用,分割
     * @param billId 业务单据id
     * @param billTypeCode 业务单据编码
     * @param title 审批主题
     * @param startUserId  提交人/发起人id
     * @param formUrl   pc端链接
     * @param maUrl  移动端链接
     * @param processState  //审批状态名称（待办、已办）
     * @param processStateCode 审批状态编码0,1;待办为0,已办为1
     * @param taskName  审批节点名称
     * @param idea  审批意见
     * @param ideaCode  审批标识1同意，2不同意
     * @return
     */
    @PostMapping(value = "/api/zdsMessageInfo/sendToDoMessage")
    CommonResponse<String> sendToDoMessage(@RequestBody MessageInfoVO messageInfoVO);

}
