package com.ejianc.business.zdsmaterial.material.vo;

import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.ArrayList;
import java.util.List;


/**
 * 材料分类属性
 * 
 * @author generator
 * 
 */
@ApiModel("材料分类属性")
public class MaterialCategoryPropertyVO extends BaseVO {

    private static final long serialVersionUID = 5013021508741157402L;

    @ApiModelProperty("编码")
    private String code;
    @ApiModelProperty("名称")
    private String name;
    @ApiModelProperty("序号")
    private Integer sequence;
    @ApiModelProperty("所属材料分类Id")
    private Long categoryId;
    @ApiModelProperty("来源系统Id")
    private String systemId;
    @ApiModelProperty("来源业务Id")
    private String sourceId;

    @ApiModelProperty("属性分类停启用")
    private Integer enabled;

    @ApiModelProperty("产品代码停启用：0-停用，1-启用，默认停用")
    private Integer productCodeFlag;

    @ApiModelProperty("是否必选：0-否，1是")
    private Integer requiredFlag;

    @ApiModelProperty("是否关键属性：0-否，1-是。物料档案准入时，关键属性不允许调整")
    private Integer keyPropertyFlag;

    @ApiModelProperty("属性可选列表")
    private List<MaterialCategoryPropertySubItemVO> itemList = new ArrayList<>();

    private String oldName;
    private Integer oldSequence;
    private Integer oldEnabled;
    private Integer oldProductCodeFlag;

    public Integer getRequiredFlag() {
        return requiredFlag;
    }

    public void setRequiredFlag(Integer requiredFlag) {
        this.requiredFlag = requiredFlag;
    }

    public Integer getKeyPropertyFlag() {
        return keyPropertyFlag;
    }

    public void setKeyPropertyFlag(Integer keyPropertyFlag) {
        this.keyPropertyFlag = keyPropertyFlag;
    }

    public Integer getProductCodeFlag() {
        return productCodeFlag;
    }

    public void setProductCodeFlag(Integer productCodeFlag) {
        this.productCodeFlag = productCodeFlag;
    }

    public Integer getOldProductCodeFlag() {
        return oldProductCodeFlag;
    }

    public void setOldProductCodeFlag(Integer oldProductCodeFlag) {
        this.oldProductCodeFlag = oldProductCodeFlag;
    }

    public Integer getOldEnabled() {
        return oldEnabled;
    }

    public void setOldEnabled(Integer oldEnabled) {
        this.oldEnabled = oldEnabled;
    }

    public String getOldName() {
        return oldName;
    }

    public void setOldName(String oldName) {
        this.oldName = oldName;
    }

    public Integer getOldSequence() {
        return oldSequence;
    }

    public void setOldSequence(Integer oldSequence) {
        this.oldSequence = oldSequence;
    }

    public Integer getEnabled() {
        return enabled;
    }

    public void setEnabled(Integer enabled) {
        this.enabled = enabled;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public Integer getSequence() {
        return sequence;
    }

    public void setSequence(Integer sequence) {
        this.sequence = sequence;
    }
    public Long getCategoryId() {
        return categoryId;
    }

    public void setCategoryId(Long categoryId) {
        this.categoryId = categoryId;
    }
    public String getSystemId() {
        return systemId;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }
    public String getSourceId() {
        return sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public List<MaterialCategoryPropertySubItemVO> getItemList() {
        return itemList;
    }

    public void setItemList(List<MaterialCategoryPropertySubItemVO> itemList) {
        this.itemList = itemList;
    }
}
