package com.ejianc.business.zdsmaterial.pricelib.vo;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 物资价格库预警参数
 */
public enum MaterialCostPriceCheckTypeEnum {

    消耗材合同(1, "材料合同"),
    消耗材验收(2, "材料验收"),
    消耗材结算(3, "材料结算"),
    混凝土合同(4, "混凝土合同"),
    混凝土验收(5, "混凝土验收"),
    混凝土结算(6, "混凝土结算"),
    ;
    private Integer code;
    private String description;
    private static Map<Integer, MaterialCostPriceCheckTypeEnum> enumMap = new HashMap<>();

    MaterialCostPriceCheckTypeEnum(Integer code, String description){
        this.code = code;
        this.description = description;
    }
    public Integer getCode() {
        return code;
    }

    public String getDescription() {
        return description;
    }

    static {
        enumMap = EnumSet.allOf(MaterialCostPriceCheckTypeEnum.class).stream().collect(Collectors.toMap(MaterialCostPriceCheckTypeEnum::getCode, Function.identity(), (k1, k2) -> k2));
    }

    public static MaterialCostPriceCheckTypeEnum getEnumByCode(Integer billStateCode) {
        return enumMap.get(billStateCode);
    }
}

