package com.ejianc.business.zdsmaterial.erp.enums;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

/**
 * @author CJ
 * @Description:
 * @date 2023/12/5 18:03
 */
public enum DeliveryAcceptStatusEnums {

    待验收("待验收", 1),
    验收中("验收中", 2),
    分批验收("分批验收", 3),
    验收完成("验收完成", 4),
    部分退回("部分退回", 5);

    private String name;
    private Integer code;

    private static Map<Integer,String> codeNameMap = new HashMap<>();

    DeliveryAcceptStatusEnums(String name, Integer code) {
        this.name = name;
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    static {
        Arrays.stream(values()).forEach(v -> {
            codeNameMap.put(v.getCode(), v.getName());
        });
    }

    public String getNameByCode(Integer code) {
        return codeNameMap.get(code);
    }
}
