package com.ejianc.business.zdsmaterial.sub.settle.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * 分包结算管理
 * 
 * @author generator
 * 
 */
@ApiModel("分包结算管理")
public class SubSettleVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("单据状态")
    private Integer billState;
    @ApiModelProperty("指令单编号")
    private String billCode;
    @ApiModelProperty("项目id")
    private Long projectId;
    @ApiModelProperty("项目名称")
    private String projectName;
    @ApiModelProperty("项目编码")
    private String projectCode;
    @ApiModelProperty("项目经理")
    private Long projectManagementId;
    @ApiModelProperty("项目经理名称")
    private String projectManagementName;
    @ApiModelProperty("单据组织id")
    private Long orgId;
    @ApiModelProperty("单据组织名称")
    private String orgName;
    @ApiModelProperty("单据组织编码")
    private String orgCode;
    @ApiModelProperty("上级组织id")
    private Long parentOrgId;
    @ApiModelProperty("上级组织名称")
    private String parentOrgName;
    @ApiModelProperty("上级组织编码")
    private String parentOrgCode;
    @ApiModelProperty("合同id")
    private Long subContractId;
    @ApiModelProperty("合同名称")
    private String subContractName;
    @ApiModelProperty("合同编码")
    private String subContractCode;
    @ApiModelProperty("分包联系人主键")
    private Long subLinkId;
    @ApiModelProperty("分包联系人名称")
    private String subLinkName;
    @ApiModelProperty("分包联系人code")
    private String subLinkCode;
    @ApiModelProperty("指令单说明")
    private String memo;
    @ApiModelProperty("供应商id")
    private Long supplierId;
    @ApiModelProperty("供应商名称")
    private String supplierName;
    @ApiModelProperty("供应商编码")
    private String supplierCode;
    @ApiModelProperty("定价方式")
    private String priceType;
    @ApiModelProperty("专业类别")
    private String specialtyType;
    @ApiModelProperty("主合同金额")
    private BigDecimal mainContractMny;
    @ApiModelProperty("附加合同金额")
    private BigDecimal appendContractMny;
    @ApiModelProperty("填报状态,1-待分包上传资料,2-已上传资料,3-审核通过")
    private Integer fillStatus;
    @ApiModelProperty("合同内容")
    private String content;
    private String sourceId; // 来源id
    private String subManagerName; // 乙方项目经理
    private Long subManagerId; // 乙方项目经理id
    private String fillStatusName; //
    private String billStateName; //
    private Long supSubManagerId; //供方乙方项目经理id
    private Long supSubLinkId; //供方分包联系人主键
    private String createUserName; // 创建人name
    private BigDecimal settleMny; // 拟报结算金额


    /**
     * 来源业务系统id
     */
    private String sourceSystemId;
    @ApiModelProperty("分包结算管理-流转记录表")
    private List<SubSettleRecordVO> subSettleRecordList = new ArrayList<>();
    @ApiModelProperty("分包结算管理-附件模版")
    private List<SubSettleTemplateVO> subSettleTemplateList = new ArrayList<>();
    private List<SubSettleFileVO> subSettleFileList = new ArrayList<>(); // 分包结算管理-供方附件



    private Long matWorkerId; // 采购工程师
    private String matWorkerName; // 采购工程师名称
    private String matWorkerPhone; // 采购工程师电话
    private String matWorkerCode; //采购工程师工号
    private String rejectCause;//驳回原因

    public String getMatWorkerCode() {
        return matWorkerCode;
    }

    public void setMatWorkerCode(String matWorkerCode) {
        this.matWorkerCode = matWorkerCode;
    }

    public String getRejectCause() {
        return rejectCause;
    }

    public void setRejectCause(String rejectCause) {
        this.rejectCause = rejectCause;
    }
    public String getMatWorkerPhone() {
        return matWorkerPhone;
    }

    public void setMatWorkerPhone(String matWorkerPhone) {
        this.matWorkerPhone = matWorkerPhone;
    }

    public String getMatWorkerName() {
        return matWorkerName;
    }

    public void setMatWorkerName(String matWorkerName) {
        this.matWorkerName = matWorkerName;
    }

    @ReferSerialTransfer(referCode="idm-employee")
    public Long getMatWorkerId() {
        return matWorkerId;
    }
    @ReferDeserialTransfer
    public void setMatWorkerId(Long matWorkerId) {
        this.matWorkerId = matWorkerId;
    }
    public BigDecimal getSettleMny() {
        return settleMny;
    }

    public void setSettleMny(BigDecimal settleMny) {
        this.settleMny = settleMny;
    }

    @Override
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }

    public Long getSupSubManagerId() {
        return supSubManagerId;
    }

    public void setSupSubManagerId(Long supSubManagerId) {
        this.supSubManagerId = supSubManagerId;
    }

    public Long getSupSubLinkId() {
        return supSubLinkId;
    }

    public void setSupSubLinkId(Long supSubLinkId) {
        this.supSubLinkId = supSubLinkId;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public String getFillStatusName() {
        return fillStatusName;
    }

    public void setFillStatusName(String fillStatusName) {
        this.fillStatusName = fillStatusName;
    }

    public String getSubManagerName() {
        return subManagerName;
    }

    public void setSubManagerName(String subManagerName) {
        this.subManagerName = subManagerName;
    }

    public Long getSubManagerId() {
        return subManagerId;
    }

    public void setSubManagerId(Long subManagerId) {
        this.subManagerId = subManagerId;
    }

    public List<SubSettleFileVO> getSubSettleFileList() {
        return subSettleFileList;
    }

    public String getSourceSystemId() {
        return sourceSystemId;
    }

    public void setSourceSystemId(String sourceSystemId) {
        this.sourceSystemId = sourceSystemId;
    }

    public void setSubSettleFileList(List<SubSettleFileVO> subSettleFileList) {
        this.subSettleFileList = subSettleFileList;
    }

    public String getSourceId() {
        return sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    /**
     * 单据状态
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 指令单编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 指令单编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 项目id
     */
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目id
     */
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 项目编码
     */
    public String getProjectCode() {
        return projectCode;
    }

    /**
     * 项目编码
     */
    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    /**
     * 项目经理
     */
    public Long getProjectManagementId() {
        return projectManagementId;
    }

    /**
     * 项目经理
     */
    public void setProjectManagementId(Long projectManagementId) {
        this.projectManagementId = projectManagementId;
    }
    /**
     * 项目经理名称
     */
    public String getProjectManagementName() {
        return projectManagementName;
    }

    /**
     * 项目经理名称
     */
    public void setProjectManagementName(String projectManagementName) {
        this.projectManagementName = projectManagementName;
    }
    /**
     * 单据组织id
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 单据组织id
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 单据组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 单据组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 单据组织编码
     */
    public String getOrgCode() {
        return orgCode;
    }

    /**
     * 单据组织编码
     */
    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    /**
     * 上级组织id
     */
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 上级组织id
     */
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    /**
     * 上级组织名称
     */
    public String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 上级组织名称
     */
    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    /**
     * 上级组织编码
     */
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    /**
     * 上级组织编码
     */
    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    /**
     * 合同id
     */
    public Long getSubContractId() {
        return subContractId;
    }

    /**
     * 合同id
     */
    public void setSubContractId(Long subContractId) {
        this.subContractId = subContractId;
    }
    /**
     * 合同名称
     */
    public String getSubContractName() {
        return subContractName;
    }

    /**
     * 合同名称
     */
    public void setSubContractName(String subContractName) {
        this.subContractName = subContractName;
    }
    /**
     * 合同编码
     */
    public String getSubContractCode() {
        return subContractCode;
    }

    /**
     * 合同编码
     */
    public void setSubContractCode(String subContractCode) {
        this.subContractCode = subContractCode;
    }
    /**
     * 分包联系人主键
     */
    public Long getSubLinkId() {
        return subLinkId;
    }

    /**
     * 分包联系人主键
     */
    public void setSubLinkId(Long subLinkId) {
        this.subLinkId = subLinkId;
    }
    /**
     * 分包联系人名称
     */
    public String getSubLinkName() {
        return subLinkName;
    }

    /**
     * 分包联系人名称
     */
    public void setSubLinkName(String subLinkName) {
        this.subLinkName = subLinkName;
    }
    /**
     * 分包联系人code
     */
    public String getSubLinkCode() {
        return subLinkCode;
    }

    /**
     * 分包联系人code
     */
    public void setSubLinkCode(String subLinkCode) {
        this.subLinkCode = subLinkCode;
    }
    /**
     * 指令单说明
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 指令单说明
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 供应商id
     */
    public Long getSupplierId() {
        return supplierId;
    }

    /**
     * 供应商id
     */
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    /**
     * 供应商名称
     */
    public String getSupplierName() {
        return supplierName;
    }

    /**
     * 供应商名称
     */
    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    /**
     * 供应商编码
     */
    public String getSupplierCode() {
        return supplierCode;
    }

    /**
     * 供应商编码
     */
    public void setSupplierCode(String supplierCode) {
        this.supplierCode = supplierCode;
    }

    public String getSpecialtyType() {
        return specialtyType;
    }

    public void setSpecialtyType(String specialtyType) {
        this.specialtyType = specialtyType;
    }

    public String getPriceType() {
        return priceType;
    }

    public void setPriceType(String priceType) {
        this.priceType = priceType;
    }

    /**
     * 主合同金额
     */
    public BigDecimal getMainContractMny() {
        return mainContractMny;
    }

    /**
     * 主合同金额
     */
    public void setMainContractMny(BigDecimal mainContractMny) {
        this.mainContractMny = mainContractMny;
    }
    /**
     * 附加合同金额
     */
    public BigDecimal getAppendContractMny() {
        return appendContractMny;
    }

    /**
     * 附加合同金额
     */
    public void setAppendContractMny(BigDecimal appendContractMny) {
        this.appendContractMny = appendContractMny;
    }
    /**
     * 填报状态,1-待分包上传资料,2-已上传资料,3-审核通过
     */
    public Integer getFillStatus() {
        return fillStatus;
    }

    /**
     * 填报状态,1-待分包上传资料,2-已上传资料,3-审核通过
     */
    public void setFillStatus(Integer fillStatus) {
        this.fillStatus = fillStatus;
    }
    /**
     * 合同内容
     */
    public String getContent() {
        return content;
    }

    /**
     * 合同内容
     */
    public void setContent(String content) {
        this.content = content;
    }
    
     /**
      * 分包结算管理-流转记录表
      */
      public List<SubSettleRecordVO> getSubSettleRecordList() {
         return subSettleRecordList;
      }
     /**
      * 分包结算管理-流转记录表
      */
     public void setSubSettleRecordList(List<SubSettleRecordVO> subSettleRecordList) {
         this.subSettleRecordList = subSettleRecordList;
     }
     /**
      * 分包结算管理-附件模版
      */
      public List<SubSettleTemplateVO> getSubSettleTemplateList() {
         return subSettleTemplateList;
      }
     /**
      * 分包结算管理-附件模版
      */
     public void setSubSettleTemplateList(List<SubSettleTemplateVO> subSettleTemplateList) {
         this.subSettleTemplateList = subSettleTemplateList;
     }
}
