package com.ejianc.business.zdsmaterial.plan.conjecture.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.zdsmaterial.plan.conjecture.ConjectureEnum;
import com.ejianc.business.zdsmaterial.plan.conjecture.bean.MaterialConjectureEntity;
import com.ejianc.business.zdsmaterial.plan.conjecture.constants.ConjectureConstants;
import com.ejianc.business.zdsmaterial.plan.conjecture.handler.ConjectureManageFactory;
import com.ejianc.business.zdsmaterial.plan.conjecture.mapper.MaterialConjectureMapper;
import com.ejianc.business.zdsmaterial.plan.conjecture.service.IMaterialConjectureService;
import com.ejianc.business.zdsmaterial.plan.conjecture.vo.MaterialConjectureVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

/**
 * 物料识别历史匹配记录实体
 * 
 * @author generator
 * 
 */
@Service("materialConjectureService")
public class MaterialConjectureServiceImpl extends BaseServiceImpl<MaterialConjectureMapper, MaterialConjectureEntity> implements IMaterialConjectureService{

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ConjectureManageFactory factory;

    @Value("${material.ai.handlerName:CJYT}")
    private String handlerName;

    @Value("${material.ai.handleBatchSize:10}")
    private Integer handleBatchSize;


    @Override
    public List<MaterialConjectureVO> materialConjecture(List<MaterialConjectureEntity> saveList, String authority) {
        List<MaterialConjectureVO> resp = new ArrayList<>();
        try {
            if(ConjectureConstants.HANDLE_MODE_BATCH.equals(ConjectureEnum.getHandlerModeByCode(handlerName))) {
                List<Future<List<MaterialConjectureVO>>> futureList = new ArrayList<>();
                List<MaterialConjectureVO> handleList = BeanMapper.mapList(saveList, MaterialConjectureVO.class);

                int totalElements = handleList.size();
                // 使用 IntStream 来分批处理
                IntStream.range(0, (totalElements + handleBatchSize - 1) / handleBatchSize)
                        .mapToObj(i -> handleList.stream()
                                .skip(i * handleBatchSize)
                                .limit(handleBatchSize)
                                .collect(Collectors.toList()))
                        .forEach(batch -> {
                            // 在这里处理每个批次的数据
                            futureList.add(factory.handle(batch, handlerName, authority));
                        });

                for(Future<List<MaterialConjectureVO>> f : futureList) {
                    resp.addAll(f.get());
                }

            } else {
                List<Future<MaterialConjectureVO>> futureList = new ArrayList<>();
                BeanMapper.mapList(saveList, MaterialConjectureVO.class).parallelStream().forEach(c -> {
                    futureList.add(factory.handleSingle(c, handlerName, authority));
                });

                for (Future<MaterialConjectureVO> f : futureList) {
                    try {
                        resp.add(f.get());
                    } catch (Exception e) {
                        logger.error("物料识别materialConjecture Future异常", e);
                    }
                }
            }
        } catch (Exception e) {
            logger.error("根据物料描述：{}  AI识别异常：", JSONObject.toJSONString(saveList));
            logger.error("物料识别异常", e);
        }


        return resp;
    }

    @Override
    @Async(value = "maCommonTask")
    public void startConjecture(String identificationId, String authority, String mode) {
        List<MaterialConjectureEntity> list = getAllByIdentifyId(identificationId, null);
        String conjectureMode = StringUtils.isNotBlank(mode) ? mode : handlerName;
        if(ConjectureConstants.HANDLE_MODE_BATCH.equals(ConjectureEnum.getHandlerModeByCode(conjectureMode))) {
            List<Future<List<MaterialConjectureVO>>> futureList = new ArrayList<>();
            List<MaterialConjectureVO> handleList = BeanMapper.mapList(list, MaterialConjectureVO.class);

            int totalElements = handleList.size();
            List<List<MaterialConjectureVO>> batchList = IntStream.range(0, (totalElements + handleBatchSize - 1) / handleBatchSize)
                    .mapToObj(i -> handleList.stream()
                            .skip(i * handleBatchSize)
                            .limit(handleBatchSize)
                            .collect(Collectors.toList())).collect(Collectors.toList());
            // 使用 IntStream 来分批处理
            batchList.parallelStream().forEach(batch -> {
                        // 在这里处理每个批次的数据
//                        futureList.add();
                        factory.handle(batch, conjectureMode, authority);
                    });
        } else {
            List<Future<MaterialConjectureVO>> futureList = new ArrayList<>();
            BeanMapper.mapList(list, MaterialConjectureVO.class).parallelStream().forEach(c -> {
                futureList.add(factory.handleSingle(c, conjectureMode, authority));
            });
        }

    }

    public List<MaterialConjectureEntity> getAllByIdentifyId(String identificationId, String mateType) {
        return getAllByIdentifyId(identificationId, mateType, null, null, null, null, null, null);
    }

    @Override
    public List<MaterialConjectureEntity> getAllByIdentifyId(String identificationId, String mateType,
                                                             String actualCategoryName, String actualMaterialCode,
                                                             String actualMaterialName, String actualMaterialSpec,
                                                             String actualUnitName, BigDecimal actualNum) {
        return getAllByIdentifyId(identificationId, mateType, actualCategoryName, actualMaterialCode,
                actualMaterialName,actualMaterialSpec,actualUnitName, actualNum, null);
    }

    @Override
    public List<MaterialConjectureEntity> getAllByIdentifyId(String identificationId, String mateType,
                                                             String actualCategoryName, String actualMaterialCode,
                                                             String actualMaterialName, String actualMaterialSpec,
                                                             String actualUnitName, BigDecimal actualNum, String loadState) {
        return getAllByIdentifyId(identificationId, mateType, actualCategoryName, actualMaterialCode,
                actualMaterialName,actualMaterialSpec,actualUnitName, actualNum, loadState, null);
    }

    @Override
    public List<MaterialConjectureEntity> getAllByIdentifyId(String identificationId, String mateType,
                                                             String actualCategoryName, String actualMaterialCode,
                                                             String actualMaterialName, String actualMaterialSpec,
                                                             String actualUnitName, BigDecimal actualNum, String loadState, List<Long> categoryIds) {
        QueryWrapper<MaterialConjectureEntity> query = new QueryWrapper<>();
        query.eq("identification_id", identificationId);
        query.eq("dr", BaseVO.DR_UNDELETE);
        query.eq("del_flag", BaseVO.DR_UNDELETE);
        if(StringUtils.isNotBlank(mateType) && !"-1".equals(mateType)) {
            query.eq("mate_type", mateType);
        }
        if(StringUtils.isNotBlank(actualCategoryName)) {
            query.like("actual_category_name", actualCategoryName);
        }
        if(StringUtils.isNotBlank(actualMaterialCode)) {
            query.like("actual_material_code", actualMaterialCode);
        }
        if(StringUtils.isNotBlank(actualMaterialName)) {
            query.like("actual_category_name", actualMaterialName);
        }
        if(StringUtils.isNotBlank(actualMaterialSpec)) {
            query.like("actual_material_spec", actualMaterialSpec);
        }
        if(StringUtils.isNotBlank(actualUnitName)) {
            query.like("actual_unit_name", actualUnitName);
        }
        if(null != actualNum) {
            query.eq("actual_num", actualNum);
        }
        if(StringUtils.isNotBlank(loadState)) {
            query.eq("load_state", loadState);
        }
        if(CollectionUtils.isNotEmpty(categoryIds)) {
            query.in("actual_category_id", categoryIds);
        }

        return super.list(query);
    }

    @Override
    public void fillBillInfo(Set<String> identifyIds, Long billId, String billCode, String billType) {
        UpdateWrapper<MaterialConjectureEntity> update =new UpdateWrapper<>();
        update.in("identification_id", identifyIds);
        update.isNull("bill_id");
        update.eq("dr", BaseVO.DR_UNDELETE);
        update.set("bill_id", billId);
        update.set("bill_code", billCode);
        update.set("bill_type", billType);
        update.set("update_time", new Date());
        update.set("update_user_code", InvocationInfoProxy.getUsercode());

        super.update(update);
    }

    @Override
    public List<MaterialConjectureVO> getAllByBillId(Long billId) {
        List<MaterialConjectureVO> resp = new ArrayList<>();
        QueryWrapper<MaterialConjectureEntity> query = new QueryWrapper<>();
        query.eq("bill_id", billId);
        query.eq("dr", BaseVO.DR_UNDELETE);
        List<MaterialConjectureEntity> dbList = super.list(query);

        if(CollectionUtils.isNotEmpty(dbList)) {
            return BeanMapper.mapList(dbList, MaterialConjectureVO.class);
        }

        return resp;
    }

    @Override
    public void delConjectureByIds(List<Long> detailIds) {
        UpdateWrapper<MaterialConjectureEntity> update =new UpdateWrapper<>();
        update.in("id", detailIds);
        update.eq("dr", BaseVO.DR_UNDELETE);
        update.set("del_flag", BaseVO.DR_DELETED);
        update.set("update_time", new Date());
        update.set("update_user_code", InvocationInfoProxy.getUsercode());

        super.update(update);
    }
}
