/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.erp.controller.api;

import com.ejianc.business.zdsmaterial.erp.bean.OrderEntity;
import com.ejianc.business.zdsmaterial.erp.service.IOrderService;
import com.ejianc.business.zdsmaterial.erp.vo.OrderVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/zdsOrder"})
public class OrderApi {
    @Autowired
    private IOrderService service;

    @PostMapping(value={"/syncToSupCenterBySupplierId"})
    CommonResponse<List<String>> syncToSupCenterBySupplierId(@RequestBody Long supplierId) {
        ArrayList<String> result = new ArrayList<String>();
        List<Long> orderIds = this.service.getCanSyncOrderIdsBySupplierId(supplierId);
        if (CollectionUtils.isNotEmpty(orderIds)) {
            OrderEntity order = null;
            for (Long orderId : orderIds) {
                order = (OrderEntity)((Object)this.service.selectById(orderId));
                result.add(this.service.pushToSupBusiness((OrderVO)BeanMapper.map((Object)((Object)order), OrderVO.class)));
            }
        }
        return CommonResponse.success(result);
    }
}

