/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.plan.conjecture.handler.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ejianc.business.zdsmaterial.material.bean.MaterialCategoryPropertySubItemEntity;
import com.ejianc.business.zdsmaterial.material.service.ICommonSNService;
import com.ejianc.business.zdsmaterial.material.service.IMaterialCategoryPropertyService;
import com.ejianc.business.zdsmaterial.material.service.IMaterialCategoryPropertySubItemService;
import com.ejianc.business.zdsmaterial.material.service.IMaterialCategoryService;
import com.ejianc.business.zdsmaterial.material.service.IMaterialService;
import com.ejianc.business.zdsmaterial.material.vo.MaterialCategoryPropertySubItemVO;
import com.ejianc.business.zdsmaterial.material.vo.MaterialCategoryPropertyVO;
import com.ejianc.business.zdsmaterial.material.vo.MaterialCategoryVO;
import com.ejianc.business.zdsmaterial.material.vo.MaterialPropertyRelationVO;
import com.ejianc.business.zdsmaterial.material.vo.MaterialVO;
import com.ejianc.business.zdsmaterial.plan.conjecture.bean.MaterialConjectureEntity;
import com.ejianc.business.zdsmaterial.plan.conjecture.handler.IMaterialConjectureHandler;
import com.ejianc.business.zdsmaterial.plan.conjecture.service.IMaterialConjectureService;
import com.ejianc.business.zdsmaterial.plan.conjecture.vo.MaterialConjectureVO;
import com.ejianc.business.zdsmaterial.sub.settle.utils.HttpTookit;
import com.ejianc.foundation.ai.vo.material.AiMaterialParam;
import com.ejianc.foundation.ai.vo.material.AiMaterialVO;
import com.ejianc.foundation.ai.vo.material.ExtProperty;
import com.ejianc.foundation.ai.vo.material.MatchProperty;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.EnvironmentTools;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import com.google.common.base.Stopwatch;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.AsyncResult;
import org.springframework.stereotype.Component;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Component(value="yQLHandler")
public class YQLHandler
implements IMaterialConjectureHandler {
    public static final int connTimeout = 300000;
    public static final int readTimeout = 300000;
    private static final String BILL_TYPE_CODE = "EJCBT202311000003";
    private final String propertySeparator = "\uff1b";
    private final String propertyNameValueSep = "\uff1a";
    private final String CONJECTURE_SINGLE_MATERIAL_URL = "/extract_item_attr";
    private final String SEARCH_MATERIAL_URL = "/similar_item_search";
    private final String reqUrl = "https://portal.17elian.com/ejc-ai-web/ai/material/recognize";
    @Autowired
    private ICommonSNService commonSNService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${material.ai.host:http://58.19.19.195:17011}")
    private String reqHost;
    @Value(value="${material.ai.similarLimit:100}")
    private Integer similarLimit;
    @Value(value="${material.ai.similarThreshold:0}")
    private BigDecimal similarThreshold;
    @Autowired
    private IMaterialCategoryPropertyService propertyService;
    @Autowired
    private IMaterialConjectureService conjectureService;
    @Autowired
    private IMaterialService materialService;
    @Autowired
    private IMaterialCategoryService categoryService;
    @Autowired
    private EnvironmentTools environmentTools;
    private final String SYS_PARAM_CONFIG = "P-Fw47U70005";
    private final String ADD_PROPERTY_ITEM_KEY_PREFIX = "AI_CONJECTURE_ADD_ITEM::";
    private final String PROPERTY_ITEM_MAX_SEQ_KEY_PREFIX = "AI_CONJECTURE_ITEM_MAX_SEQ::";
    @Autowired
    private IMaterialCategoryPropertySubItemService propertySubItemService;
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private JedisPool jedisPool;

    @Override
    public Future<List<MaterialConjectureVO>> conjecture(List<MaterialConjectureVO> sourceList, String authority) {
        this.setContextInfo(authority);
        boolean saveNewPropertyItem = false;
        List conjectureParams = sourceList.stream().map(item -> {
            AiMaterialParam tmp = new AiMaterialParam();
            tmp.setId(item.getId().toString());
            tmp.setItemName(item.getSourceMaterialName());
            tmp.setItemDesc(item.getSourceMaterialSpec());
            return tmp;
        }).collect(Collectors.toList());
        Map sourceMap = sourceList.stream().collect(Collectors.toMap(BaseVO::getId, Function.identity()));
        List conjectureData = null;
        try {
            CommonResponse response = this.paramConfigApi.getByCode("P-Fw47U70005");
            if (!response.isSuccess() || response.getData() == null) {
                this.logger.error("\u67e5\u8be2 AI\u8bc6\u522b\u5c5e\u6027\u81ea\u52a8\u5165\u5e93 \u914d\u7f6e\u5931\u8d25\u6216\u4e3a\u7a7a \uff0c\u8d70\u9ed8\u8ba4\u4e0d\u65b0\u589e\u903b\u8f91******", (Object)JSONObject.toJSONString((Object)response, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
            } else if (StringUtils.equals((CharSequence)"1", (CharSequence)((ParamRegisterSetVO)response.getData()).getValueData())) {
                saveNewPropertyItem = true;
            }
            Stopwatch start = Stopwatch.createStarted();
            String url = "https://portal.17elian.com/ejc-ai-web/ai/material/recognize";
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Type", "application/json;charset=UTF-8");
            headers.put("authority", authority);
            String reqResult = HttpTookit.postByJson(url, JSONObject.toJSONString(conjectureParams), headers, 300000, 300000);
            Stopwatch end = start.stop();
            this.logger.info("************ \u7269\u6599AI\u8bc6\u522b\uff0c\u8017\u65f6\uff1a{} \u79d2", (Object)end.elapsed(TimeUnit.SECONDS));
            this.logger.info("************ \u7269\u6599AI\u8bc6\u522b\uff0c\u7ed3\u679c\uff1a{} ", (Object)JSONObject.toJSONString((Object)reqResult));
            CommonResponse conjectureResult = (CommonResponse)JSONObject.parseObject((String)reqResult, CommonResponse.class);
            if (!conjectureResult.isSuccess()) {
                this.logger.error("************ \u7269\u6599AI\u8bc6\u522b\u5931\u8d25\uff0c\u53c2\u6570\uff1a{}, \u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString(conjectureParams), (Object)JSONObject.toJSONString((Object)conjectureResult));
                sourceList.stream().forEach(item -> item.setMateType("3"));
                this.conjectureService.saveOrUpdateBatch(BeanMapper.mapList(sourceList, MaterialConjectureEntity.class), sourceList.size(), false);
                return new AsyncResult(sourceList);
            }
            conjectureData = JSONArray.parseArray((String)JSONObject.toJSONString((Object)conjectureResult.getData()), AiMaterialVO.class);
            HashMap categoryMap = new HashMap();
            Set categoryIds = conjectureData.stream().filter(item -> null != item.getCategory() && StringUtils.isNotBlank((CharSequence)item.getCategory().getCategoryId())).map(item -> Long.valueOf(item.getCategory().getCategoryId())).collect(Collectors.toSet());
            if (CollectionUtils.isNotEmpty(categoryIds)) {
                List<MaterialCategoryVO> categoryList = this.categoryService.getAllByIds(new ArrayList<Long>(categoryIds));
                categoryMap.putAll(categoryList.stream().collect(Collectors.toMap(BaseVO::getId, Function.identity())));
            }
            MaterialConjectureVO source = null;
            MaterialCategoryVO category = null;
            HashMap<Long, List<MaterialCategoryPropertyVO>> propertyCache = new HashMap<Long, List<MaterialCategoryPropertyVO>>();
            MaterialCategoryPropertyVO tmpProperty = null;
            MaterialCategoryPropertySubItemVO tmpItem = null;
            ArrayList<Long> secCategoryId = new ArrayList<Long>();
            for (AiMaterialVO ma : conjectureData) {
                source = (MaterialConjectureVO)sourceMap.get(Long.valueOf(ma.getId()));
                if (null == ma.getCategory() || StringUtils.isBlank((CharSequence)ma.getCategory().getCategoryId())) {
                    source.setMateType("0");
                    source.setConjectureMateType("0");
                    continue;
                }
                source.setConjectureMaterialSpecs(JSONObject.toJSONString((Object)ma));
                category = (MaterialCategoryVO)categoryMap.get(Long.valueOf(ma.getCategory().getCategoryId()));
                if (null == category) {
                    source.setMateType("0");
                    source.setConjectureMateType("0");
                    continue;
                }
                source.setConjectureCategoryId(category.getId());
                source.setActualSecCategoryId(category.getParentId());
                if (!secCategoryId.contains(category.getParentId())) {
                    secCategoryId.add(category.getParentId());
                }
                source.setConjectureCategoryName(category.getName());
                source.setConjectureMaterialName(category.getName());
                source.setActualCategoryId(category.getId());
                source.setActualCategoryName(category.getName());
                source.setActualMaterialName(category.getName());
                List<MaterialCategoryPropertyVO> propertyList = null;
                if (CollectionUtils.isEmpty((Collection)ma.getMatchProperties())) {
                    source.setMateType("1");
                    source.setConjectureMateType("1");
                    continue;
                }
                if (propertyCache.containsKey(category.getId())) {
                    propertyList = (List<MaterialCategoryPropertyVO>)propertyCache.get(category.getId());
                } else {
                    propertyList = this.propertyService.getAllPropertiesAndValue(source.getConjectureCategoryId(), null, null);
                    propertyCache.put(category.getId(), propertyList);
                }
                Map propertyVOMap = propertyList.parallelStream().collect(Collectors.toMap(BaseVO::getId, Function.identity()));
                Map propertyNameVOMap = propertyList.parallelStream().collect(Collectors.toMap(MaterialCategoryPropertyVO::getName, Function.identity(), (v1, v2) -> v1));
                Map itemMap = propertyList.stream().flatMap(item -> item.getItemList().stream()).collect(Collectors.toMap(BaseVO::getId, Function.identity(), (v1, v2) -> v1));
                for (MatchProperty p : ma.getMatchProperties()) {
                    if (StringUtils.isBlank((CharSequence)p.getPropertyId()) || "null".equals(p.getPropertyId()) || !propertyVOMap.containsKey(Long.valueOf(p.getPropertyId())) || StringUtils.isBlank((CharSequence)p.getPropertyValueId()) || "null".equals(p.getPropertyValueId()) || !itemMap.containsKey(Long.valueOf(p.getPropertyValueId()))) continue;
                    tmpProperty = (MaterialCategoryPropertyVO)propertyVOMap.get(Long.valueOf(p.getPropertyId()));
                    tmpItem = new MaterialCategoryPropertySubItemVO();
                    tmpItem.setCategoryId(category.getId());
                    tmpItem.setHasNewPropertyVal(Integer.valueOf(0));
                    tmpItem.setPropertyName(tmpProperty.getName());
                    tmpItem.setId(Long.valueOf(p.getPropertyValueId()));
                    tmpItem.setName(((MaterialCategoryPropertySubItemVO)itemMap.get(tmpItem.getId())).getName());
                    tmpItem.setPropertyId(tmpProperty.getId());
                    tmpItem.setSequence(((MaterialCategoryPropertySubItemVO)itemMap.get(tmpItem.getId())).getSequence());
                    tmpItem.setProductCode(((MaterialCategoryPropertySubItemVO)itemMap.get(tmpItem.getId())).getProductCode());
                    tmpItem.setPropertySeq(tmpProperty.getSequence());
                    tmpItem.setProductCodeFlag(tmpProperty.getProductCodeFlag());
                    tmpItem.setRequiredFlag(tmpProperty.getRequiredFlag());
                    tmpItem.setKeyPropertyFlag(tmpProperty.getKeyPropertyFlag());
                    source.getSpecList().add(tmpItem);
                    propertyVOMap.remove(tmpItem.getPropertyId());
                }
                if (CollectionUtils.isNotEmpty((Collection)ma.getExtProperties()) && saveNewPropertyItem) {
                    for (ExtProperty exp : ma.getExtProperties()) {
                        tmpItem = null;
                        tmpProperty = (MaterialCategoryPropertyVO)propertyNameVOMap.get(exp.getPropertyKey());
                        if (null == tmpProperty) continue;
                        try {
                            List matchList;
                            if (CollectionUtils.isNotEmpty((Collection)tmpProperty.getItemList()) && CollectionUtils.isNotEmpty(matchList = tmpProperty.getItemList().stream().filter(item -> item.getName().toLowerCase().equals(exp.getPropertyValue().toLowerCase())).collect(Collectors.toList()))) {
                                tmpItem = (MaterialCategoryPropertySubItemVO)matchList.get(0);
                                tmpItem.setPropertyName(tmpProperty.getName());
                                tmpItem.setPropertySeq(tmpProperty.getSequence());
                                tmpItem.setRequiredFlag(tmpProperty.getRequiredFlag());
                                tmpItem.setKeyPropertyFlag(tmpProperty.getKeyPropertyFlag());
                            }
                            if (null == tmpItem) {
                                tmpItem = this.generateNewPropertyItem(tmpProperty, exp.getPropertyValue());
                            }
                            tmpProperty.getItemList().add(tmpItem);
                            itemMap.put(tmpItem.getId(), tmpItem);
                            source.getSpecList().add(tmpItem);
                            propertyVOMap.remove(tmpItem.getPropertyId());
                        }
                        catch (Exception e) {
                            this.logger.error("\u7269\u6599AI:{}\u8bc6\u522b\uff0c\u65b0\u589e\u5c5e\u6027:{}\u5931\u8d25\uff1a", (Object)JSONObject.toJSONString((Object)ma), (Object)JSONObject.toJSONString((Object)exp));
                        }
                    }
                }
                if ("4".equals(source.getMateType())) {
                    if (propertyVOMap.values().stream().filter(item -> null != item.getRequiredFlag() && Integer.valueOf(1).equals(item.getRequiredFlag())).count() > 0L) {
                        source.setMateType("1");
                        source.setConjectureMateType("1");
                    } else {
                        source.setMateType("2");
                        source.setConjectureMateType("2");
                        MaterialVO checkVo = new MaterialVO();
                        checkVo.setUnitId(source.getActualUnitId());
                        checkVo.setPropertyShowName(source.getActualMaterialSpec());
                        checkVo.setCategoryId(source.getActualCategoryId());
                        List<MaterialVO> checkList = this.materialService.checkUnitAndProperty(Collections.singletonList(checkVo), false);
                        if (CollectionUtils.isNotEmpty(checkList)) {
                            source.setActualMaterialCode(checkList.get(0).getCode());
                        }
                    }
                }
                if (StringUtils.isBlank((CharSequence)source.getActualMaterialCode())) {
                    MaterialVO tmp = this.generateMaterial(source);
                    this.materialService.generateMaterialCodeBatchNew(Collections.singletonList(tmp));
                    source.setActualMaterialCode(tmp.getCode());
                }
                if (CollectionUtils.isNotEmpty((Collection)source.getSpecList())) {
                    source.setConjectureMaterialSpec(source.getSpecList().stream().filter(item -> null != item.getId()).sorted((v1, v2) -> (null != v1.getPropertySeq() ? v1.getPropertySeq() : 0) - (null != v2.getPropertySeq() ? v2.getPropertySeq() : 0)).map(item -> item.getPropertyName() + "\uff1a" + item.getName()).collect(Collectors.joining("\uff1b")));
                    source.setActualMaterialSpec(source.getConjectureMaterialSpec());
                }
                if (!CollectionUtils.isNotEmpty((Collection)source.getSpecList())) continue;
                JSONArray specArr = new JSONArray();
                JSONObject json = null;
                for (MaterialCategoryPropertySubItemVO s : source.getSpecList()) {
                    json = (JSONObject)BeanMapper.map((Object)s, JSONObject.class);
                    json.put("id", (Object)s.getId().toString());
                    json.put("propertyItemId", (Object)s.getId().toString());
                    json.put("categoryId", (Object)s.getCategoryId().toString());
                    json.put("propertyId", (Object)s.getPropertyId().toString());
                    specArr.add((Object)json);
                }
                source.setActualMaterialSpecs(specArr.toJSONString());
            }
            if (CollectionUtils.isNotEmpty(secCategoryId)) {
                List<MaterialCategoryVO> secList = this.categoryService.queryCategoryListByIds(secCategoryId);
                Map secMap = secList.stream().collect(Collectors.toMap(BaseVO::getId, Function.identity(), (v1, v2) -> v1));
                for (MaterialConjectureVO s : sourceList) {
                    if (null == s.getActualSecCategoryId() || !secMap.containsKey(s.getActualSecCategoryId())) continue;
                    s.setActualSecCategoryCode(((MaterialCategoryVO)secMap.get(s.getActualSecCategoryId())).getCode());
                    s.setActualSecCategoryName(((MaterialCategoryVO)secMap.get(s.getActualSecCategoryId())).getName());
                }
            }
            this.conjectureService.saveOrUpdateBatch(BeanMapper.mapList(sourceList, MaterialConjectureEntity.class), sourceList.size(), false);
        }
        catch (Exception e) {
            this.logger.error("************ \u7269\u6599AI\u8bc6\u522b\u5931\u8d25\u5f02\u5e38", (Throwable)e);
            sourceList.stream().forEach(item -> item.setMateType("3"));
            this.logger.error("\u5c06\u5f53\u524d\uff1a\uff5b\uff5d\u6761\u7269\u6599 \u8bc6\u522b\u72b6\u6001\u66f4\u65b0\u4e3a\uff1a \u8bc6\u522b\u5931\u8d25. \u8bc6\u522b\u6279\u6b21\uff1a{}", (Object)sourceList.size(), (Object)sourceList.get(0).getIdentificationId());
            boolean saveFlag = this.conjectureService.saveOrUpdateBatch(BeanMapper.mapList(sourceList, MaterialConjectureEntity.class), sourceList.size(), false);
            this.logger.error("\u5c06\u5f53\u524d\u6761\u7269\u6599 \u8bc6\u522b\u72b6\u6001\u66f4\u65b0\u4e3a\uff1a \u8bc6\u522b\u5931\u8d25. \u7ed3\u679c\uff1a{}", (Object)sourceList.size(), (Object)saveFlag);
            return new AsyncResult(sourceList);
        }
        return new AsyncResult(sourceList);
    }

    private MaterialVO generateMaterial(MaterialConjectureVO source) {
        MaterialVO resp = new MaterialVO();
        resp.setName(source.getActualMaterialName());
        resp.setCategoryId(source.getActualCategoryId());
        resp.setCategoryName(source.getActualCategoryName());
        resp.setUnitId(source.getActualUnitId());
        resp.setUnitName(source.getActualUnitName());
        resp.setUnitId(source.getActualUnitId());
        ArrayList<MaterialPropertyRelationVO> relations = new ArrayList<MaterialPropertyRelationVO>();
        for (MaterialCategoryPropertySubItemVO item : source.getSpecList()) {
            MaterialPropertyRelationVO s = new MaterialPropertyRelationVO();
            s.setPropertySequence(item.getPropertySeq());
            s.setPropertyValue(item.getName());
            s.setCategoryId(item.getCategoryId());
            s.setPropertyName(item.getPropertyName());
            s.setProductCode(item.getProductCode());
            s.setPropertyId(item.getPropertyId());
            s.setProductCodeFlag(item.getProductCodeFlag());
            s.setPropertyItemId(item.getId());
            relations.add(s);
        }
        resp.setRelationList(relations);
        resp.setPropertyShowName(source.getActualMaterialSpec());
        return resp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MaterialCategoryPropertySubItemVO generateNewPropertyItem(MaterialCategoryPropertyVO property, String itemName) {
        MaterialCategoryPropertySubItemVO resp = null;
        try (Jedis jedis = this.jedisPool.getResource();){
            String itemStr = jedis.get("AI_CONJECTURE_ADD_ITEM::" + property.getId().toString() + itemName.toLowerCase());
            if (StringUtils.isNotBlank((CharSequence)itemStr)) {
                resp = (MaterialCategoryPropertySubItemVO)JSONObject.parseObject((String)itemStr, MaterialCategoryPropertySubItemVO.class);
            } else {
                Long setRs;
                resp = new MaterialCategoryPropertySubItemVO();
                resp.setName(itemName);
                resp.setPropertyName(property.getName());
                resp.setId(Long.valueOf(IdWorker.getId()));
                resp.setRequiredFlag(Integer.valueOf(0));
                resp.setEnabled(Integer.valueOf(1));
                resp.setProductCodeFlag(Integer.valueOf(0));
                resp.setProductCode(null);
                resp.setCategoryId(property.getCategoryId());
                resp.setPropertyId(property.getId());
                resp.setPropertySeq(property.getSequence());
                resp.setValidFlag(Integer.valueOf(1));
                if (null != resp) {
                    Integer maxSeq = CollectionUtils.isNotEmpty((Collection)property.getItemList()) ? property.getItemList().stream().max(Comparator.comparingInt(MaterialCategoryPropertySubItemVO::getSequence)).get().getSequence() : 0;
                    String maxSeqStr = jedis.get("AI_CONJECTURE_ITEM_MAX_SEQ::" + resp.getPropertyId().toString());
                    if (StringUtils.isBlank((CharSequence)maxSeqStr)) {
                        maxSeqStr = "0";
                    }
                    maxSeq = maxSeq > Integer.valueOf(maxSeqStr) ? maxSeq : Integer.valueOf(maxSeqStr);
                    maxSeq = maxSeq + 1;
                    jedis.setex("AI_CONJECTURE_ITEM_MAX_SEQ::" + resp.getPropertyId().toString(), 120, maxSeq.toString());
                    resp.setSequence(maxSeq);
                }
                if (!"1".equals((setRs = jedis.setnx("AI_CONJECTURE_ADD_ITEM::" + resp.getPropertyId().toString() + resp.getName().toLowerCase(), JSONObject.toJSONString((Object)resp))).toString())) {
                    itemStr = jedis.get("AI_CONJECTURE_ADD_ITEM::" + resp.getPropertyId().toString() + resp.getName().toLowerCase());
                    if (StringUtils.isNotBlank((CharSequence)itemStr)) {
                        resp = (MaterialCategoryPropertySubItemVO)JSONObject.parseObject((String)itemStr, MaterialCategoryPropertySubItemVO.class);
                    } else {
                        setRs = jedis.setnx("AI_CONJECTURE_ADD_ITEM::" + resp.getPropertyId().toString() + resp.getName().toLowerCase(), JSONObject.toJSONString((Object)resp));
                        if (!"1".equals(setRs.toString())) {
                            this.logger.error("\u7269\u6599AI\u8bc6\u522b\uff0c\u5c5e\u6027{} \u503c{}\u6dfb\u52a0\u5931\u8d25\uff0c{}", (Object)JSONObject.toJSONString((Object)property), (Object)itemName);
                            MaterialCategoryPropertySubItemVO materialCategoryPropertySubItemVO = null;
                            return materialCategoryPropertySubItemVO;
                        }
                    }
                }
                this.propertySubItemService.saveOrUpdate(BeanMapper.map((Object)resp, MaterialCategoryPropertySubItemEntity.class), false);
            }
        }
        return resp;
    }

    private void setContextInfo(String authority) {
        String[] authArr;
        InvocationInfoProxy.setExtendAttribute((Object)"authority", (Object)authority);
        InvocationInfoProxy.setParameter((String)"authority", (String)authority);
        block14: for (String item : authArr = authority.split(";")) {
            String[] authItem = item.split("=");
            switch (authItem[0]) {
                case "tenantid": {
                    InvocationInfoProxy.setTenantid((Long)Long.valueOf(authItem[1]));
                    continue block14;
                }
                case "orgId": {
                    InvocationInfoProxy.setOrgId((Long)Long.valueOf(authItem[1]));
                    continue block14;
                }
                case "userId": {
                    InvocationInfoProxy.setUserid((Long)Long.valueOf(authItem[1]));
                    continue block14;
                }
                case "userType": {
                    InvocationInfoProxy.setUserType((String)authItem[1]);
                    continue block14;
                }
                case "userCode": {
                    InvocationInfoProxy.setUsercode((String)authItem[1]);
                    continue block14;
                }
            }
        }
    }

    @Override
    public Map<Long, MaterialConjectureVO> similarSearch(String searchText, Integer topLimit, String[] queryRange) {
        HashMap<Long, MaterialConjectureVO> resp = new HashMap<Long, MaterialConjectureVO>();
        String url = this.reqHost + "/similar_item_search";
        JSONObject param = new JSONObject();
        HashMap<String, String> headers = new HashMap<String, String>();
        String reqResult = null;
        try {
            headers.put("Content-Type", "application/json;charset=UTF-8");
            param.put("user_query", (Object)searchText);
            param.put("query_limit", (Object)(null != topLimit ? topLimit : this.similarLimit));
            param.put("query_rang", (Object)queryRange);
            reqResult = HttpTookit.postByJson(url, param.toJSONString(), headers, 300000, 300000);
            this.logger.info("\u7269\u6599AI\u5339\u914d\u3010\u957f\u6c5f\u4e91\u901a\u3011, \u5730\u5740\uff1a{}, \u53c2\u6570\uff1a{}\uff0c\u7269\u6599\u8bc6\u522b\u7ed3\u679c\uff1a{}", new Object[]{url, JSONObject.toJSONString((Object)param), reqResult});
            JSONArray matchArr = JSONArray.parseArray((String)reqResult);
            MaterialConjectureVO tmpVo = null;
            if (matchArr.size() > 0) {
                JSONObject tmpJson = null;
                HashMap materialIds = new HashMap();
                for (Object obj : matchArr) {
                    tmpJson = (JSONObject)obj;
                    if (this.similarThreshold.compareTo(tmpJson.getBigDecimal("distance")) > 0) continue;
                    tmpVo = new MaterialConjectureVO();
                    tmpVo.setActualMaterialId(tmpJson.getLong("id"));
                    tmpVo.setSimilarCoefficient(ComputeUtil.safeMultiply((BigDecimal)tmpJson.getBigDecimal("distance"), (BigDecimal)new BigDecimal("100")).setScale(2, 1));
                    resp.put(tmpVo.getActualMaterialId(), tmpVo);
                }
            }
        }
        catch (Exception e) {
            this.logger.error("\u7269\u6599AI\u5339\u914d\u5f02\u5e38,", (Throwable)e);
        }
        return resp;
    }
}

