package com.ejianc.business.zdsmaterial.pricelib.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.zdsmaterial.erp.service.IErpMaterialPriceService;
import com.ejianc.business.zdsmaterial.erp.vo.ErpMaterialPriceVO;
import com.ejianc.business.zdsmaterial.material.service.IMaterialBasePriceContentService;
import com.ejianc.business.zdsmaterial.material.service.IMaterialCategoryService;
import com.ejianc.business.zdsmaterial.material.service.IMaterialService;
import com.ejianc.business.zdsmaterial.material.vo.MaterialBasePriceContentVO;
import com.ejianc.business.zdsmaterial.material.vo.MaterialCategoryVO;
import com.ejianc.business.zdsmaterial.material.vo.MaterialVO;
import com.ejianc.business.zdsmaterial.plan.conjecture.bean.MaterialConjectureEntity;
import com.ejianc.business.zdsmaterial.plan.conjecture.handler.ConjectureManageFactory;
import com.ejianc.business.zdsmaterial.plan.conjecture.service.IMaterialConjectureService;
import com.ejianc.business.zdsmaterial.plan.conjecture.vo.MaterialConjectureVO;
import com.ejianc.business.zdsmaterial.pricelib.engine.PricingEngine;
import com.ejianc.business.zdsmaterial.pricelib.engine.PricingFactory;
import com.ejianc.business.zdsmaterial.pricelib.service.IMaterialPriceCalcService;
import com.ejianc.business.zdsmaterial.pricelib.service.IMaterialPriceCalcSubConditionService;
import com.ejianc.business.zdsmaterial.pricelib.service.IPriceContractService;
import com.ejianc.business.zdsmaterial.pricelib.vo.MaterialPriceCalcSubConditionVO;
import com.ejianc.business.zdsmaterial.pricelib.vo.MaterialPriceCalcVO;
import com.ejianc.business.zdsmaterial.pricelib.vo.PriceLibVO;
import com.ejianc.business.zdsmaterial.util.ComputeUtil;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @Author: caojie
 * @CreateTime:2025-07-02 16:33
 * @Version: 1.0
 */
@RestController
@RequestMapping(value = "/materialPriceNew")
public class MaterialPriceNewController {

    @Autowired
    private IMaterialConjectureService materialConjectureService;

    @Autowired
    private IMaterialCategoryService categoryService;

    @Autowired
    private ConjectureManageFactory factory;

    @Value("${material.ai.handlerName:CJYT}")
    private String handlerName;

    @Autowired
    private IMaterialService materialService;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IPriceContractService priceContractService;

    @Autowired
    private IMaterialPriceCalcService materialPriceCalcService;

    @Autowired
    private IErpMaterialPriceService erpMaterialPriceService;

    @Autowired
    private IMaterialBasePriceContentService materialBasePriceContentService;

    @Autowired
    private IMaterialPriceCalcSubConditionService priceCalcSubConditionService;


    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @PostMapping(value = "/getCategoryTree")
    public CommonResponse<List<Map<String, Object>>> getCategoryTree(@RequestBody QueryParam param) {

        List<Long> categoryIds = new ArrayList<>();
        if(param.getParams().containsKey("searchAI")) {
            Map<Long, MaterialConjectureVO> searchList = new HashMap<>();
            searchList.putAll(factory.similarSearch(handlerName, param.getParams().get("searchAI").getValue().toString(), null, new String[0]));
            if(MapUtils.isNotEmpty(searchList)) {
                List<MaterialVO> materialVOS = materialService.queryDetailList(new ArrayList<>(searchList.keySet()), false);
                categoryIds.addAll(materialVOS.stream().map(MaterialVO::getCategoryId).collect(Collectors.toList()));
            }
            if(CollectionUtils.isEmpty(categoryIds)) {
                return CommonResponse.success(new ArrayList<>());
            }
        }
        if(param.getParams().containsKey("curIdentifyId")) {
            //当前物料识别标识 查询已加载子表中的数据
            List<MaterialConjectureEntity> list = materialConjectureService.getAllByIdentifyId(param.getParams().get("curIdentifyId").getValue().toString(), null,
                    null, null,null, null, null, null, "1");
            if(CollectionUtils.isNotEmpty(list)) {
                categoryIds.addAll(list.stream().map(MaterialConjectureEntity::getActualCategoryId).collect(Collectors.toList()));
            }
        }
        if(CollectionUtils.isNotEmpty(categoryIds)) {
            List<MaterialCategoryVO> categoryVOS = categoryService.queryCategoryListByChildren(categoryIds);

            //根据物料分类查询对应价格计算规则
            List<MaterialPriceCalcVO> dataList = materialPriceCalcService.getAllByCategoryIds(categoryIds);
            Map<Long, MaterialPriceCalcVO> detailMap = dataList.stream().collect(Collectors.toMap(MaterialPriceCalcVO::getCategoryId, Function.identity()));

            categoryVOS.stream().filter(item -> detailMap.containsKey(item.getId())).forEach(item -> {
                item.setMaterialType(detailMap.get(item.getId()).getMaterialType());
                item.setMaterialTypeId(detailMap.get(item.getId()).getMaterialTypeId());
                item.setMaterialTypeName(detailMap.get(item.getId()).getMaterialTypeName());
                item.setEnabled(detailMap.get(item.getId()).getEnabled());
                item.setCalcFields(detailMap.get(item.getId()).getCalcFields());
            });

            return CommonResponse.success("查询成功", ResultAsTree.createTreeData(BeanMapper.mapList(categoryVOS, Map.class)));
        }

        return CommonResponse.success("查询列表数据成功！", new ArrayList<>());
    }

    @PostMapping(value = "/queryList")
    public CommonResponse<List<PriceLibVO>> queryList(@RequestBody QueryParam param) {
        List<Long> categoryIds = new ArrayList<>();
        List<PriceLibVO> actualList = new ArrayList<>();
        QueryParam basePriceQuery = new QueryParam();
        List<PriceLibVO> priceLibList = null;


        if(param.getParams().containsKey("searchAI")) {
            Map<Long, MaterialConjectureVO> searchList = new HashMap<>();
            List<Long> materialIds = new ArrayList<>();
            searchList.putAll(factory.similarSearch(handlerName, param.getParams().get("searchAI").getValue().toString(), null, new String[0]));
            if(MapUtils.isNotEmpty(searchList)) {
                materialIds.addAll(new ArrayList<>(searchList.keySet()));
            } else {
                materialIds.addAll(Collections.singletonList(-9L));
            }
            param.getParams().put("materialId", Parameter.getInInstance(materialIds));
            param.getParams().remove("searchAI");

            // 初始化参数
            logger.info("查询价格库，查询参数：{}", JSONObject.toJSONString(param));
            List<Long> orgIdList = priceContractService.queryOrgIdList();
            priceLibList = priceContractService.queryPriceLibListAll(null, null, orgIdList, param);

            if(param.getParams().containsKey("categoryId")) {
                param.getParams().put("material_type_id", param.getParams().get("categoryId"));
                param.getParams().remove("categoryId");
            }

            for(PriceLibVO p :priceLibList) {
                if(searchList.containsKey(p.getMaterialId())) {
                    p.setSimilarCoefficient(searchList.get(p.getMaterialId()).getSimilarCoefficient());
                }
                if(!categoryIds.contains(p.getMaterialTypeId())) {
                    categoryIds.add(p.getMaterialTypeId());
                }
            }

            //存入ES 待计算使用
            priceLibList.sort((v1, v2) -> ComputeUtil.safeSub(v2.getSimilarCoefficient(), v1.getSimilarCoefficient()).intValue());
            actualList.addAll(priceLibList);

            basePriceQuery.getParams().put("material_class_id", Parameter.getInInstance(categoryIds));
            if(CollectionUtils.isEmpty(priceLibList)) {
                return CommonResponse.success(new ArrayList<>());
            }
        }

        Map<String, MaterialConjectureEntity> conMap = new HashMap<>();
        if(param.getParams().containsKey("curIdentifyId")) {
            Set<Long> materialIds = new HashSet<>();
            Set<String> materialCode = new HashSet<>();
            Long categoryId = null;
            if(param.getParams().containsKey("categoryId")) {
                categoryId = Long.valueOf(param.getParams().get("categoryId").getValue().toString());

                param.getParams().remove("categoryId");
                //根据物料分类id查询本下
                categoryIds = categoryService.queryChildrenIdsByPIds(Collections.singletonList(categoryId));
            }

            //当前物料识别标识 查询已加载子表中的数据
            List<MaterialConjectureEntity> list = materialConjectureService.getAllByIdentifyId(param.getParams().get("curIdentifyId").getValue().toString(), null,
                    null, null,null, null,
                    null, null, "1", categoryIds);
            if(CollectionUtils.isNotEmpty(list)) {
                ComplexParam c = new ComplexParam();
                c.setLogic(ComplexParam.AND);
                list.stream().forEach(m -> {
                    conMap.put(m.getActualMaterialCode() + m.getActualUnitName(), m);
                    materialIds.add(m.getActualMaterialId());
                    materialCode.add(m.getActualMaterialCode());

                    ComplexParam c2 = new ComplexParam();
                    c2.setLogic(ComplexParam.OR);
                    c2.getParams().put("material_id", Parameter.getEqInstance(m.getActualMaterialId()));
                    if(null != m.getSupplierId()) {
                        c2.getParams().put("supplier_id", Parameter.getEqInstance(m.getSupplierId()));
                    }
                    if(null != m.getBrandId()) {
                        c2.getParams().put("brand_id", Parameter.getEqInstance(m.getBrandId()));
                    }
                    if(null != m.getBrandId()) {
                        c2.getParams().put("brand_id", Parameter.getEqInstance(m.getBrandId()));
                    }

                    c.getComplexParams().add(c2);
                });

                param.getParams().put("materialCode", Parameter.getInInstance(new ArrayList<>(materialCode)));
            }

            param.getParams().remove("curIdentifyId");

            // 初始化参数
            logger.info("查询价格库，查询参数：{}", JSONObject.toJSONString(param));
            List<Long> orgIdList = priceContractService.queryOrgIdList();
            priceLibList = priceContractService.queryPriceLibListAll(null, null, orgIdList, param);
            if(CollectionUtils.isEmpty(categoryIds)) {
                categoryIds = list.stream().map(MaterialConjectureEntity::getActualCategoryId).collect(Collectors.toList());
            }
        }

        basePriceQuery.getParams().put("status", Parameter.getEqInstance("1"));
        actualList = fillPriceInfo(priceLibList,
                categoryIds,
                basePriceQuery, conMap);

        List<MaterialCategoryVO> categoryVOS = categoryService.queryCategoryListByIds(categoryIds);
        Map<Long, MaterialCategoryVO> categoryVOMap = categoryVOS.stream().collect(Collectors.toMap(item -> item.getId(), item -> item));
        //根据物料分类查询对应的计算规则设置
        Map<Long, List<MaterialPriceCalcSubConditionVO>> conditionMap = materialPriceCalcService.getConditionMapByCategoryIds(categoryIds);

        actualList.parallelStream().forEach(p -> {
            try {
                PricingEngine engine = PricingFactory.getEngine(categoryVOMap.get(p.getMaterialTypeId()).getCode());
                if(null != engine) {
                    engine.calcPrice(p, conditionMap.get(p.getMaterialTypeId()));
                } else {
                    logger.error("物料: {} 获取对应计算引擎为空", JSONObject.toJSONString(p));
                    p.setAdjustedPrice(BigDecimal.ZERO);
                }
            } catch (Exception e) {
                logger.error("物料: {}价格计算异常", JSONObject.toJSONString(p));
                logger.error("物料价格计算异常", e);

                p.setAdjustedPrice(BigDecimal.ZERO);
            }
            if(!p.getCalcContent().contains("未计算")) {
                //计算调整比例
                p.setAdjustedRatio(ComputeUtil.safeMultiply(
                        ComputeUtil.safeDiv(
                                ComputeUtil.safeSub(p.getAdjustedPrice(), p.getBaseMaterialPrice())
                                , p.getBaseMaterialPrice()), new BigDecimal("100")));
            }

        });

        return CommonResponse.success("查询成功", actualList);
    }

    @PostMapping(value = "/excelExport")
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List<Long> categoryIds = new ArrayList<>();
        List<PriceLibVO> actualList = new ArrayList<>();
        QueryParam basePriceQuery = new QueryParam();
        List<PriceLibVO> priceLibList = null;
        Map<String, MaterialConjectureEntity> conMap = new HashMap<>();


        if(param.getParams().containsKey("searchAI")) {
            Map<Long, MaterialConjectureVO> searchList = new HashMap<>();
            List<Long> materialIds = new ArrayList<>();
            searchList.putAll(factory.similarSearch(handlerName, param.getParams().get("searchAI").getValue().toString(), null, new String[0]));
            if(MapUtils.isNotEmpty(searchList)) {
                materialIds.addAll(new ArrayList<>(searchList.keySet()));
            } else {
                materialIds.addAll(Collections.singletonList(-9L));
            }
            param.getParams().put("materialId", Parameter.getInInstance(materialIds));
            param.getParams().remove("searchAI");

            // 初始化参数
            logger.info("查询价格库，查询参数：{}", JSONObject.toJSONString(param));
            List<Long> orgIdList = priceContractService.queryOrgIdList();
            priceLibList = priceContractService.queryPriceLibListAll(null, null, orgIdList, param);

            if(param.getParams().containsKey("categoryId")) {
                param.getParams().put("material_type_id", param.getParams().get("categoryId"));
                param.getParams().remove("categoryId");
            }

            for(PriceLibVO p :priceLibList) {
                if(searchList.containsKey(p.getMaterialId())) {
                    p.setSimilarCoefficient(searchList.get(p.getMaterialId()).getSimilarCoefficient());
                }
                if(!categoryIds.contains(p.getMaterialTypeId())) {
                    categoryIds.add(p.getMaterialTypeId());
                }
            }

            priceLibList.sort((v1, v2) -> ComputeUtil.safeSub(v2.getSimilarCoefficient(), v1.getSimilarCoefficient()).intValue());
            actualList.addAll(priceLibList);

            basePriceQuery.getParams().put("material_class_id", Parameter.getInInstance(categoryIds));

        } else if(param.getParams().containsKey("curIdentifyId")) {
            Set<Long> materialIds = new HashSet<>();
            Set<String> materialCode = new HashSet<>();

            //当前物料识别标识 查询已加载子表中的数据
            List<MaterialConjectureEntity> list = materialConjectureService.getAllByIdentifyId(param.getParams().get("curIdentifyId").getValue().toString(), null,
                    null, null,null, null,
                    null, null, "1");
            if(CollectionUtils.isNotEmpty(list)) {
                ComplexParam c = new ComplexParam();
                c.setLogic(ComplexParam.AND);
                list.stream().forEach(m -> {
                    conMap.put(m.getActualMaterialCode() + m.getActualUnitName(), m);
                    materialIds.add(m.getActualMaterialId());
                    materialCode.add(m.getActualMaterialCode());

                    ComplexParam c2 = new ComplexParam();
                    c2.setLogic(ComplexParam.OR);
                    c2.getParams().put("material_id", Parameter.getEqInstance(m.getActualMaterialId()));
                    if(null != m.getSupplierId()) {
                        c2.getParams().put("supplier_id", Parameter.getEqInstance(m.getSupplierId()));
                    }
                    if(null != m.getBrandId()) {
                        c2.getParams().put("brand_id", Parameter.getEqInstance(m.getBrandId()));
                    }
                    if(null != m.getBrandId()) {
                        c2.getParams().put("brand_id", Parameter.getEqInstance(m.getBrandId()));
                    }

                    c.getComplexParams().add(c2);
                });

                param.getParams().put("materialCode", Parameter.getInInstance(new ArrayList<>(materialCode)));
            }

            param.getParams().remove("curIdentifyId");

            // 初始化参数
            logger.info("查询价格库，查询参数：{}", JSONObject.toJSONString(param));
            List<Long> orgIdList = priceContractService.queryOrgIdList();
            priceLibList = priceContractService.queryPriceLibListAll(null, null, orgIdList, param);
            if(CollectionUtils.isEmpty(categoryIds)) {
                categoryIds = list.stream().map(MaterialConjectureEntity::getActualCategoryId).collect(Collectors.toList());
            }
        }

        basePriceQuery.getParams().put("status", Parameter.getEqInstance("1"));
        actualList = fillPriceInfo(priceLibList,
                categoryIds,
                basePriceQuery, conMap);

        List<MaterialCategoryVO> categoryVOS = categoryService.queryCategoryListByIds(categoryIds);
        Map<Long, MaterialCategoryVO> categoryVOMap = categoryVOS.stream().collect(Collectors.toMap(item -> item.getId(), item -> item));
        //根据物料分类查询对应的计算规则设置
        Map<Long, List<MaterialPriceCalcSubConditionVO>> conditionMap = materialPriceCalcService.getConditionMapByCategoryIds(categoryIds);

        actualList.parallelStream().forEach(p -> {
            try {
                PricingEngine engine = PricingFactory.getEngine(categoryVOMap.get(p.getMaterialTypeId()).getCode());
                if(null != engine) {
                    engine.calcPrice(p, conditionMap.get(p.getMaterialTypeId()));
                } else {
                    logger.error("物料: {} 获取对应计算引擎为空", JSONObject.toJSONString(p));
                    p.setAdjustedPrice(BigDecimal.ZERO);
                }
            } catch (Exception e) {
                logger.error("物料: {}价格计算异常", JSONObject.toJSONString(p));
                logger.error("物料价格计算异常", e);

                p.setAdjustedPrice(BigDecimal.ZERO);
            }
            if(!p.getCalcContent().contains("未计算")) {
                //计算调整比例
                p.setAdjustedRatio(ComputeUtil.safeMultiply(
                        ComputeUtil.safeDiv(
                                ComputeUtil.safeSub(p.getAdjustedPrice(), p.getBaseMaterialPrice())
                                , p.getBaseMaterialPrice()), new BigDecimal("100")));
            }

        });

        Map<String, Object> beans = new HashMap<>();
        beans.put("records", actualList);
        ExcelExport.getInstance().export("priceLib-export.xlsx", beans, response);
    }

    @PostMapping(value = "/changeLoadStatus")
    @ResponseBody
    public CommonResponse<List<PriceLibVO>> changeLoadStatus(@RequestBody List<Long> ids, @RequestParam String loadState) {
        UpdateWrapper<MaterialConjectureEntity> update = new UpdateWrapper<>();
        update.in("id", ids);
        update.set("load_state", loadState);
        update.set("update_user_code", InvocationInfoProxy.getUsercode());
        update.set("update_time", new Date());

        materialConjectureService.update(update);


        QueryParam param = new QueryParam();
        QueryParam basePriceQuery = new QueryParam();
        Map<String, MaterialConjectureEntity> conMap = new HashMap<>();

        //价格计算
        Set<String> materialCodes = new HashSet<>();
        //当前物料识别标识 查询已加载子表中的数据
        List<MaterialConjectureEntity> list = (List<MaterialConjectureEntity>) materialConjectureService.listByIds(ids);
        if(CollectionUtils.isNotEmpty(list)) {
            ComplexParam c = new ComplexParam();
            c.setLogic(ComplexParam.AND);
            list.stream().forEach(m -> {
                conMap.put(m.getActualMaterialCode() + m.getActualUnitName(), m);
                materialCodes.add(m.getActualMaterialCode());

                ComplexParam c2 = new ComplexParam();
                c2.setLogic(ComplexParam.OR);
                c2.getParams().put("material_id", Parameter.getEqInstance(m.getActualMaterialId()));
                if(null != m.getSupplierId()) {
                    c2.getParams().put("supplier_id", Parameter.getEqInstance(m.getSupplierId()));
                }
                if(null != m.getBrandId()) {
                    c2.getParams().put("brand_id", Parameter.getEqInstance(m.getBrandId()));
                }
                if(null != m.getBrandId()) {
                    c2.getParams().put("brand_id", Parameter.getEqInstance(m.getBrandId()));
                }

                c.getComplexParams().add(c2);
            });

            param.getParams().put("materialCode", Parameter.getInInstance(new ArrayList<>(materialCodes)));
            param.getParams().remove("curIdentifyId");
        }


        // 初始化参数
        logger.info("查询价格库，查询参数：{}", JSONObject.toJSONString(param));
        List<Long> orgIdList = priceContractService.queryOrgIdList();
        List<PriceLibVO> priceLibList = priceContractService.queryPriceLibListAll(null, null, orgIdList, param);

        List<Long> categoryIds = list.stream().map(MaterialConjectureEntity::getActualCategoryId).collect(Collectors.toList());
        List<PriceLibVO> actualList = fillPriceInfo(priceLibList,
                categoryIds,
                basePriceQuery, conMap);


        calcMaterial(categoryIds, actualList);

        return CommonResponse.success("操作成功！", actualList);
    }

    private List<PriceLibVO> calcMaterial(List<Long> categoryIds, List<PriceLibVO> actualList) {
        List<MaterialCategoryVO> categoryVOS = categoryService.queryCategoryListByIds(categoryIds);
        Map<Long, MaterialCategoryVO> categoryVOMap = categoryVOS.stream().collect(Collectors.toMap(item -> item.getId(), item -> item));
        //根据物料分类查询对应的计算规则设置
        Map<Long, List<MaterialPriceCalcSubConditionVO>> conditionMap = materialPriceCalcService.getConditionMapByCategoryIds(categoryIds);

        actualList.parallelStream().forEach(p -> {
            try {
                PricingEngine engine = PricingFactory.getEngine(categoryVOMap.get(p.getMaterialTypeId()).getCode());
                if(null != engine) {
                    engine.calcPrice(p, conditionMap.get(p.getMaterialTypeId()));
                } else {
                    logger.error("物料: {} 获取对应计算引擎为空", JSONObject.toJSONString(p));
                    p.setAdjustedPrice(BigDecimal.ZERO);
                    p.setCalcContent("未匹配到对应计算引擎");
                }
            } catch (Exception e) {
                logger.error("物料: {}价格计算异常", JSONObject.toJSONString(p));
                logger.error("物料价格计算异常", e);
                p.setCalcContent("价格计算失败");

                p.setAdjustedPrice(BigDecimal.ZERO);
            }
            if(!p.getCalcContent().contains("未计算")) {
                //计算调整比例
                p.setAdjustedRatio(ComputeUtil.safeMultiply(
                        ComputeUtil.safeDiv(
                                ComputeUtil.safeSub(p.getAdjustedPrice(), p.getBaseMaterialPrice())
                                , p.getBaseMaterialPrice()), new BigDecimal("100")));
            }

        });

        return actualList;
    }

    @PostMapping(value = "/reCalc")
    public CommonResponse<List<PriceLibVO>> reCalc(@RequestBody List<PriceLibVO> vos) {

        List<Long> categoryIds = new ArrayList<>(vos.stream().map(PriceLibVO::getMaterialTypeId).collect(Collectors.toSet()));
        List<MaterialCategoryVO> categoryVOS = categoryService.queryCategoryListByIds(categoryIds);
        Map<Long, MaterialCategoryVO> categoryVOMap = categoryVOS.stream().collect(Collectors.toMap(item -> item.getId(), item -> item));

        //价格计算
        calcMaterial(categoryIds, vos);

        return CommonResponse.success("计算成功！", vos);
    }

    public List<PriceLibVO> fillPriceInfo(List<PriceLibVO> vos, List<Long> categoryIds, QueryParam basePriceQuery,
                                          Map<String, MaterialConjectureEntity> conMap) {
        //根据物料查询基础物料价格库
        List<MaterialBasePriceContentVO> pricevos = materialBasePriceContentService.getLatestPrice(basePriceQuery);
        Map<String, List<MaterialBasePriceContentVO>> priceMap = new HashMap<>();
        priceMap.putAll(pricevos.stream().collect(Collectors.groupingBy(item -> item.getMaterialCode())));


        //查询物料分类信息
        List<MaterialCategoryVO> categoryVOS = categoryService.getAllByIds(categoryIds);
        Map<Long, MaterialCategoryVO> categoryMap = categoryVOS.stream().collect(Collectors.toMap(item -> item.getId(), item -> item));

        //根据物料分类查询分类对应基础材料
        List<MaterialPriceCalcVO> priceCalcVOS = materialPriceCalcService.getAllByCategoryIds(categoryIds);
        Map<Long, MaterialPriceCalcVO> priceCalcVOMap = new HashMap<>();
        priceCalcVOMap.putAll(priceCalcVOS.stream().collect(Collectors.toMap(item -> item.getCategoryId(), item -> item)));

        //根据基础材料查询基础材料网价
        Map<Long, ErpMaterialPriceVO> netPriceMap = new HashMap<>();
        if(CollectionUtils.isNotEmpty(priceCalcVOS)) {
            List<ErpMaterialPriceVO> erpMaterialPriceVOS = erpMaterialPriceService.
                    getAllByErpMaterialIds(priceCalcVOS.stream().map(MaterialPriceCalcVO::getMaterialTypeId).collect(Collectors.toList()));
            netPriceMap.putAll(erpMaterialPriceVOS.stream().collect(Collectors.toMap(item ->item.getBaseMaterialId(), item -> item)));
        }

        MaterialConjectureEntity tmpC = null;
        List<PriceLibVO> actualList = new ArrayList<>();
        PriceLibVO tmp = null;

        List<PriceLibVO> processList = new ArrayList<>();
        //填充历史价格信息
        for(PriceLibVO p : vos) {
            if(!categoryMap.containsKey(p.getMaterialTypeId())) {
                continue;
            }
            tmpC = conMap.get(p.getMaterialId().toString() + p.getUnitName());
            if(null != tmpC) {
                conMap.remove(p.getMaterialCode() + p.getUnitName());
                p.setId(tmpC.getId());
                p.setBrand(tmpC.getBrandName());
                p.setBrandId(tmpC.getBrandId());
                p.setSupplierName(tmpC.getSupplierName());
                p.setSupplierId(tmpC.getSupplierId());
                p.setExtParam1(tmpC.getExtParam1());
                p.setExtParam2(tmpC.getExtParam2());
                p.setSourceNum(tmpC.getSourceNum());
                p.setSourceMaterialName(tmpC.getSourceMaterialName());
                p.setSourceUnitName(tmpC.getSourceUnitName());
                p.setSourceMaterialSpec(tmpC.getSourceMaterialSpec());
            }
            processList.add(p);
        }

        //处理无对应历史价格信息的数据
        if(!conMap.isEmpty()) {
            PriceLibVO tmpP = null;
            for(MaterialConjectureEntity c : conMap.values()) {
                if(!categoryMap.containsKey(c.getActualCategoryId())) {
                    continue;
                }

                tmpP = new PriceLibVO();
                tmpP.setId(c.getId());
                tmpP.setMaterialId(c.getActualMaterialId());
                tmpP.setMaterialCode(c.getActualMaterialCode());
                tmpP.setMaterialName(c.getActualMaterialName());
                tmpP.setMaterialTypeId(c.getActualCategoryId());
                if(categoryMap.containsKey(c.getActualCategoryId())) {
                    tmpP.setMaterialTypeName(categoryMap.get(c.getActualCategoryId()).getName());
                }
                tmpP.setBrand(c.getBrandName());
                tmpP.setBrandId(c.getBrandId());
                tmpP.setSupplierName(c.getSupplierName());
                tmpP.setSupplierId(c.getSupplierId());
                tmpP.setSpec(c.getActualMaterialSpec());
                tmpP.setUnitName(c.getActualUnitName());
                tmpP.setUnitId(c.getActualUnitId());

                tmpP.setExtParam1(c.getExtParam1());
                tmpP.setExtParam2(c.getExtParam2());

                tmpP.setSourceNum(c.getSourceNum());
                tmpP.setSourceMaterialName(c.getSourceMaterialName());
                tmpP.setSourceUnitName(c.getSourceUnitName());
                tmpP.setSourceMaterialSpec(c.getSourceMaterialSpec());

                processList.add(tmpP);
            }
        }

        //设置原材料基础价、基础单价、网价
        for(PriceLibVO p : processList) {
            if(priceMap.containsKey(p.getMaterialCode())) {
                boolean breakFlag =false;
                boolean addFlag = false;
                for(MaterialBasePriceContentVO mp : priceMap.get(p.getMaterialCode())) {
                    tmp = null;
                    if(null != p.getSupplierId() && StringUtils.isNotBlank(p.getArea())) {
                        if(mp.getSupplierId().equals(p.getSupplierId()) && mp.getArea().equals(mp.getArea())) {
                            tmp = BeanMapper.map(p, PriceLibVO.class);
                            //设备基础价、原材料基价
                            tmp.setBaseMaterialPrice(mp.getBasePrice());
                            tmp.setBaseTwoMaterialPrice(mp.getBaseTwoPrice());
                            tmp.setBaseMaterialUnitPrice(mp.getBaseOriginPrice());
                            breakFlag = true;
                        }
                    } else if(null != p.getSupplierId()) {
                        if(p.getSupplierId().equals(mp.getSupplierId())) {
                            tmp = BeanMapper.map(p, PriceLibVO.class);
                            //设备基础价、原材料基价
                            tmp.setBaseMaterialPrice(mp.getBasePrice());
                            tmp.setBaseMaterialUnitPrice(mp.getBaseOriginPrice());
                            tmp.setBaseTwoMaterialPrice(mp.getBaseTwoPrice());
                            breakFlag = true;
                        }
                    } else if(StringUtils.isNotBlank(p.getArea())) {
                        if(StringUtils.equals(p.getArea(), mp.getArea()) || "全国".equals(p.getArea())) {
                            tmp = BeanMapper.map(p, PriceLibVO.class);
                            //设备基础价、原材料基价
                            tmp.setBaseMaterialPrice(mp.getBasePrice());
                            tmp.setBaseMaterialUnitPrice(mp.getBaseOriginPrice());
                            tmp.setBaseTwoMaterialPrice(mp.getBaseTwoPrice());
                            breakFlag = true;
                        }
                    } else {
                        tmp = BeanMapper.map(p, PriceLibVO.class);
                        tmp.setId(IdWorker.getId());
                        //设备基础价、原材料基价
                        tmp.setBaseMaterialPrice(mp.getBasePrice());
                        tmp.setBaseMaterialUnitPrice(mp.getBaseOriginPrice());
                        tmp.setBaseTwoMaterialPrice(mp.getBaseTwoPrice());
                    }
                    if(null != tmp) {
                        tmp.setId(IdWorker.getId());
                        //设置原材料
                        if(priceCalcVOMap.containsKey(tmp.getMaterialTypeId())) {
                            tmp.setBaseMaterialId(priceCalcVOMap.get(tmp.getMaterialTypeId()).getMaterialTypeId());
                            tmp.setBaseMaterialCode(priceCalcVOMap.get(tmp.getMaterialTypeId()).getMaterialType());
                            tmp.setBaseMaterialName(priceCalcVOMap.get(tmp.getMaterialTypeId()).getMaterialTypeName());
                        }
                        //设置原材料网价
                        if(null != tmp.getBaseMaterialId() && netPriceMap.containsKey(tmp.getBaseMaterialId())) {
                            tmp.setBaseMaterialNetPrice(netPriceMap.get(tmp.getBaseMaterialId()).getPrice());
                        }
                        addFlag = true;
                        actualList.add(tmp);
                        if(breakFlag) {
                            break;
                        }
                    }
                }
                if(!addFlag) {
                    //设置原材料
                    if(priceCalcVOMap.containsKey(p.getMaterialTypeId())) {
                        p.setBaseMaterialId(priceCalcVOMap.get(p.getMaterialTypeId()).getMaterialTypeId());
                        p.setBaseMaterialCode(priceCalcVOMap.get(p.getMaterialTypeId()).getMaterialType());
                        p.setBaseMaterialName(priceCalcVOMap.get(p.getMaterialTypeId()).getMaterialTypeName());
                    }
                    actualList.add(p);
                }
            } else {
                //设置原材料
                if(priceCalcVOMap.containsKey(p.getMaterialTypeId())) {
                    p.setBaseMaterialId(priceCalcVOMap.get(p.getMaterialTypeId()).getMaterialTypeId());
                    p.setBaseMaterialCode(priceCalcVOMap.get(p.getMaterialTypeId()).getMaterialType());
                    p.setBaseMaterialName(priceCalcVOMap.get(p.getMaterialTypeId()).getMaterialTypeName());
                }
                //设置原材料网价
                if(null != p.getBaseMaterialId() && netPriceMap.containsKey(p.getBaseMaterialId())) {
                    p.setBaseMaterialNetPrice(netPriceMap.get(p.getBaseMaterialId()).getPrice());
                }
                p.setId(IdWorker.getId());
                actualList.add(p);
            }
        }

        return actualList;
    }


}
