/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.out.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.zdsmaterial.out.bean.DisposeDetailEntity;
import com.ejianc.business.zdsmaterial.out.bean.DisposeEntity;
import com.ejianc.business.zdsmaterial.out.mapper.DisposeMapper;
import com.ejianc.business.zdsmaterial.out.service.IDisposeService;
import com.ejianc.business.zdsmaterial.out.vo.DisposeDetailVO;
import com.ejianc.business.zdsmaterial.out.vo.DisposeVO;
import com.ejianc.business.zdsstore.api.IStoreFlowApi;
import com.ejianc.business.zdsstore.api.IStoreManageApi;
import com.ejianc.business.zdsstore.consts.InOutTypeEnum;
import com.ejianc.business.zdsstore.util.StoreManageUtil;
import com.ejianc.business.zdsstore.vo.FlowVO;
import com.ejianc.business.zdsstore.vo.StoreManageVO;
import com.ejianc.business.zdsstore.vo.SurplusVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="disposeService")
public class DisposeServiceImpl
extends BaseServiceImpl<DisposeMapper, DisposeEntity>
implements IDisposeService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BILL_CODE = "ZDS_MATERIAL_DISPOSE";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IStoreManageApi storeManageApi;
    @Autowired
    private IStoreFlowApi storeFlowApi;
    @Autowired
    private DisposeMapper mapper;
    @Autowired
    private IOrgApi orgApi;

    @Override
    public DisposeVO saveOrUpdate(DisposeVO saveOrUpdateVO) {
        CommonResponse orgResp;
        Boolean flag = false;
        Boolean required = false;
        for (DisposeDetailVO e : saveOrUpdateVO.getDisposeDetailList()) {
            if ("del".equals(e.getRowState())) continue;
            flag = true;
            if (e.getBrandId() != null) continue;
            required = true;
        }
        if (!flag.booleanValue()) {
            throw new BusinessException("\u6750\u6599\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        this.validateStoreNum(saveOrUpdateVO);
        DisposeEntity entity = (DisposeEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, DisposeEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setBillCode((String)billCode.getData());
            entity.setRecMnyFlag("0");
        }
        if (entity.getCreateUserId() == null) {
            entity.setCreateUserId(InvocationInfoProxy.getUserid());
        }
        if (!(orgResp = this.orgApi.findParentsByOrgId(entity.getParentOrgId())).isSuccess() || CollectionUtils.isEmpty((Collection)((Collection)orgResp.getData()))) {
            this.logger.error("\u6839\u636e\u7ec4\u7ec7id-{}\u67e5\u8be2\u5176\u4e0a\u7ea7\u7ec4\u7ec7\u4fe1\u606f\u5217\u8868\u5931\u8d25, ", (Object)entity.getParentOrgId(), (Object)JSONObject.toJSONString((Object)orgResp));
            throw new BusinessException("\u64cd\u4f5c\u5931\u8d25\uff0c\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        Long secOrgId = null;
        HashMap<Long, OrgVO> orgMap = new HashMap<Long, OrgVO>();
        for (OrgVO org : (List)orgResp.getData()) {
            orgMap.put(org.getId(), org);
            if (!org.getId().equals(entity.getParentOrgId())) continue;
            String[] orgIdsArr = org.getInnerCode().split("\\|");
            secOrgId = orgIdsArr.length >= 2 ? Long.valueOf(orgIdsArr[1]) : Long.valueOf(orgIdsArr[0]);
        }
        if (null != secOrgId && orgMap.containsKey(secOrgId)) {
            entity.setSecOrgCode(((OrgVO)orgMap.get(secOrgId)).getCode());
            entity.setSecOrgId(((OrgVO)orgMap.get(secOrgId)).getId());
            entity.setSecOrgName(((OrgVO)orgMap.get(secOrgId)).getName());
        } else {
            this.logger.error("\u83b7\u53d6\u7ec4\u7ec7id-{}\u5bf9\u5e94\u4e8c\u7ea7\u5355\u4f4d\u4fe1\u606f\u4e3a\u7a7a\uff01", (Object)entity.getParentOrgId());
        }
        super.saveOrUpdate((Object)entity, false);
        return this.queryDetail(entity.getId());
    }

    @Override
    public String del(List<Long> ids) {
        super.removeByIds(ids, true);
        return "\u5220\u9664\u6210\u529f\uff01";
    }

    @Override
    public Boolean inOutStore(DisposeEntity entity, Boolean outEffectiveON) {
        Map<Long, List<DisposeDetailEntity>> map = entity.getDisposeDetailList().stream().filter(x -> x.getStoreId() != null).collect(Collectors.groupingBy(DisposeDetailEntity::getStoreId));
        if (map.values().stream().flatMap(Collection::stream).count() == 0L) {
            return true;
        }
        for (Long storeId : map.keySet()) {
            StoreManageVO storeManageVO = new StoreManageVO();
            storeManageVO.setStoreId(storeId);
            storeManageVO.setSourceId(entity.getId());
            storeManageVO.setInOutTypeEnum(InOutTypeEnum.\u6750\u6599\u5904\u7f6e);
            storeManageVO.setOutEffectiveON(outEffectiveON);
            ArrayList<FlowVO> flowVOS = new ArrayList<FlowVO>();
            for (DisposeDetailEntity t : map.get(storeId)) {
                FlowVO flowVO = StoreManageUtil.getFlowVO((InOutTypeEnum)InOutTypeEnum.\u6750\u6599\u5904\u7f6e, (Integer)0);
                flowVO.setStoreId(t.getStoreId());
                flowVO.setStoreName(t.getStoreName());
                flowVO.setProjectId(entity.getProjectId());
                flowVO.setProjectName(entity.getProjectName());
                flowVO.setOrgId(entity.getOrgId());
                flowVO.setOrgName(entity.getOrgName());
                flowVO.setParentOrgId(entity.getParentOrgId());
                flowVO.setParentOrgName(entity.getParentOrgName());
                flowVO.setParentOrgCode(entity.getParentOrgCode());
                flowVO.setEmployeeId(entity.getEmployeeId());
                flowVO.setEmployeeName(entity.getEmployeeName());
                flowVO.setMaterialCategoryId(t.getMaterialTypeId());
                flowVO.setMaterialCategoryName(t.getMaterialTypeName());
                flowVO.setMaterialCategoryCode(t.getMaterialTypeCode());
                flowVO.setMaterialId(t.getMaterialId());
                flowVO.setMaterialCode(t.getMaterialCode());
                flowVO.setMaterialName(t.getMaterialName());
                flowVO.setMaterialSpec(t.getPropertyValue());
                flowVO.setBrandId(t.getBrandId());
                flowVO.setBrandName(t.getBrandName());
                flowVO.setProductCode(t.getProductCode());
                flowVO.setMaterialUnitId(t.getUnitId());
                flowVO.setMaterialUnitName(t.getUnitName());
                flowVO.setSourceBillDetailRemark(t.getMemo());
                flowVO.setTaxRate(t.getTaxRate());
                flowVO.setTaxPrice(t.getTaxPrice());
                flowVO.setPrice(t.getPrice());
                flowVO.setNum(t.getNum());
                BigDecimal taxMny = t.getTaxMny();
                BigDecimal mny = t.getMny();
                BigDecimal tax = ComputeUtil.safeSub((BigDecimal)t.getTaxMny(), (BigDecimal)t.getMny());
                if (t.getActualTaxMny() != null) {
                    taxMny = t.getActualTaxMny();
                    mny = t.getActualMny();
                    tax = ComputeUtil.safeSub((BigDecimal)t.getActualTaxMny(), (BigDecimal)t.getActualMny());
                }
                flowVO.setTaxMny(taxMny);
                flowVO.setMny(mny);
                flowVO.setTax(tax);
                flowVO.setSourceId(entity.getId());
                flowVO.setSourceDetailId(t.getId());
                flowVO.setSourceBillCode(entity.getBillCode());
                flowVO.setSourceBillDate(entity.getBillDate());
                flowVO.setRowState(t.getRowState());
                flowVO.setSourceBillTypeCode("EJCBT202312000012");
                flowVO.setSourceBillTypeName("\u5904\u7f6e\u7533\u8bf7");
                flowVO.setSourceType(Integer.valueOf(0));
                flowVO.setSourceBillRemark(entity.getMemo());
                flowVOS.add(flowVO);
            }
            storeManageVO.setFlowVOList(flowVOS);
            this.logger.info("\u8c03\u7528\u5e93\u5b58\u53c2\u6570\uff1a\u2014\u2014\u2014\u2014" + JSONObject.toJSONString((Object)storeManageVO));
            CommonResponse response = this.storeManageApi.inOutStore(storeManageVO);
            if (response.isSuccess()) continue;
            throw new BusinessException("\u8c03\u7528\u5e93\u5b58\u7ba1\u7406\u5931\u8d25,\u9519\u8bef\u4fe1\u606f\uff1a" + response.getMsg());
        }
        return true;
    }

    @Override
    public Boolean inOutStoreRollback(DisposeEntity entity, Boolean outEffectiveON) {
        Map<Long, List<DisposeDetailEntity>> map = entity.getDisposeDetailList().stream().filter(x -> x.getStoreId() != null).collect(Collectors.groupingBy(DisposeDetailEntity::getStoreId));
        for (Long storeId : map.keySet()) {
            StoreManageVO storeManageVO = new StoreManageVO();
            storeManageVO.setStoreId(storeId);
            storeManageVO.setSourceIdsForRollBack(new ArrayList<Long>(Arrays.asList(entity.getId())));
            storeManageVO.setInOutTypeEnum(InOutTypeEnum.\u6750\u6599\u5904\u7f6e);
            storeManageVO.setOutEffectiveON(outEffectiveON);
            this.logger.info("\u8c03\u7528\u5e93\u5b58\u53c2\u6570\uff1a\u2014\u2014\u2014\u2014" + JSONObject.toJSONString((Object)storeManageVO));
            CommonResponse response = this.storeManageApi.inOutStoreRollback(storeManageVO);
            if (response.isSuccess()) continue;
            throw new BusinessException("\u8c03\u7528\u5e93\u5b58\u7ba1\u7406\u5931\u8d25,\u9519\u8bef\u4fe1\u606f\uff1a" + response.getMsg());
        }
        return true;
    }

    @Override
    public DisposeVO queryDetail(Long id) {
        DisposeEntity entity = (DisposeEntity)((Object)super.selectById((Serializable)id));
        DisposeVO vo = (DisposeVO)BeanMapper.map((Object)((Object)entity), DisposeVO.class);
        if (BillStateEnum.COMMITED_STATE.equals((Object)entity.getBillState()) || BillStateEnum.PASSED_STATE.equals((Object)entity.getBillState())) {
            return vo;
        }
        Map<String, SurplusVO> storeMap = this.getStoreMap(vo);
        List detailList = vo.getDisposeDetailList();
        for (DisposeDetailVO detail : detailList) {
            String key = detail.getMaterialId() + "-" + detail.getBrandId();
            if (storeMap.containsKey(key)) {
                detail.setSurplusNum(storeMap.get(key).getSurplusNum());
            } else {
                detail.setSurplusNum(BigDecimal.ZERO);
            }
            detail.setSurplusNum(ComputeUtil.safeAdd((BigDecimal)detail.getSurplusNum(), (BigDecimal)detail.getNum()));
        }
        return vo;
    }

    @Override
    public Boolean validateStoreNum(DisposeVO vo) {
        Map<String, SurplusVO> storeMap = this.getStoreMap(vo);
        List detailList = vo.getDisposeDetailList();
        for (DisposeDetailVO detail : detailList) {
            String key = detail.getMaterialId() + "-" + detail.getBrandId();
            if (!storeMap.containsKey(key)) continue;
            detail.setSurplusNum(storeMap.get(key).getSurplusNum());
            if (vo.getId() != null) {
                detail.setSurplusNum(ComputeUtil.safeAdd((BigDecimal)detail.getSurplusNum(), (BigDecimal)detail.getNum()));
            }
            if (!ComputeUtil.isLessThan((BigDecimal)detail.getSurplusNum(), (BigDecimal)detail.getNum())) continue;
            throw new BusinessException("\u3010" + detail.getMaterialCode() + "\u3011\u672c\u6b21\u5904\u7f6e\u7533\u8bf7\u6570\u91cf\u5c0f\u4e8e\u5269\u4f59\u53ef\u5904\u7f6e\u6570\u91cf\uff0c\u4e0d\u5141\u8bb8\u5904\u7f6e");
        }
        return true;
    }

    @Override
    public int pageCount(Map<String, Object> queryParam) {
        return this.mapper.pageCount(queryParam);
    }

    @Override
    public List<JSONObject> pageList(Map<String, Object> queryParam) {
        return this.mapper.pageList(queryParam);
    }

    @Override
    public List<DisposeEntity> getAllByIds(List<Long> ids) {
        QueryWrapper query = new QueryWrapper();
        query.in((Object)"id", ids);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        return super.list((Wrapper)query);
    }

    private Map<String, SurplusVO> getStoreMap(DisposeVO vo) {
        Map<Long, List<DisposeDetailVO>> map = vo.getDisposeDetailList().stream().filter(x -> x.getStoreId() != null).collect(Collectors.groupingBy(DisposeDetailVO::getStoreId));
        HashMap<String, SurplusVO> storeMap = new HashMap<String, SurplusVO>();
        if (map.values().stream().flatMap(Collection::stream).count() == 0L) {
            return storeMap;
        }
        for (Long storeId : map.keySet()) {
            ArrayList<SurplusVO> vos = new ArrayList<SurplusVO>();
            for (DisposeDetailVO t : map.get(storeId)) {
                SurplusVO surplusVO = new SurplusVO();
                surplusVO.setStoreId(t.getStoreId());
                surplusVO.setMaterialCategoryId(t.getMaterialTypeId());
                surplusVO.setMaterialId(t.getMaterialId());
                surplusVO.setBrandId(t.getBrandId());
                vos.add(surplusVO);
            }
            this.logger.info("\u8c03\u7528\u5e93\u5b58\u53c2\u6570\uff1a\u2014\u2014\u2014\u2014" + JSONObject.toJSONString(vos));
            CommonResponse response = this.storeFlowApi.getNewSurplusNum(vos);
            if (!response.isSuccess() || CollectionUtils.isEmpty((Collection)((Collection)response.getData()))) continue;
            Map<String, SurplusVO> priceMap = ((List)response.getData()).stream().collect(Collectors.toMap(k -> k.getMaterialId() + "-" + k.getBrandId(), k -> k));
            storeMap.putAll(priceMap);
        }
        return storeMap;
    }
}

