package com.ejianc.business.zdsmaterial.material.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import io.swagger.annotations.ApiModelProperty;

import java.util.ArrayList;
import java.util.List;

/**
 * 材料分类属性
 * 
 * @author generator
 * 
 */
 @TableName("ejc_material_category_property")
public class MaterialCategoryPropertyEntity extends BaseEntity {

    private static final long serialVersionUID = -5349330514153316056L;

    @ApiModelProperty("编码")
    @TableField(value="code")
    private String code;
    @ApiModelProperty("名称")
    @TableField(value="name")
    private String name;
    @ApiModelProperty("序号")
    @TableField(value="sequence")
    private Integer sequence;
    @ApiModelProperty("所属材料分类Id")
    @TableField(value="category_id")
    private Long categoryId;
    @ApiModelProperty("来源系统Id")
    @TableField(value="system_id")
    private String systemId;
    @ApiModelProperty("来源业务Id")
    @TableField(value="source_id")
    private String sourceId;
    @ApiModelProperty("属性分类停启用")
    @TableField(value = "enabled")
    private Integer enabled;

    @TableField(exist = false)
    @ApiModelProperty("属性可选列表")
    private List<MaterialCategoryPropertySubItemEntity> itemList = new ArrayList<>();

    @ApiModelProperty("产品代码停启用：0-停用，1-启用，默认停用")
    @TableField(value = "product_code_flag")
    private Integer productCodeFlag;

    @ApiModelProperty("是否必选：0-否，1是")
    @TableField(value = "required_flag")
    private Integer requiredFlag;

    @TableField(value = "key_property_flag")
    @ApiModelProperty("是否关键属性：0-否，1-是。物料档案准入时，关键属性不允许调整")
    private Integer keyPropertyFlag;

    @TableField(exist = false)
    private String oldName;
    @TableField(exist = false)
    private Integer oldSequence;
    @TableField(exist = false)
    private Integer oldEnabled;
    @TableField(exist = false)
    private Integer oldProductCodeFlag;

    public Integer getRequiredFlag() {
        return requiredFlag;
    }

    public void setRequiredFlag(Integer requiredFlag) {
        this.requiredFlag = requiredFlag;
    }

    public Integer getKeyPropertyFlag() {
        return keyPropertyFlag;
    }

    public void setKeyPropertyFlag(Integer keyPropertyFlag) {
        this.keyPropertyFlag = keyPropertyFlag;
    }

    public Integer getProductCodeFlag() {
        return productCodeFlag;
    }

    public void setProductCodeFlag(Integer productCodeFlag) {
        this.productCodeFlag = productCodeFlag;
    }

    public Integer getOldProductCodeFlag() {
        return oldProductCodeFlag;
    }

    public void setOldProductCodeFlag(Integer oldProductCodeFlag) {
        this.oldProductCodeFlag = oldProductCodeFlag;
    }

    public Integer getOldEnabled() {
        return oldEnabled;
    }

    public void setOldEnabled(Integer oldEnabled) {
        this.oldEnabled = oldEnabled;
    }

    public String getOldName() {
        return oldName;
    }

    public void setOldName(String oldName) {
        this.oldName = oldName;
    }

    public Integer getOldSequence() {
        return oldSequence;
    }

    public void setOldSequence(Integer oldSequence) {
        this.oldSequence = oldSequence;
    }

    public Integer getEnabled() {
        return enabled;
    }

    public void setEnabled(Integer enabled) {
        this.enabled = enabled;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public Integer getSequence() {
        return sequence;
    }

    public void setSequence(Integer sequence) {
        this.sequence = sequence;
    }
    public Long getCategoryId() {
        return categoryId;
    }

    public void setCategoryId(Long categoryId) {
        this.categoryId = categoryId;
    }
    public String getSystemId() {
        return systemId;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }
    public String getSourceId() {
        return sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public List<MaterialCategoryPropertySubItemEntity> getItemList() {
        return itemList;
    }

    public void setItemList(List<MaterialCategoryPropertySubItemEntity> itemList) {
        this.itemList = itemList;
    }
 }
