package com.ejianc.business.zdsmaterial.sub.settle.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ejianc.business.zdsmaterial.sub.settle.bean.SubSettleFileEntity;
import com.ejianc.business.zdsmaterial.sub.settle.service.ISubSettleFileService;
import com.ejianc.business.zdsmaterial.sub.settle.service.ISubSettleService;
import com.ejianc.business.zdssupplier.sub.api.ISubSupplierApi;
import com.ejianc.business.zdssupplier.sub.vo.SupplierVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 分包结算 供ERP数据查询服务
 *
 * @author CJ
 * @Description:
 * @date 2024/5/20 11:40
 */
@RestController
@RequestMapping(value = "/subSettle/erp")
public class SubSettleErpController {

    Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ISubSettleService subSettleService;

    @Autowired
    private ISubSettleFileService subSettleFileService;

    @Autowired
    private IProjectPoolApi projectPoolApi;

    @Autowired
    private IEmployeeApi employeeApi;

    @Autowired
    private IAttachmentApi attachmentApi;

    @Autowired
    private ISubSupplierApi subSupplierApi;

    @Value("${common.env.base-host}")
    private String BASE_HOST;

    @PostMapping(value = "postPageList")
    public CommonResponse<JSONObject> postPageList(@RequestBody JSONObject param) {
        logger.info("ERP查询分包结算参数：{}", JSONObject.toJSONString(param, SerializerFeature.PrettyFormat));
        Integer pageSize = null != param && null != param.getInteger("PageSize") ? param.getInteger("PageSize") : 10;
        Integer pageNum = null != param && null != param.getInteger("PageNum") ? param.getInteger("PageNum") : 1;
        String BeginDateTime = null != param && null != param.getString("BeginDateTime") ? param.getString("BeginDateTime") : null;
        String EndDateTime = null != param && null != param.getString("EndDateTime") ? param.getString("EndDateTime") : null;

        return pageSyncList(pageSize, pageNum, BeginDateTime, EndDateTime);
    }

    @GetMapping(value = "/pageList")
    public CommonResponse<JSONObject> pageSyncList(@RequestParam(required = false) Integer PageSize,
                                                   @RequestParam(required = false) Integer PageNum,
                                                   @RequestParam(required = false) String BeginDateTime,
                                                   @RequestParam(required = false) String EndDateTime) {
        JSONObject resp = new JSONObject();

        Integer pageSize = null != PageSize ? PageSize : 10;
        Integer pageNum = null != PageNum ? PageNum : 1;
        Map<String, Object> queryParam = new HashMap<>();
        if(StringUtils.isNotBlank(BeginDateTime)) {
            queryParam.put("beginDateTime", BeginDateTime);
        }
        if(StringUtils.isNotBlank(EndDateTime)) {
            queryParam.put("endDateTime", EndDateTime);
        }

        int count = subSettleService.pageCount(queryParam);
        resp.put("total", count);
        resp.put("pageSize", pageSize);
        resp.put("pageNum", pageNum);

        if(count == 0) {
            resp.put("records", new ArrayList<>());
            return CommonResponse.success("查询成功！", resp);
        }

        Integer startLine = pageNum - 1 < 0 ? pageSize : (pageNum - 1) * pageSize;
        queryParam.put("startLine", startLine);
        queryParam.put("pageSize", pageSize);

        List<JSONObject> pageList = subSettleService.pageList(queryParam);
        List<Long> projectIds = new ArrayList<>();
        List<Long> settleIds = new ArrayList<>();
        List<Long> supplierIds = new ArrayList<>();
        List<String> empCodes = new ArrayList<>();
        pageList.stream().forEach(item -> {
            if(!projectIds.contains(item.getLong("projectId"))) {
                projectIds.add(item.getLong("projectId"));
            }
            if(!settleIds.contains(item.getLong("YQL_SID"))) {
                settleIds.add(item.getLong("YQL_SID"));
            }
            if(!supplierIds.contains(item.getLong("supplierId"))) {
                supplierIds.add(item.getLong("supplierId"));
            }
            if(StringUtils.isNotBlank(item.getString("EngineerCode")) && !empCodes.contains(item.getString("EngineerCode"))) {
                empCodes.add(item.getString("EngineerCode"));
            }
            if(StringUtils.isNotBlank(item.getString("ApprHumanCode")) && !empCodes.contains(item.getString("ApprHumanCode"))) {
                empCodes.add(item.getString("ApprHumanCode"));
            }
        });

        //查询项目信息
        CommonResponse<JSONArray> projectResp = projectPoolApi.queryProjectByIds(projectIds);
        if(!projectResp.isSuccess()) {
            logger.error("分包结算查询失败，根据项目Id列表-{}查询项目信息失败，{}", JSONObject.toJSONString(projectIds),
                    JSONObject.toJSONString(projectResp, SerializerFeature.PrettyFormat));
            return CommonResponse.error("查询失败，获取项目信息失败！");
        }

        Map<Long, String> projectSidMap = new HashMap<>();
        List<ProjectPoolSetVO> projectList = JSONArray.parseArray(JSONObject.toJSONString(projectResp.getData()), ProjectPoolSetVO.class);
        if(CollectionUtils.isNotEmpty(projectList)) {
            projectSidMap.putAll(projectList.stream().collect(Collectors.toMap(ProjectPoolSetVO::getId, ProjectPoolSetVO::getSourceId)));
        }

        //查询供应商信息
        Map<Long, SupplierVO> supplierMap = new HashMap<>();
        CommonResponse<List<SupplierVO>> supplierResp = subSupplierApi.getAllByIds(supplierIds);
        if(!supplierResp.isSuccess()) {
            logger.error("分包结算查询失败，根据供应商列表-{}查询人员信息失败，{}", JSONObject.toJSONString(supplierIds),
                    JSONObject.toJSONString(supplierResp, SerializerFeature.PrettyFormat));
            return CommonResponse.error("查询失败，获取供应商信息失败！");
        }
        supplierMap.putAll(supplierResp.getData().stream().collect(Collectors.toMap(SupplierVO::getId, Function.identity())));

        //查询人员信息
        Map<String, EmployeeVO> empMap = new HashMap<>();
        CommonResponse<List<EmployeeVO>> empResp = employeeApi.getAllByEmployeeCodes(empCodes);
        if(!empResp.isSuccess()) {
            logger.error("分包结算查询失败，根据人员工号列表-{}查询人员信息失败，{}", JSONObject.toJSONString(empCodes),
                    JSONObject.toJSONString(empResp, SerializerFeature.PrettyFormat));
            return CommonResponse.error("查询失败，获取人员信息失败！");
        }
        List<EmployeeVO> empList = empResp.getData();
        if(CollectionUtils.isNotEmpty(empList)) {
            empMap.putAll(empList.stream().collect(Collectors.toMap(EmployeeVO::getCode, Function.identity())));
        }

        //查询子表信息
        Map<Long, List<SubSettleFileEntity>> subFilesMap = subSettleFileService.getAllBySettleIds(settleIds);
        List<Long> subFileIds = subFilesMap.values().stream().flatMap(List::stream).map(SubSettleFileEntity::getAttachmentId).collect(Collectors.toList());

        //查询字表附件信息
//        JSONObject params = new JSONObject();
//        params.put("fileIds", subFileIds);
        CommonResponse<List<AttachmentVO>> attachResp = attachmentApi.queryAllByIds(subFileIds);

        if(!attachResp.isSuccess()) {
            logger.error("根据sourceId列表-{}查询对应附件信息失败，", JSONObject.toJSONString(subFileIds),
                    JSONObject.toJSONString(attachResp, SerializerFeature.PrettyFormat));
            return CommonResponse.error("查询失败，获取子表附件信息失败！");
        }

        List<AttachmentVO> fileData = attachResp.getData();
        Map<Long, AttachmentVO> fileMap = new HashMap<>();
        for (AttachmentVO vo: fileData){
            fileMap.put(vo.getId(), vo);
        }

        EmployeeVO emp = null;
        ProjectPoolSetVO project = null;
        SupplierVO supplier = null;
        AttachmentVO attach = null;
        for(JSONObject settle : pageList) {
            //获取工程师信息
            emp = empMap.get(settle.getString("EngineerCode"));
            settle.put("Engineer_Sid", emp.getSourceId());
            settle.put("Engineer", emp.getName());
            //获取审核人信息
            emp = empMap.get(settle.getString("ApprHumanCode"));
            settle.put("ApprHuman_sid", emp.getSourceId());
            settle.put("ApprHuman", emp.getName());
            //获取项目信息
            settle.put("Account_Project_Sid", projectSidMap.get(settle.getLong("projectId")));
            settle.remove("projectId");
            //供应商信息
            supplier = supplierMap.get(settle.getLong("supplierId"));
            settle.put("Company_Sid", supplier.getThirdSourceId());
            settle.put("Company_Name", supplier.getName());
            settle.remove("supplierId");

            //子表信息
            JSONArray subFileArr = new JSONArray();
            settle.put("ArchivesList", subFileArr);
            if(null != subFilesMap.get(settle.getLong("YQL_SID"))) {
                JSONObject subF = null;
                for(SubSettleFileEntity ssf : subFilesMap.get(settle.getLong("YQL_SID"))) {
                    subF = new JSONObject();
                    attach = fileMap.get(ssf.getAttachmentId());
                    if(null != attach) {
                        subF.put("Attach_Type", attach.getFileName().substring(attach.getFileName().indexOf(".")+1)); //附件类型
                        subF.put("Attach_Name", ssf.getAttachmentName() + (ssf.getAttachmentName().indexOf(".") < 0 ? attach.getFileName().substring(attach.getFileName().indexOf(".")) : "")); //附件名称
                        subF.put("Attach_Extension", attach.getFileName().substring(attach.getFileName().indexOf("."))); //附件扩展名
                        subF.put("AttachBase64", BASE_HOST + "filepreview/" + attach.getFilePath()); //附件类型
                        subF.put("YQL_SID", ssf.getId()); //益企联主
                        subFileArr.add(subF);
                    } else if(StringUtils.isNotBlank(ssf.getSourceFilePath()) && StringUtils.isNotBlank(ssf.getAttachmentName())) {
                        subF.put("Attach_Type", attach.getFileName().substring(ssf.getAttachmentName().indexOf(".")+1)); //附件类型
                        subF.put("Attach_Name", ssf.getAttachmentName() + (ssf.getAttachmentName().indexOf(".") < 0 ? ssf.getAttachmentName().substring(ssf.getAttachmentName().indexOf(".")) : "")); //附件名称
                        subF.put("Attach_Extension", ssf.getAttachmentName().substring(ssf.getAttachmentName().indexOf("."))); //附件扩展名
                        subF.put("AttachBase64", ssf.getSourceFilePath()); //附件类型
                        subF.put("YQL_SID", ssf.getId()); //益企联主
                        subFileArr.add(subF);
                    }
                }
            }
        }

        resp.put("records", pageList);

        return CommonResponse.success("查询成功！", resp);
    }

}
