package com.ejianc.business.zdsmaterial.sub.invoice.service.impl;

import cn.hutool.json.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.zdsmaterial.cons.PlanConstant;
import com.ejianc.business.zdsmaterial.erp.bean.ErpInvoiceEntity;
import com.ejianc.business.zdsmaterial.erp.service.IErpInvoiceService;
import com.ejianc.business.zdsmaterial.sub.invoice.bean.SubInvoiceDetailEntity;
import com.ejianc.business.zdsmaterial.sub.invoice.bean.SubInvoiceEntity;
import com.ejianc.business.zdsmaterial.sub.invoice.service.ISubInvoiceDetailService;
import com.ejianc.business.zdsmaterial.sub.invoice.service.ISubInvoiceService;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;

@Service("subInvoice")
public class SubInvoiceBpmServiceImpl implements ICommonBusinessService {

    @Autowired
    private IBillTypeApi billTypeApi;
   	@Autowired
	private ISubInvoiceService subInvoiceService;
   	@Autowired
	private ISubInvoiceDetailService subInvoiceDetailService;
	@Autowired
	private IErpInvoiceService erpInvoiceService;

	@Autowired
	private IProjectPoolApi projectPoolApi;

	@Autowired
	private IEmployeeApi employeeApi;

	@Autowired
	private SessionManager sessionManager;

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	/**
	 * 提交前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		return checkInvoiceState(billId);
	}

	private CommonResponse<String> checkInvoiceState(Long billId) {
		SubInvoiceEntity entity = subInvoiceService.selectById(billId);

		if(PlanConstant.SOURCE_TYPE_SUPPLIER.equals(entity.getSourceType())) {

			QueryWrapper<SubInvoiceEntity> query = new QueryWrapper<>();
			query.eq("source_id", entity.getSourceId());
			query.eq("sign_state", PlanConstant.CHECK_STATE_FINISH);
			query.ne("id", entity.getId());
			query.in("bill_state", new Integer[]{
					BillStateEnum.COMMITED_STATE.getBillStateCode(),
					BillStateEnum.APPROVING_HAS_STATE.getBillStateCode(),
					BillStateEnum.PASSED_STATE.getBillStateCode(),
					BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode(),
			});
			List<SubInvoiceEntity> dbList = subInvoiceService.list(query);
			if(CollectionUtils.isNotEmpty(dbList)) {
				logger.error("分包发票登记单据-{}id-{}确认操作失败，存在重复发票号且审核中/已审核的单据【ids-{}】", entity.getId(),
						StringUtils.join(dbList.stream().map(SubInvoiceEntity::getId).collect(Collectors.toSet()), ","));
				throw new BusinessException("操作失败，存在发票号相同且已提交审核的单据【"+StringUtils.join(dbList.stream().map(SubInvoiceEntity::getBillCode).collect(Collectors.toSet()), ",")+"】");
			}
		}

		if (CollectionUtils.isNotEmpty(entity.getDetailList())) {

			List<String> numbers = new ArrayList<>(entity.getDetailList().stream().filter(item -> StringUtils.isNotBlank(item.getInvoiceNumber())).map(SubInvoiceDetailEntity::getInvoiceNumber).collect(Collectors.toSet()));
			Set<String> quoteNumberList = new HashSet<>();
			//查询发票
			if(CollectionUtils.isNotEmpty(numbers)) {
				List<ErpInvoiceEntity> list = erpInvoiceService.getAllByInvoiceNums(numbers);
				logger.info("分包: 根据发票号：{}, EL查询到发票数：{}", JSONObject.toJSONString(numbers), list.size());
				for(ErpInvoiceEntity e : list) {
					logger.info("分包发票id-{},number-{}, ERP引用标识：{}", e.getId(), e.getNumber(), e.getErpQuoteFlag());
					if(PlanConstant.STRING_YES.equals(e.getErpQuoteFlag())) {
						quoteNumberList.add(e.getNumber());
					}
				}
				if (CollectionUtils.isNotEmpty(quoteNumberList)) {
					return CommonResponse.error("操作失败，号码为[" + quoteNumberList.stream().collect(Collectors.joining(",")) + "]的发票已被引用");
				}
			}

			List<String> invIdList = entity.getDetailList().stream().map(SubInvoiceDetailEntity::getErpId).collect(Collectors.toList());
			LambdaQueryWrapper<ErpInvoiceEntity> queryWrapper = new LambdaQueryWrapper<>();
			queryWrapper.in(ErpInvoiceEntity::getSourceId, invIdList);
			List<ErpInvoiceEntity> invoiceEntities = erpInvoiceService.list(queryWrapper);

			Set<String> rightSet = new HashSet<>();
			Set<String> errSet = new HashSet<>();
			Set<String> errNumSet = new HashSet<>();
			if (CollectionUtils.isNotEmpty(invoiceEntities)) {
				for (ErpInvoiceEntity invoiceEntity : invoiceEntities) {
					if ("0".equals(invoiceEntity.getStatusCode())) {
						rightSet.add(invoiceEntity.getSourceId());
					}else {
						errSet.add(invoiceEntity.getSourceId());
						errNumSet.add(invoiceEntity.getNumber());
					}
				}
			}
			for (String id : invIdList) {
				if (!rightSet.contains(id)) {
					errSet.add(id);
				}
			}

			//根据项目查询项目主管会计
			CommonResponse<ProjectPoolSetVO> projectResp = projectPoolApi.getById(entity.getProjectId());
			if(!projectResp.isSuccess()) {
				logger.error("根据项目Id-{}获取项目信息失败：{}", entity.getProjectId(), JSONObject.toJSONString(projectResp));
				return CommonResponse.error("操作失败，获取所属项目信息失败！");
			}
			ProjectPoolSetVO project = projectResp.getData();
			if(null == project.getChiefAccountantId()) {
				return CommonResponse.error("项目【"+entity.getProjectName()+"】未查询到对应主管会计信息！");
			}

			CommonResponse<EmployeeVO> empResp = employeeApi.getById(project.getChiefAccountantId());
			if(!empResp.isSuccess()) {
				logger.error("根据人员Id-{}获取人员信息失败：{}", project.getChiefAccountantId(), JSONObject.toJSONString(empResp));
				return CommonResponse.error("操作失败，获取项目主管会计人员信息失败！");
			}
			EmployeeVO emp = empResp.getData();
			if(null == emp) {
				return CommonResponse.error("操作失败，未查询到项目对应的主管会计信息！");
			}

			LambdaUpdateWrapper<SubInvoiceEntity> mainUpdate = new LambdaUpdateWrapper<>();
			mainUpdate.eq(SubInvoiceEntity::getId, entity.getId());
			mainUpdate.set(SubInvoiceEntity::getChiefAccountantId, emp.getId());
			mainUpdate.set(SubInvoiceEntity::getChiefAccountantName, emp.getName());
			subInvoiceService.update(mainUpdate);

			if (CollectionUtils.isNotEmpty(rightSet)) {
				LambdaUpdateWrapper<SubInvoiceDetailEntity> update = new LambdaUpdateWrapper<>();
				update.in(SubInvoiceDetailEntity::getErpId, new ArrayList<>(rightSet));
				update.set(SubInvoiceDetailEntity::getInvoiceState, "正常");
				subInvoiceDetailService.update(update);
			}
			if (CollectionUtils.isNotEmpty(errSet)) {
				LambdaUpdateWrapper<SubInvoiceDetailEntity> update = new LambdaUpdateWrapper<>();
				update.in(SubInvoiceDetailEntity::getErpId, new ArrayList<>(errSet));
				update.set(SubInvoiceDetailEntity::getInvoiceState, "异常");
				subInvoiceDetailService.update(update);
				return CommonResponse.error("号码为["+StringUtils.join(errNumSet,",")+"]的发票状态不是正常状态，无法启动流程！");
			}
		}
		return CommonResponse.success();
	}

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){

		SubInvoiceEntity e = subInvoiceService.selectById(billId);
		UserContext user = sessionManager.getUserContext();
		e.setCommitDate(new Date());
		e.setCommitUserCode(user.getUserCode());
		e.setCommitUserCode(user.getUserName());

		subInvoiceService.saveOrUpdate(e, false);

		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		SubInvoiceEntity e = subInvoiceService.selectById(billId);
		//驳回时把申请状态改为待审核
		LambdaUpdateWrapper<SubInvoiceEntity> updateWrapper = new LambdaUpdateWrapper<>();
		updateWrapper.eq(SubInvoiceEntity::getId, Long.valueOf(billId));
		if(PlanConstant.SOURCE_TYPE_SUPPLIER.equals(e.getSourceType())) {
			updateWrapper.set(SubInvoiceEntity::getSignState, PlanConstant.CHECK_STATE_UN);
		}

		updateWrapper.set(SubInvoiceEntity::getCommitDate, null);
		updateWrapper.set(SubInvoiceEntity::getCommitUserCode, null);
		updateWrapper.set(SubInvoiceEntity::getCommitUserName, null);
		updateWrapper.set(SubInvoiceEntity::getFinalApproveUserId, null);
		updateWrapper.set(SubInvoiceEntity::getFinalApproveUserName, null);
		updateWrapper.set(SubInvoiceEntity::getFinalApproveUserCode, null);
		subInvoiceService.update(updateWrapper);
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		if (BillStateEnum.UNCOMMITED_STATE.getBillStateCode().equals(state)) {
			return checkInvoiceState(billId);
		}
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		SubInvoiceEntity e = subInvoiceService.selectById(billId);
		UserContext user = sessionManager.getUserContext();
		if(BillStateEnum.COMMITED_STATE.getBillStateCode().equals(state)) {
			e.setCommitDate(new Date());
			e.setCommitUserCode(user.getUserCode());
			e.setCommitUserCode(user.getUserName());
		}
		e.setEffectiveDate(new Date());
		e.setFinalApproveUserId(user.getUserId());
		e.setFinalApproveUserName(user.getUserName());
		e.setFinalApproveUserCode(user.getUserCode());

		subInvoiceService.saveOrUpdate(e, false);

		//推送发票登记至ERP
		subInvoiceService.syncToErp(billId, user.getUserId());

		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		// 参数是单据类型编码字符串 根据需求是否打开下面代码
        /**CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
        if(!resp.isSuccess()){
            return CommonResponse.error("无法撤回！"+resp.getMsg());
        }*/
		return CommonResponse.success();
	}

	@Override
	public CommonResponse<JSONArray> queryApproveUser(Long billId, String billTypeCode, String sign, Map<String, Object> other) {
		SubInvoiceEntity entity = subInvoiceService.selectById(billId);
		//根据项目查询项目主管会计
		CommonResponse<ProjectPoolSetVO> projectResp = projectPoolApi.getById(entity.getProjectId());
		if(!projectResp.isSuccess()) {
			logger.error("根据项目Id-{}获取项目信息失败：{}", entity.getProjectId(), JSONObject.toJSONString(projectResp));
			return CommonResponse.error("操作失败，获取所属项目信息失败！");
		}
		ProjectPoolSetVO project = projectResp.getData();
		if(null == project.getChiefAccountantId()) {
			return CommonResponse.error("项目【"+entity.getProjectName()+"】未查询到对应主管会计信息！");
		}

		JSONArray resp = new JSONArray();
		CommonResponse<EmployeeVO> empResp = employeeApi.getById(project.getChiefAccountantId());
		if(!empResp.isSuccess()) {
			logger.error("根据人员Id-{}获取人员信息失败：{}", project.getChiefAccountantId(), JSONObject.toJSONString(empResp));
			return CommonResponse.error("操作失败，获取项目主管会计人员信息失败！");
		}
		EmployeeVO emp = empResp.getData();

		JSONObject obj = new JSONObject();
		obj.put("userId", emp.getId());
		obj.put("userName", emp.getName());
		resp.add(obj);

		return CommonResponse.success("查询成功", resp);
	}
}
