/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.erp.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.zdsmaterial.asynchandler.QueueUtils;
import com.ejianc.business.zdsmaterial.erp.bean.MessageInfoEntity;
import com.ejianc.business.zdsmaterial.erp.mapper.MessageInfoMapper;
import com.ejianc.business.zdsmaterial.erp.service.IMessageInfoService;
import com.ejianc.business.zdsmaterial.erp.vo.MessageInfoVO;
import com.ejianc.business.zdsmaterial.sub.settle.utils.HttpTookit;
import com.ejianc.business.zdsmaterial.util.ZDSInterfaceCommonUtil;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.EnvironmentTools;
import com.ejianc.framework.skeleton.refer.util.ReferObjectUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.Serializable;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import jodd.util.StringUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="messageInfoService")
public class MessageInfoServiceImpl
extends BaseServiceImpl<MessageInfoMapper, MessageInfoEntity>
implements IMessageInfoService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${zds.erp.reqHost:http://192.168.201.55:8001}")
    private String reqHost;
    @Autowired
    private IUserApi usersApi;
    @Autowired
    private EnvironmentTools environmentTools;
    private Gson gson = new GsonBuilder().disableHtmlEscaping().create();
    @Value(value="${zds.erp.appId:859f0363d7dcc01cc4275a6cad2a0001}")
    private String appId;
    @Value(value="${zds.erp.secret:11658934fd26400985e1e9d83f6ac7cf}")
    private String secret;
    @Autowired
    private QueueUtils queueUtils;
    @Value(value="${spring.cloud.config.profile}")
    private String profile;
    private final String THIRD_TODO_PAGE = "ejc-bpm-frontend/#/thirdTodo";
    @Value(value="${thirdTask.warnUserIds:303581417601122400}")
    private String warnUserIds;
    @Autowired
    private IPushMessageApi pushMessageApi;
    @Value(value="${common.env.base-host}")
    private String BASE_HOST;

    @Override
    public void reviewSendMessage(Long id) {
        MessageInfoEntity entity = (MessageInfoEntity)((Object)super.selectById((Serializable)id));
        if (null == entity) {
            throw new BusinessException("\u8bf7\u4f20\u5165\u6b63\u786e\u7684\u6d88\u606fid");
        }
        MessageInfoVO vo = (MessageInfoVO)BeanMapper.map((Object)((Object)entity), MessageInfoVO.class);
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{vo.getUserId(), vo.getProcessState(), vo.getProcessStateCode()}) || null == vo.getBillId()) {
            throw new BusinessException("\u5fc5\u586b\u6570\u636e\u4e3a\u7a7a");
        }
        this.sendTodoMessage(Arrays.asList(vo.getUserId().split(",")), vo.getBillId().toString(), vo.getBillTypeCode(), vo.getTitle(), vo.getStartUserId(), vo.getFormUrl(), vo.getMaUrl(), vo.getProcessState(), vo.getProcessStateCode(), vo.getTaskName(), vo.getIdea(), vo.getIdeaCode(), id);
    }

    @Override
    public String thirdTaskReSend(List<Long> ids) {
        List<MessageInfoEntity> todoList = this.getUnHandleList(ids);
        String serverUrl = this.reqHost + "/cefoc/yql/getTaskTicket";
        Integer sucNum = 0;
        Integer failNum = 0;
        for (MessageInfoEntity messageInfoVO : todoList) {
            try {
                Integer n;
                Integer n2;
                this.logger.info("*******\u5f85\u529e/\u5df2\u529e\u6d88\u606fid-{}\u91cd\u53d1*******", (Object)messageInfoVO.getId());
                if (StringUtils.isBlank((CharSequence)messageInfoVO.getParam())) {
                    this.logger.info("******\u6ce8\u610f*****\u5f85\u529e/\u5df2\u529e\u6d88\u606fid-{}\u53c2\u6570\u4e3a\u7a7a\uff0c\u91cd\u53d1\u8df3\u8fc7****\u6ce8\u610f***", (Object)messageInfoVO.getId());
                    continue;
                }
                String paramterStr = this.gson.toJson((Object)messageInfoVO.getParam());
                Map<String, String> header = this.getErpHeaders();
                String resultResp = HttpTookit.postByJson(serverUrl, paramterStr, header);
                this.logger.info("\u53d1\u9001\u4ee3\u529e/\u5df2\u529eid-{}\u8c03\u7528ERP\u63a5\u53e3\u8c03\u7528\u6210\u529f\uff0c\u8fd4\u56de\u7ed3\u679c\uff1a{}\uff01\uff01\uff01++++++++++++", (Object)messageInfoVO.getId(), (Object)resultResp);
                if (resultResp.contains("\u5904\u7406\u5931\u8d25:0\u6761")) {
                    messageInfoVO.setSuccessFlag("1");
                    messageInfoVO.setMessage(resultResp);
                    messageInfoVO.setState(null);
                    n2 = sucNum;
                    n = sucNum = Integer.valueOf(sucNum + 1);
                } else {
                    messageInfoVO.setSuccessFlag("0");
                    messageInfoVO.setMessage(resultResp);
                    messageInfoVO.setState("\u672a\u5904\u7406");
                    n2 = failNum;
                    n = failNum = Integer.valueOf(failNum + 1);
                }
                this.queueUtils.sendMq("push_erp_message_info_" + this.profile, JSONObject.toJSONString((Object)((Object)messageInfoVO)));
            }
            catch (Exception e) {
                messageInfoVO.setSuccessFlag("0");
                messageInfoVO.setMessage("\u6d88\u606f\u63a8\u9001EPR\u5f02\u5e38");
                messageInfoVO.setState("\u672a\u5904\u7406");
                this.queueUtils.sendMq("push_erp_message_info_" + this.profile, JSONObject.toJSONString((Object)((Object)messageInfoVO)));
                Integer n = failNum;
                Integer n3 = failNum = Integer.valueOf(failNum + 1);
            }
        }
        if (sucNum > 0) {
            return "\u64cd\u4f5c\u6210\u529f\uff0c\u6210\u529f\u53d1\u9001\u4e8b\u9879\uff1a" + sucNum + (failNum == 0 ? "\u6761\uff01" : "\u6761\uff0c\u5931\u8d25\uff1a" + failNum + "\u6761");
        }
        return "\u64cd\u4f5c\u5931\u8d25\uff0c\u4e8b\u9879\u91cd\u65b0\u63a8\u9001ERP,ERP\u5904\u7406\u5931\u8d25\uff01";
    }

    @Override
    public void scanThirdFailTask() {
        this.logger.info("********************************\u7b2c\u4e09\u65b9\u5931\u8d25\u4ee3\u529e\u9884\u8b66\u4efb\u52a1  START ********************************");
        List<MessageInfoEntity> toHandleList = this.getUnHandleList(null);
        this.logger.info("\u67e5\u8be2\u5230\u5f85\u9884\u8b66 \u7b2c\u4e09\u65b9\u4ee3\u529e\u6570\u636e\uff1a{}\u6761", (Object)toHandleList.size());
        if (CollectionUtils.isEmpty(toHandleList)) {
            this.logger.info("\u67e5\u8be2\u5230\u5f85\u9884\u8b66 \u7b2c\u4e09\u65b9\u4ee3\u529e\u6570\u636e\u4e3a\u7a7a\uff0c\u9884\u8b66\u4efb\u52a1\u6267\u884c\u7ed3\u675f END ********************************", (Object)toHandleList.size());
            return;
        }
        this.sendWarn(toHandleList);
        this.logger.info("********************************\u7b2c\u4e09\u65b9\u5931\u8d25\u4ee3\u529e\u9884\u8b66\u4efb\u52a1  END ********************************");
    }

    private void sendWarn(List<MessageInfoEntity> toHandleList) {
        this.sendWarnMsg("ERP\u5904\u7406\u5931\u8d25\u4ee3\u529e\u3001\u5df2\u529e\u6d88\u606f\u9884\u8b66", "\u3010\u4ee3\u529e\u3001\u5df2\u529e\u6d88\u606fERP\u5904\u7406\u5931\u8d25\u9884\u8b66\u3011\uff1a\u3010" + DateFormatUtil.formatDate((String)"yyyy-MM-dd HH:mm:ss", (Date)new Date()) + "\u3011\u68c0\u6d4b\u5230\u6709\u3010" + toHandleList.size() + "\u3011\u6761\u4ee3\u529e\u3001\u5df2\u529e\u4efb\u52a1\u63a8\u9001ERP\u5931\u8d25\uff0c\u8bf7\u5c3d\u5feb\u5904\u7406\uff01", this.BASE_HOST + "ejc-bpm-frontend/#/thirdTodo");
    }

    @Override
    public boolean sendWarnMsg(String title, String content, String pcUrl) {
        try {
            PushMsgParameter parameter = new PushMsgParameter();
            parameter.setSubject(title);
            parameter.setContent(content);
            parameter.setPcUrl(pcUrl);
            parameter.setMobileUrl(pcUrl);
            String[] recIds = this.warnUserIds.split(",");
            parameter.setReceivers(recIds);
            parameter.setSaveFlag(true);
            parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
            parameter.setMsgType("notice");
            parameter.setChannel(new String[]{"sys", "email"});
            CommonResponse sendResp = this.pushMessageApi.pushMessage(parameter);
            if (!sendResp.isSuccess()) {
                this.logger.error("\u53d1\u9001\u4ee3\u529e\u3001\u5df2\u529e\u9884\u8b66\u6d88\u606f\u5931\u8d25\uff0c\u6d88\u606f-{}\uff0c\u53d1\u9001\u6d88\u606f\u7ed3\u679c-{}", (Object)JSONObject.toJSONString((Object)parameter), (Object)JSONObject.toJSONString((Object)sendResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
                return false;
            }
            this.logger.info("\u53d1\u9001\u4ee3\u529e\u3001\u5df2\u529e\u9884\u8b66\u6d88\u606f\u6210\u529f\uff01");
            return true;
        }
        catch (Exception e) {
            this.logger.error("\u53d1\u9001\u4ee3\u529e\u3001\u5df2\u529e\u9884\u8b66\u6d88\u606f\u5f02\u5e38\uff01\uff01\uff01", (Throwable)e);
            return false;
        }
    }

    private List<MessageInfoEntity> getUnHandleList(List<Long> ids) {
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        query.eq((Object)"success_flag", (Object)"0");
        if (CollectionUtils.isNotEmpty(ids)) {
            query.in((Object)"id", ids);
        }
        return super.list((Wrapper)query);
    }

    @Override
    public void sendTodo(List<String> userId, String billId, String billTypeCode, String title, String startUserId, String formUrl, String maUrl, String processState, String processStateCode, String taskName, String idea, String ideaCode) {
        this.sendTodoMessage(userId, billId, billTypeCode, title, startUserId, formUrl, maUrl, processState, processStateCode, taskName, idea, ideaCode, null);
    }

    public void sendTodoMessage(List<String> userId, String billId, String billTypeCode, String title, String startUserId, String formUrl, String maUrl, String processState, String processStateCode, String taskName, String idea, String ideaCode, Long id) {
        if (userId == null || userId.size() == 0) {
            this.logger.info("\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a--------");
            throw new BusinessException("\u53d1\u9001\u4ee3\u529e\u5df2\u529e\u6d88\u606f\u5931\u8d25\uff0c\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a");
        }
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{billId, processState, processStateCode})) {
            throw new BusinessException("\u53d1\u9001\u4ee3\u529e\u5df2\u529e\u6d88\u606f\u5931\u8d25\uff0c\u5fc5\u586b\u53c2\u6570\u3010billId,processState,processStateCode\u3011\u4e3a\u7a7a");
        }
        MessageInfoVO messageInfoVO = new MessageInfoVO();
        if (null == id) {
            messageInfoVO.setBillId(Long.valueOf(billId));
            messageInfoVO.setBillTypeCode(billTypeCode);
            messageInfoVO.setUserId(StringUtil.join(userId, (char)','));
            messageInfoVO.setTitle(title);
            messageInfoVO.setStartUserId(startUserId);
            messageInfoVO.setFormUrl(formUrl);
            messageInfoVO.setMaUrl(maUrl);
            messageInfoVO.setProcessState(processState);
            messageInfoVO.setProcessStateCode(processStateCode);
            messageInfoVO.setTaskName(taskName);
            messageInfoVO.setId(Long.valueOf(IdWorker.getId()));
        } else {
            messageInfoVO = (MessageInfoVO)BeanMapper.map((Object)super.selectById((Serializable)id), MessageInfoVO.class);
        }
        try {
            CommonResponse userBack;
            this.logger.info("\u8c03\u7528\u4e2d\u7535\u56dbERP \u63a5\u53e3\uff1a\u53d1\u9001\u6d88\u606f\u63a5\u53e3start------------------");
            String serverUrl = this.reqHost + "/cefoc/yql/getTaskTicket";
            String[] userIds = new String[userId.size()];
            JSONObject json = this.getUser(startUserId);
            String startUserCode = startUserId;
            String startUserName = startUserId;
            if (json != null) {
                startUserCode = json.get((Object)"code").toString();
                startUserName = json.get((Object)"name").toString();
            }
            JSONArray data = new JSONArray();
            if (StringUtils.isNotBlank((CharSequence)formUrl)) {
                formUrl = URLEncoder.encode(formUrl, "utf-8");
            }
            if ((userBack = this.usersApi.queryListByIds(userId.toArray(userIds))).isSuccess()) {
                if (userBack.getData() != null && ((List)userBack.getData()).size() > 0) {
                    List userList = (List)userBack.getData();
                    SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    HashSet<Long> userIdSet = new HashSet<Long>();
                    HashSet<String> userCodeSet = new HashSet<String>();
                    HashSet<String> userNameSet = new HashSet<String>();
                    if ("0".equals(processStateCode)) {
                        for (UserVO userVO : userList) {
                            String modelId = ZDSInterfaceCommonUtil.changeLongToGUID(messageInfoVO.getId());
                            this.logger.info("\u53d1\u9001\u4ee3\u529e\uff1a" + userVO.getUserName() + "-----------" + modelId);
                            String ApprovalURL = maUrl + "&userid=" + userVO.getId();
                            String jumpUrl = this.environmentTools.getBaseHost() + "portal/sso/index?usercode=" + userVO.getUserCode() + "&targeturl=" + formUrl;
                            JSONObject param = new JSONObject();
                            param.put("YQLTaskTicketOID", (Object)modelId);
                            param.put("InstanceID", (Object)modelId);
                            param.put("BusiField", (Object)title);
                            param.put("ProcessState", (Object)processState);
                            param.put("ProcessStateCode", (Object)processStateCode);
                            param.put("ActivityChineseName", (Object)taskName);
                            param.put("Sys_Created", (Object)DateFormatUtil.formatDate((String)"yyyy-MM-dd HH:mm:ss", (Date)new Date()));
                            param.put("Sys_LAST_UPD", (Object)DateFormatUtil.formatDate((String)"yyyy-MM-dd HH:mm:ss", (Date)new Date()));
                            param.put("PersonName", (Object)userVO.getUserName());
                            param.put("PersonOID", (Object)userVO.getSourceId());
                            param.put("WorkCode", (Object)userVO.getUserCode());
                            param.put("ApprovalURL", (Object)ApprovalURL);
                            param.put("WebApprovalURL", (Object)jumpUrl);
                            param.put("OriginatorName", (Object)(StringUtils.isNotBlank((CharSequence)startUserName) ? startUserName : userVO.getUserName()));
                            param.put("OriginatorCode", (Object)(StringUtils.isNotBlank((CharSequence)startUserCode) ? startUserCode : userVO.getUserCode()));
                            param.put("OriginatorTime", (Object)DateFormatUtil.formatDate((String)"yyyy-MM-dd HH:mm:ss", (Date)new Date()));
                            param.put("Idea", (Object)"");
                            param.put("IdeaCode", (Object)"0");
                            param.put("SYS_Deleted", (Object)0);
                            param.put("YQL_SID", (Object)modelId);
                            data.add((Object)param);
                            userIdSet.add(userVO.getId());
                            userCodeSet.add(userVO.getUserCode());
                            userNameSet.add(userVO.getUserName());
                        }
                        messageInfoVO.setUserId(StringUtil.join(userIdSet, (char)','));
                        messageInfoVO.setUserCode(StringUtil.join(userCodeSet, (char)','));
                        messageInfoVO.setUserName(StringUtil.join(userNameSet, (char)','));
                    } else {
                        LambdaQueryWrapper qw = Wrappers.lambdaQuery();
                        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)qw.eq(MessageInfoEntity::getBillId, (Object)billId)).eq(BaseEntity::getDr, (Object)0)).orderByDesc(BaseEntity::getCreateTime)).last("limit 1");
                        MessageInfoEntity entity = (MessageInfoEntity)((Object)super.getOne((Wrapper)qw));
                        messageInfoVO = (MessageInfoVO)BeanMapper.map((Object)((Object)entity), MessageInfoVO.class);
                        if (null == messageInfoVO) {
                            this.logger.info("\u6839\u636ebillId\uff1a{}\u83b7\u53d6\u4ee3\u529e\u4fe1\u606f\u5931\u8d25", (Object)billId);
                            messageInfoVO.setSuccessFlag("0");
                            messageInfoVO.setMessage("\u6839\u636ebillId\uff1a" + billId + "\u83b7\u53d6\u4ee3\u529e\u4fe1\u606f\u5931\u8d25");
                            messageInfoVO.setState("\u672a\u5904\u7406");
                            this.queueUtils.sendMq("push_erp_message_info_" + this.profile, JSONObject.toJSONString((Object)messageInfoVO));
                        } else {
                            String param = messageInfoVO.getParam();
                            data = JSONObject.parseArray((String)param);
                            for (Object o : data) {
                                JSONObject map = (JSONObject)JSONObject.toJSON(o);
                                map.put("ProcessState", (Object)"\u5df2\u529e");
                                map.put("ProcessStateCode", (Object)"1");
                                map.put("Sys_LAST_UPD", (Object)DateFormatUtil.formatDate((String)"yyyy-MM-dd HH:mm:ss", (Date)new Date()));
                                map.put("Idea", (Object)idea);
                                map.put("IdeaCode", (Object)ideaCode);
                            }
                        }
                    }
                    messageInfoVO.setParam(JSONObject.toJSONString((Object)data));
                } else {
                    this.logger.info("\u6839\u636eid\uff1a{}\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff0c\u672a\u67e5\u8be2\u5230\u8be5\u7528\u6237\u6570\u636e", (Object)userId.toString());
                    messageInfoVO.setSuccessFlag("0");
                    messageInfoVO.setMessage("\u6839\u636eid\uff1a" + userId.toString() + "\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff0c\u672a\u67e5\u8be2\u5230\u8be5\u7528\u6237\u6570\u636e");
                    messageInfoVO.setState("\u672a\u5904\u7406");
                    this.queueUtils.sendMq("push_erp_message_info_" + this.profile, JSONObject.toJSONString((Object)messageInfoVO));
                }
            } else {
                this.logger.info("\u6839\u636eid\uff1a{}\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff0c\u8c03\u7528\u63a5\u53e3userApi.queryListByIds\u5931\u8d25", (Object)userId.toString());
                messageInfoVO.setSuccessFlag("0");
                messageInfoVO.setMessage("\u6839\u636eid\uff1a" + userId.toString() + "\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff0c\u8c03\u7528\u63a5\u53e3userApi.queryListByIds\u5931\u8d25");
                messageInfoVO.setState("\u672a\u5904\u7406");
                this.queueUtils.sendMq("push_erp_message_info_" + this.profile, JSONObject.toJSONString((Object)messageInfoVO));
            }
            if (data != null && data.size() > 0) {
                this.logger.info("\u53d1\u9001\u7528\u6237{}\u4f20\u9012\u7684\u53c2\u6570\uff1a{}---------------", (Object)("0".equals(processStateCode) ? "\u4ee3\u529e" : "\u5df2\u529e"), (Object)data.toJSONString());
                String paramterStr = this.gson.toJson((Object)data);
                Map<String, String> header = this.getErpHeaders();
                String resultResp = HttpTookit.postByJson(serverUrl, paramterStr, header);
                this.logger.info("billId-{},\u53d1\u9001\u4ee3\u529e/\u5df2\u529e\u8c03\u7528ERP\u63a5\u53e3\u8c03\u7528\u6210\u529f\uff0c\u8fd4\u56de\u7ed3\u679c\uff1a{}\uff01\uff01\uff01++++++++++++", (Object)billId, (Object)resultResp);
                if (resultResp.contains("\u5904\u7406\u5931\u8d25:0\u6761")) {
                    messageInfoVO.setSuccessFlag("1");
                    messageInfoVO.setMessage(resultResp);
                    messageInfoVO.setState(null);
                } else {
                    messageInfoVO.setSuccessFlag("0");
                    messageInfoVO.setMessage(resultResp);
                    messageInfoVO.setState("\u672a\u5904\u7406");
                }
                this.queueUtils.sendMq("push_erp_message_info_" + this.profile, JSONObject.toJSONString((Object)messageInfoVO));
            }
            this.logger.info("\u8c03\u7528\u4e2d\u7535\u56dbERP \u63a5\u53e3\uff1a\u53d1\u9001\u6d88\u606f\u63a5\u53e3end------------------");
        }
        catch (Exception e) {
            this.logger.info("\u8c03\u7528\u4e2d\u7535\u56dbERP \u63a5\u53e3\uff1a\u53d1\u9001\u4ee3\u529e/\u5df2\u529e\u6d88\u606f\u5f02\u5e38\uff1a", (Throwable)e);
            messageInfoVO.setSuccessFlag("0");
            messageInfoVO.setMessage("\u8c03\u7528\u4e2d\u7535\u56dbERP \u63a5\u53e3\uff1a\u53d1\u9001\u6d88\u606f\u63a5\u53e3\u5931\u8d25\uff01");
            messageInfoVO.setState("\u672a\u5904\u7406");
            this.queueUtils.sendMq("push_erp_message_info_" + this.profile, JSONObject.toJSONString((Object)messageInfoVO));
        }
    }

    public JSONObject getUser(String userId) {
        try {
            JSONArray jArray;
            if (userId != null && (jArray = ReferObjectUtil.getReferEntityValue((String)userId, (String)"idm-user")) != null && jArray.size() > 0) {
                JSONObject json = (JSONObject)jArray.get(0);
                return json;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public Map<String, String> getErpHeaders() throws Exception {
        HashMap<String, String> headers = new HashMap<String, String>();
        String nowStr = DateFormatUtil.formatDate((String)"yyyy-MM-dd HH:mm:ss", (Date)new Date());
        this.logger.info("-------------appId:{},secret:{}", (Object)this.appId, (Object)this.secret);
        headers.put("appid", this.toMD5(this.appId));
        headers.put("ticket", nowStr);
        headers.put("sign", this.toMD5(this.secret + this.toMD5(this.appId) + this.toMD5(nowStr)));
        return headers;
    }

    public String toMD5(String plainText) throws Exception {
        MessageDigest digest = MessageDigest.getInstance("MD5");
        byte[] hashBytes = digest.digest(plainText.getBytes());
        StringBuilder sb = new StringBuilder();
        for (byte b : hashBytes) {
            sb.append(Integer.toString((b & 0xFF) + 256, 16).substring(1));
        }
        return sb.toString().toLowerCase();
    }

    public static void main(String[] args) {
        MessageInfoVO vo = new MessageInfoVO();
        vo.setParam("[{\"BusiField\":\"\u5f85\u529e\u6d4b\u8bd511\",\"Sys_LAST_UPD\":1737539451259,\"PersonName\":\"\u7530\u521a\u521a\",\"InstanceID\":\"123-100351000-1778837995772710913-7038\",\"Sys_Created\":1737539451259,\"OriginatorTime\":1737539451259,\"ProcessStateCode\":\"0\",\"OriginatorName\":\"\u738b\u8d22\",\"WebApprovalURL\":\"https://testscmm.cefoc.cn/portal/sso/index?usercode=100351000&targeturl=url\",\"YQLTaskTicketOID\":\"123-100351000-1778837995772710913-7038\",\"ApprovalURL\":\"url&userid=1778837995772710913\",\"OriginatorCode\":\"13253636467\",\"ProcessState\":\"\u5f85\u529e\",\"IdeaCode\":\"0\",\"Idea\":\"\",\"SYS_Deleted\":0,\"WorkCode\":\"100351000\",\"PersonOID\":\"000078a6-0000-0000-0000-000060f6d999\",\"ActivityChineseName\":\"\u5206\u5305\",\"YQL_SID\":\"123-100351000-1778837995772710913-7038\"}]");
        JSONArray array = JSONObject.parseArray((String)vo.getParam());
        for (Object o : array) {
            JSONObject map = (JSONObject)JSONObject.toJSON(o);
            map.put("ProcessState", (Object)"\u5df2\u529e");
            map.put("ProcessStateCode", (Object)"1");
        }
        System.out.println(array);
    }
}

