/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.material.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ejianc.business.zdsmaterial.material.bean.MatFeeApplyDetailEntity;
import com.ejianc.business.zdsmaterial.material.bean.MatFeeApplyEntity;
import com.ejianc.business.zdsmaterial.material.bean.MatFeeApplyFileDetailEntity;
import com.ejianc.business.zdsmaterial.material.mapper.MatFeeApplyMapper;
import com.ejianc.business.zdsmaterial.material.service.IMatFeeApplyService;
import com.ejianc.business.zdsmaterial.material.vo.MatFeeApplyVO;
import com.ejianc.business.zdsmaterial.sub.subvisa.enums.InstructionStatusEnum;
import com.ejianc.business.zdsmaterial.util.PushFileUtil;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Service(value="matFeeApplyService")
public class MatFeeApplyServiceImpl
extends BaseServiceImpl<MatFeeApplyMapper, MatFeeApplyEntity>
implements IMatFeeApplyService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BILL_CODE = "MAT-FEE-CODE";
    private final String OPERATE = "matFeeApplyBill";
    private static final String BILL_TYPE_CODE = "EJCBT202403000028";
    @Value(value="${common.env.base-host}")
    private String BASE_HOST;
    private final String BILL_PUSH_PM_SERVER_URL = "/ejc-zdssupbusiness-web/openapi/matFeeApply/syncBill";
    @Autowired
    private JedisPool jedisPool;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    @Autowired
    private IPushMessageApi pushMessageApi;
    @Autowired
    private MatFeeApplyMapper mapper;
    @Autowired
    private PushFileUtil pushFileUtil;
    @Autowired
    private IEmployeeApi employeeApi;

    @Override
    public CommonResponse<String> syncBill(HttpServletRequest request) {
        String authority = request.getHeader("authority");
        String transData = request.getParameter("transData");
        String nameSourceTypeMapping = request.getParameter("nameSourceTypeMapping");
        Map mp = (Map)JSONObject.parseObject((String)nameSourceTypeMapping, Map.class);
        this.logger.info("\u63a5\u6536\u5230\u63a8\u9001\u5206\u5305\u7b7e\u7ae0\u5355\u636e: {}, \u5f53\u524d\u4e0a\u4e0b\u6587: {}", (Object)transData, (Object)authority);
        if (StringUtils.isBlank((CharSequence)transData)) {
            return CommonResponse.error((String)"\u5355\u636e\u540c\u6b65\u5931\u8d25\uff0c\u5355\u636e\u5185\u5bb9\u4e3a\u7a7a\uff01");
        }
        MatFeeApplyEntity entity = (MatFeeApplyEntity)((Object)JSONObject.parseObject((String)transData, MatFeeApplyEntity.class));
        long id = IdWorker.getId();
        entity.setSourceId(entity.getId());
        entity.setId(id);
        entity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        entity.setReceiveStatus(InstructionStatusEnum.\u5f85\u5ba1\u6838.getStatus());
        entity.setTenantId(InvocationInfoProxy.getTenantid());
        entity.setVersion(null);
        entity.setCreateUserCode(null);
        entity.setUpdateUserCode(null);
        EmployeeVO craetor = null;
        if (null != entity.getPurchaseWorkerId()) {
            CommonResponse creatorResp = this.employeeApi.getById(entity.getPurchaseWorkerId());
            if (!creatorResp.isSuccess()) {
                this.logger.error("\u67e5\u8be2\u5408\u540c\u5f55\u5165\u4eba-{}\u4fe1\u606f\u5931\u8d25,{}", (Object)entity.getPurchaseWorkerId(), (Object)JSONObject.toJSONString((Object)creatorResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
                return CommonResponse.error((String)"\u64cd\u4f5c\u5931\u8d25,\u67e5\u8be2\u91c7\u8d2d\u5de5\u7a0b\u5e08\u4fe1\u606f\u5931\u8d25!");
            }
            if (null == creatorResp.getData()) {
                this.logger.error("\u67e5\u8be2\u5408\u540c\u5f55\u5165\u4eba-{}\u4fe1\u606f\u4e3a\u7a7a,{}", (Object)entity.getPurchaseWorkerId(), (Object)JSONObject.toJSONString((Object)creatorResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
                return CommonResponse.error((String)"\u64cd\u4f5c\u5931\u8d25,\u67e5\u8be2\u91c7\u8d2d\u5de5\u7a0b\u5e08\u4fe1\u606f\u5931\u8d25!");
            }
            craetor = (EmployeeVO)creatorResp.getData();
        }
        for (MatFeeApplyFileDetailEntity matFeeApplyFileDetailEntity : entity.getFileList()) {
            matFeeApplyFileDetailEntity.setId(IdWorker.getId());
            matFeeApplyFileDetailEntity.setCreateTime(null);
            matFeeApplyFileDetailEntity.setUpdateTime(null);
            matFeeApplyFileDetailEntity.setTenantId(InvocationInfoProxy.getTenantid());
            matFeeApplyFileDetailEntity.setUpdateUserCode(null);
            matFeeApplyFileDetailEntity.setCreateUserCode(craetor.getCode());
            matFeeApplyFileDetailEntity.setVersion(null);
            Long fileId = this.pushFileUtil.uploadFileFormNet(BILL_TYPE_CODE, matFeeApplyFileDetailEntity.getId(), "file01", matFeeApplyFileDetailEntity.getAttachmentId());
            matFeeApplyFileDetailEntity.setAttachmentId(fileId);
        }
        for (MatFeeApplyDetailEntity matFeeApplyDetailEntity : entity.getDetailList()) {
            matFeeApplyDetailEntity.setId(IdWorker.getId());
            matFeeApplyDetailEntity.setCreateTime(null);
            matFeeApplyDetailEntity.setUpdateTime(null);
            matFeeApplyDetailEntity.setTenantId(InvocationInfoProxy.getTenantid());
            matFeeApplyDetailEntity.setUpdateUserCode(null);
            matFeeApplyDetailEntity.setCreateUserCode(craetor.getCode());
            matFeeApplyDetailEntity.setVersion(null);
        }
        entity.setCreateUserCode(craetor.getCode());
        this.logger.info("\u63a5\u6536\u5230\u63a8\u9001\u5206\u5305\u7b7e\u7ae0\u8f6c\u6362\u4fdd\u5b58\u5355\u636e: {}", (Object)JSONObject.toJSONString((Object)((Object)entity)));
        super.saveOrUpdate((Object)entity, false);
        this.logger.info("\u91c7\u8d2d\u8d39\u7528\u7533\u8bf7\u5411\u91c7\u8d2d\u5de5\u7a0b\u5e08\uff08\u5408\u540c\u5f55\u5165\u4eba\uff09id-{}\u53d1\u9001\u6d88\u606f", (Object)entity.getPurchaseWorkerId().toString());
        PushMsgParameter parameter = new PushMsgParameter();
        parameter.setSubject("\u3010\u91c7\u8d2d\u8d39\u7528\u7533\u8bf7\u3011\uff1a\u3010" + entity.getBillCode() + "\u3011\uff0c\u3010" + DateFormatUtil.formatDate((String)"yyyy-MM-dd HH:mm:ss", (Date)new Date()) + "\u3011\u9700\u8981\u60a8\u5ba1\u6838\uff01");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\u3010").append(entity.getBillCode()).append("\u3011\uff0c\u3010").append(entity.getProjectName()).append("\u3011\uff0c\u3010").append(entity.getContractName()).append("\u3011\uff0c\u3010").append(entity.getSupplierName()).append("\u3011\u63d0\u4ea4\u4e86\u8d39\u7528\u7533\u8bf7\uff0c\u8bf7\u60a8\u5ba1\u6838\uff01");
        parameter.setContent(stringBuilder.toString());
        parameter.setPcUrl(this.BASE_HOST + "ejc-zdsmaterial-frontend/#/purCostApply/card?id=" + entity.getId().toString());
        String[] recIds = new String[]{entity.getPurchaseWorkerId().toString()};
        parameter.setReceivers(recIds);
        this.sendMsg(parameter, entity.getId(), "\u91c7\u8d2d\u8d39\u7528\u7533\u8bf7\u5411\u91c7\u8d2d\u5de5\u7a0b\u5e08\u53d1\u9001\u6d88\u606f", "\u91c7\u8d2d\u8d39\u7528\u7533\u8bf7");
        return CommonResponse.success((String)"\u5355\u636e\u540c\u6b65\u6210\u529f\uff01");
    }

    public void sendMsg(PushMsgParameter parameter, Long billId, String oprMsg, String notice) {
        parameter.setSaveFlag(true);
        parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
        parameter.setMsgType(StringUtils.isNotBlank((CharSequence)notice) ? notice : "\u63d0\u9192");
        parameter.setChannel(new String[]{"sys", "email"});
        CommonResponse sendResp = this.pushMessageApi.pushMessage(parameter);
        if (!sendResp.isSuccess()) {
            this.logger.error("{}-\u53d1\u9001\u6d88\u606f\u5931\u8d25\uff0c\u5355\u636eId-{}\uff0c\u53d1\u9001\u6d88\u606f\u7ed3\u679c-{}", new Object[]{oprMsg, billId, JSONObject.toJSONString((Object)sendResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue})});
        } else {
            this.logger.info("{}-\u53d1\u9001\u6d88\u606f\u6210\u529f\uff01", (Object)oprMsg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String pushBill(MatFeeApplyEntity entity) {
        String msg = null;
        Jedis jedis = null;
        boolean locked = false;
        String key = "matFeeApplyBill::" + entity.getId().toString() + "::sup";
        try {
            jedis = this.jedisPool.getResource();
            locked = RedisTool.tryLock((Jedis)jedis, (String)key, (String)"matFeeApplyBill", (int)600);
            if (!locked) {
                this.releaseLock(jedis, false, key, "matFeeApplyBill");
                String string = "\u91c7\u8d2d\u5408\u540c\u7ed3\u7b97\u63a8\u9001\u4f9b\u5e94\u94fe\u5e73\u53f0\u5931\u8d25\uff0c\u52a0\u9501\u5931\u8d25\uff01";
                return string;
            }
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("transData", JSONObject.toJSONString((Object)((Object)entity)));
            this.logger.info("\u91c7\u8d2d\u5408\u540c\u7ed3\u7b97\u63a8\u9001\u4f9b\u5e94\u94fe\u5e73\u53f0: url-{}, \u91c7\u8d2d\u5408\u540c\u7ed3\u7b97\uff1a{}", (Object)"/ejc-zdssupbusiness-web/openapi/matFeeApply/syncBill", (Object)JSONObject.toJSONString((Object)((Object)entity)));
            CommonResponse writeBackResp = this.systemDataPushService.exchangeDataAndFilesWithEachLinkSystem("/ejc-zdssupbusiness-web/openapi/matFeeApply/syncBill", params, entity.getSupplierId().toString(), null);
            this.logger.error("\u91c7\u8d2d\u5408\u540c\u7ed3\u7b97\u63a8\u9001\u4f9b\u5e94\u94fe\u5e73\u53f0\u8bf7\u6c42\u7ed3\u679c\uff0c{}", (Object)JSONObject.toJSONString((Object)writeBackResp));
            if (!writeBackResp.isSuccess()) {
                this.releaseLock(jedis, true, key, "matFeeApplyBill");
                this.logger.error("\u91c7\u8d2d\u5408\u540c\u7ed3\u7b97id-{}\u63a8\u9001\u4f9b\u5e94\u94fe\u5e73\u53f0\u53d1\u9001\u8bf7\u6c42\u5931\u8d25\uff0c{}", (Object)entity.getId(), (Object)writeBackResp.getMsg());
                String string = "\u91c7\u8d2d\u5408\u540c\u7ed3\u7b97\u63a8\u9001\u4f9b\u5e94\u94fe\u5e73\u53f0\u5931\u8d25";
                return string;
            }
            String operateRespStr = (String)writeBackResp.getData();
            CommonResponse operateResp = (CommonResponse)JSONObject.parseObject((String)operateRespStr, CommonResponse.class);
            if (!operateResp.isSuccess()) {
                this.logger.error("\u91c7\u8d2d\u5408\u540c\u7ed3\u7b97id-{}\u63a8\u9001\u4f9b\u5e94\u94fe\uff0c\u5e73\u53f0\u5904\u7406\u5931\u8d25\uff0c{}", (Object)entity.getId(), (Object)operateResp.getMsg());
                this.releaseLock(jedis, true, key, "matFeeApplyBill");
                String string = "\u91c7\u8d2d\u5408\u540c\u7ed3\u7b97\u63a8\u9001\u4f9b\u5e94\u94fe\u5e73\u53f0\u5931\u8d25";
                return string;
            }
        }
        catch (Exception e) {
            this.logger.error("\u91c7\u8d2d\u5408\u540c\u7ed3\u7b97id-{}\u63a8\u9001\u4f9b\u5e94\u94fe\u5e73\u53f0\u5931\u8d25\uff0c", (Object)entity.getId(), (Object)e);
            msg = "\u64cd\u4f5c\u5931\u8d25\uff0c\u91c7\u8d2d\u5408\u540c\u7ed3\u7b97\u63a8\u9001\u4f9b\u5e94\u94fe\u5e73\u53f0\u5931\u8d25\uff01";
        }
        finally {
            this.releaseLock(jedis, locked, key, "matFeeApplyBill");
        }
        return msg;
    }

    @Override
    public int pageCount(Map<String, Object> queryParam) {
        return this.mapper.pageCount(queryParam);
    }

    @Override
    public List<JSONObject> pageList(Map<String, Object> queryParam) {
        return this.mapper.pageList(queryParam);
    }

    @Override
    public BigDecimal thisYearApplyMny(Long linkerId, String linkerSid, Long supplierId) {
        return this.mapper.thisYearApplyMny(linkerId, linkerSid, supplierId);
    }

    @Override
    public CommonResponse<MatFeeApplyVO> pushStatus(Long id) {
        MatFeeApplyEntity entity = (MatFeeApplyEntity)((Object)super.selectById((Serializable)id));
        entity.setReceiveStatus(InstructionStatusEnum.\u5df2\u9a73\u56de.getStatus());
        String s = this.pushBill(entity);
        if (StringUtils.isNotBlank((CharSequence)s)) {
            throw new BusinessException(s);
        }
        super.saveOrUpdate((Object)entity, false);
        MatFeeApplyVO instructionSetVO = (MatFeeApplyVO)BeanMapper.map((Object)((Object)entity), MatFeeApplyVO.class);
        return CommonResponse.success((String)"\u9a73\u56de\u6210\u529f\uff01", (Object)instructionSetVO);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseLock(Jedis jedis, boolean locked, String key, String OPERATE) {
        try {
            if (locked) {
                RedisTool.releaseLock((Jedis)jedis, (String)key, (String)OPERATE);
            }
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }
}

