/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.plan.control.controller;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdsmaterial.cons.PlanConstant;
import com.ejianc.business.zdsmaterial.erp.service.IOrderDetailService;
import com.ejianc.business.zdsmaterial.pick.service.ISubsetMaterialService;
import com.ejianc.business.zdsmaterial.plan.control.bean.ControlPlanSumEntity;
import com.ejianc.business.zdsmaterial.plan.control.service.IControlPlanService;
import com.ejianc.business.zdsmaterial.plan.control.service.IControlPlanSumService;
import com.ejianc.business.zdsmaterial.plan.control.vo.ControlPlanSumDetailVO;
import com.ejianc.business.zdsmaterial.plan.control.vo.ControlPlanSumVO;
import com.ejianc.business.zdsmaterial.plan.control.vo.ControlPlanVO;
import com.ejianc.business.zdsstore.api.IStoreFlowApi;
import com.ejianc.business.zdsstore.api.IStoreManageApi;
import com.ejianc.business.zdsstore.consts.InOutTypeEnum;
import com.ejianc.business.zdsstore.vo.FlowVO;
import com.ejianc.business.zdsstore.vo.SurplusVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"controlPlanSum"})
public class ControlPlanSumController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IControlPlanSumService service;
    @Autowired
    private IControlPlanService controlService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IOrderDetailService orderDetailService;
    @Autowired
    private IStoreFlowApi storeFlowApi;
    @Autowired
    private IStoreManageApi storeManageApi;
    @Autowired
    private ISubsetMaterialService subsetMaterialService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ControlPlanSumVO> saveOrUpdate(@RequestBody ControlPlanSumVO saveOrUpdateVO) {
        ControlPlanSumVO vo = this.service.saveOrUpdate(saveOrUpdateVO);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ControlPlanSumVO> queryDetail(Long id) {
        ControlPlanSumEntity entity = (ControlPlanSumEntity)((Object)this.service.selectById(id));
        ControlPlanSumVO vo = (ControlPlanSumVO)BeanMapper.map((Object)((Object)entity), ControlPlanSumVO.class);
        QueryParam param = new QueryParam();
        param.getParams().put("projectId", new Parameter("eq", (Object)entity.getProjectId()));
        List list = this.controlService.queryList(param);
        vo.setBillList(BeanMapper.mapList((Iterable)list, ControlPlanVO.class));
        List<Long> materialIds = vo.getDetailList().stream().map(ControlPlanSumDetailVO::getMaterialId).collect(Collectors.toList());
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("projectId", new Parameter("eq", (Object)entity.getProjectId()));
        queryParam.getParams().put("effectiveState", new Parameter("eq", (Object)1));
        queryParam.getParams().put("materialId", new Parameter("in", materialIds));
        CommonResponse flowResp = this.storeFlowApi.getFlowList(queryParam);
        HashMap<Long, List<FlowVO>> flowMaps = new HashMap<Long, List<FlowVO>>();
        if (flowResp.isSuccess()) {
            if (CollectionUtils.isNotEmpty((Collection)((Collection)flowResp.getData()))) {
                flowMaps.putAll(((List)flowResp.getData()).stream().collect(Collectors.groupingBy(FlowVO::getMaterialId)));
            }
        } else {
            this.logger.error("\u603b\u63a7\u8ba1\u5212\u6c47\u603b\u5b50\u8868\u5165\u5e93\u6570\u91cf\u67e5\u8be2\u5931\u8d25\uff0c\u53c2\u6570\uff1a{}, \u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)queryParam, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}), (Object)JSONObject.toJSONString((Object)flowResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
        }
        HashMap<Long, List<SurplusVO>> materialMap = new HashMap<Long, List<SurplusVO>>();
        ArrayList vos = new ArrayList();
        materialIds.stream().forEach(e -> {
            SurplusVO surplusVO = new SurplusVO();
            surplusVO.setMaterialId(e);
            surplusVO.setProjectId(entity.getProjectId());
            vos.add(surplusVO);
        });
        CommonResponse surplusResponse = this.storeManageApi.querySurplusBatch(vos);
        if (surplusResponse.isSuccess()) {
            if (CollectionUtils.isNotEmpty((Collection)((Collection)surplusResponse.getData()))) {
                materialMap.putAll(((List)surplusResponse.getData()).stream().collect(Collectors.groupingBy(e -> e.getMaterialId())));
            }
        } else {
            this.logger.error("\u603b\u63a7\u8ba1\u5212\u6c47\u603b\u5b50\u8868\u5e93\u5b58\u6570\u91cf\u67e5\u8be2\u5931\u8d25\uff0c\u53c2\u6570\uff1a{}, \u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString(vos, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}), (Object)JSONObject.toJSONString((Object)surplusResponse, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
        }
        if (CollectionUtils.isNotEmpty(materialIds)) {
            List<Map<String, Object>> orderNums = this.orderDetailService.getMaterialOrderNums(entity.getProjectId(), materialIds);
            Map<Long, Map> orderNumMap = orderNums.stream().collect(Collectors.toMap(m -> Long.valueOf(m.get("materialId").toString()), m -> m));
            vo.getDetailList().stream().forEach(detail -> {
                if (orderNumMap.containsKey(detail.getMaterialId())) {
                    detail.setPurchaseNum(new BigDecimal(((Map)orderNumMap.get(detail.getMaterialId())).get("orderNum").toString()));
                    detail.setDeliveryNum(new BigDecimal(((Map)orderNumMap.get(detail.getMaterialId())).get("deliveryNum").toString()));
                    detail.setAcceptNum(new BigDecimal(((Map)orderNumMap.get(detail.getMaterialId())).get("acceptNum").toString()));
                } else {
                    detail.setPurchaseNum(BigDecimal.ZERO);
                    detail.setDeliveryNum(BigDecimal.ZERO);
                    detail.setAcceptNum(BigDecimal.ZERO);
                }
                if (flowMaps.containsKey(detail.getMaterialId())) {
                    detail.setInStoreNum(((List)flowMaps.get(detail.getMaterialId())).stream().filter(item -> Integer.valueOf(1).equals(item.getInOutFlag())).map(e -> e.getNum()).reduce(BigDecimal.ZERO, ComputeUtil::safeAdd));
                    detail.setPickNum(((List)flowMaps.get(detail.getMaterialId())).stream().filter(item -> Integer.valueOf(2).equals(item.getInOutFlag()) && (InOutTypeEnum.\u9886\u6599\u51fa\u5e93.getInOutType().equals(item.getInOutType()) || InOutTypeEnum.\u76f4\u5165\u76f4\u51fa\u51fa\u5e93.getInOutType().equals(item.getInOutType()))).map(e -> e.getNum()).reduce(BigDecimal.ZERO, ComputeUtil::safeAdd));
                } else {
                    detail.setInStoreNum(BigDecimal.ZERO);
                    detail.setPickNum(BigDecimal.ZERO);
                }
                if (materialMap.containsKey(detail.getMaterialId())) {
                    detail.setSurplusNum(((List)materialMap.get(detail.getMaterialId())).stream().map(e -> e.getSurplusNum()).reduce(BigDecimal.ZERO, ComputeUtil::safeAdd));
                } else {
                    detail.setSurplusNum(BigDecimal.ZERO);
                }
            });
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ControlPlanSumVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (ControlPlanSumVO controlPlanSumVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ControlPlanSumVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("billName");
        fuzzyFields.add("projectCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("engineerName");
        fuzzyFields.add("managerName");
        fuzzyFields.add("createUserName");
        fuzzyFields.add("projectManagerName");
        fuzzyFields.add("materialTypeNames");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        param.getParams().put("orgId", new Parameter("in", orgVOList.stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ControlPlanSumVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("billName");
        fuzzyFields.add("projectCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("engineerName");
        fuzzyFields.add("managerName");
        fuzzyFields.add("createUserName");
        fuzzyFields.add("projectManagerName");
        fuzzyFields.add("materialTypeNames");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        List records = BeanMapper.mapList((Iterable)list, ControlPlanSumVO.class);
        records.forEach(vo -> {
            vo.setChangeStatusName((String)PlanConstant.CHANGE_STATUS.get(vo.getChangeStatus()));
            vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
        });
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", records);
        ExcelExport.getInstance().export("ControlPlanSum-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refControlPlanSumData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ControlPlanSumVO>> refControlPlanSumData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ControlPlanSumVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

