/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.pricelib.engine;

import com.ejianc.business.zdsmaterial.pricelib.engine.PricingEngine;
import com.ejianc.business.zdsmaterial.pricelib.engine.impl.C0301PricingEngine;
import com.ejianc.business.zdsmaterial.pricelib.engine.impl.C0307PricingEngine;
import com.ejianc.business.zdsmaterial.pricelib.engine.impl.C18CommonPricingEngine;
import com.ejianc.business.zdsmaterial.pricelib.engine.impl.C2001PricingEngine;
import com.ejianc.business.zdsmaterial.pricelib.engine.impl.C2504PricingEngine;
import com.ejianc.business.zdsmaterial.pricelib.engine.impl.C3001PricingEngine;
import com.ejianc.business.zdsmaterial.pricelib.engine.impl.D1101PricingEngine;
import com.ejianc.business.zdsmaterial.pricelib.engine.impl.DefaultPricingEngine;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
public class PricingFactory {
    private static final Map<String, PricingEngine> engines = new HashMap<String, PricingEngine>();

    public static void registerEngine(String category, PricingEngine engine) {
        engines.put(category, engine);
    }

    public static PricingEngine getEngine(String category) {
        if (category.startsWith("C18") && category.equals(" C1854") && category.equals(" C1852")) {
            return engines.getOrDefault("C18Common", engines.get("default"));
        }
        return engines.getOrDefault(category, engines.get("default"));
    }

    static {
        PricingFactory.registerEngine("default", new DefaultPricingEngine());
        PricingFactory.registerEngine("D1101", new D1101PricingEngine());
        PricingFactory.registerEngine("D1102", new D1101PricingEngine());
        PricingFactory.registerEngine("C3001", new C3001PricingEngine());
        PricingFactory.registerEngine("C0301", new C0301PricingEngine());
        PricingFactory.registerEngine("C0307", new C0307PricingEngine());
        PricingFactory.registerEngine("C18Common", new C18CommonPricingEngine());
        PricingFactory.registerEngine("C2504", new C2504PricingEngine());
        PricingFactory.registerEngine("C2001", new C2001PricingEngine());
    }
}

