package com.ejianc.business.zdsmaterial.cloudstore.apply.service;

import com.ejianc.business.zdsmaterial.cloudstore.apply.vo.AllotApplyVO;
import com.ejianc.business.zdsmaterial.cloudstore.apply.vo.ShopCartVO;
import com.ejianc.business.zdsmaterial.cloudstore.shelf.bean.GoodsEntity;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.zdsmaterial.cloudstore.apply.bean.ShopCartEntity;

import java.util.List;

/**
 * 购物车
 * 
 * @author generator
 * 
 */
public interface IShopCartService extends IBaseService<ShopCartEntity> {
    /**
     * 根据购物人查询购物车数据
     * @param purUserId
     * @return
     */
    CommonResponse<List<GoodsEntity>> queryGoodsByPurUserId(Long purUserId);
    CommonResponse<Integer> queryCountByPurUserId(Long purUserId);
    /**
     * 购物车提交接口
     * @param vos
     * @return
     */
    AllotApplyVO addAllotApply(List<ShopCartVO> vos);


    void upShopCart(List<Long> ids);
}
