package com.ejianc.business.zdsmaterial.pricelib.mapper;

import com.ejianc.business.zdsmaterial.erp.bean.ContractDetailEntity;
import com.ejianc.business.zdsmaterial.erp.bean.ContractEntity;
import com.ejianc.business.zdsmaterial.pricelib.bean.PriceContractEntity;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.Date;
import java.util.List;

/**
 * 价格库-合同明细
 *
 * @author generator
 *
 */
@Mapper
public interface PriceContractMapper extends BaseCrudMapper<PriceContractEntity> {

    @Select("select * from ejc_material_contract where create_time >= #{time} or update_time >= #{time}")
    List<ContractEntity> getContractListByTime(Date time);

    //    @Select("select * from ejc_promaterial_contract_detail where contract_id in (#{contractIdList})")
    @Select({
            "<script>",
            "select * from ejc_material_contract_detail where material_id is not null and contract_id in",
            "<foreach collection='contractIdList' item='contractId' open='(' separator=',' close=')'>",
            "#{contractId}",
            "</foreach>",
            "</script>"
    })
    List<ContractDetailEntity> getContractDetailListByContractId(@Param("contractIdList") List<Long> contractIdList);

//    @Delete("delete from ejc_promaterial_price_contract where bill_state not in (1,3)")
//    void delPriceContractByBillState();

    //    @Delete("delete from ejc_promaterial_price_contract where id in (#{ids})")
//    @Delete({
//            "<script>",
//            "delete from ejc_promaterial_price_contract where id in",
//            "<foreach collection='ids' item='id' open='(' separator=',' close=')'>",
//            "#{id}",
//            "</foreach>",
//            "</script>"
//    })
//    void delPriceContractByIds(@Param("ids") List<Long> ids);
}
