/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.sub.fee.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdsmaterial.sub.fee.bean.AuditorSetEntity;
import com.ejianc.business.zdsmaterial.sub.fee.service.IAuditorContractDetailService;
import com.ejianc.business.zdsmaterial.sub.fee.service.IAuditorSetService;
import com.ejianc.business.zdsmaterial.sub.fee.vo.AuditorContractDetailVO;
import com.ejianc.business.zdsmaterial.sub.fee.vo.AuditorSetVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"auditorSet"})
public class AuditorSetController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IAuditorSetService service;
    @Autowired
    private IAuditorContractDetailService contractDetailService;

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<AuditorSetVO> queryDetail(Long id) {
        AuditorSetEntity entity = (AuditorSetEntity)((Object)this.service.selectById(id));
        AuditorSetVO vo = (AuditorSetVO)BeanMapper.map((Object)((Object)entity), AuditorSetVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/auditorSetByProjectId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<AuditorSetVO> auditorSetByProjectId(Long projectId) {
        return this.service.auditorSetByProjectId(projectId);
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<AuditorContractDetailVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.contractDetailService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List records = BeanMapper.mapList((Iterable)page.getRecords(), AuditorContractDetailVO.class);
        pageData.setRecords(records);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryContract"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Boolean> queryContract(@RequestBody AuditorContractDetailVO detailVO) {
        return this.service.queryContract(detailVO);
    }

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<AuditorSetVO> saveOrUpdate(@RequestBody AuditorSetVO saveOrUpdateVO) {
        return this.service.saveOrUpdate(saveOrUpdateVO);
    }
}

