package com.ejianc.business.zdsmaterial.sub.fee.controller;

import cn.hutool.json.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdsmaterial.cons.PlanConstant;
import com.ejianc.business.zdsmaterial.sub.fee.bean.SubFeeApplyEntity;
import com.ejianc.business.zdsmaterial.sub.fee.service.ISubFeeApplyService;
import com.ejianc.business.zdsmaterial.sub.fee.service.impl.SubFeeApplyBpmServiceImpl;
import com.ejianc.business.zdsmaterial.sub.fee.vo.SubFeeApplyVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 分包费用申请实体
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("subFeeApply")
public class SubFeeApplyController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "ZDS_SUB_FEE_APPLY";//此处需要根据实际修改

    @Autowired
    private ISubFeeApplyService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SubFeeApplyVO> saveOrUpdate(@RequestBody SubFeeApplyVO saveOrUpdateVO) {
    	SubFeeApplyEntity entity = BeanMapper.map(saveOrUpdateVO, SubFeeApplyEntity.class);

        // 校验本期完工金额
        service.validateApplyMny(saveOrUpdateVO);

    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
//                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            entity.setCreateUserName(sessionManager.getUserContext().getUserName());
            entity.setBillDate(new Date());
        }
        if(entity.getCreateUserId() == null){
            entity.setCreateUserId(InvocationInfoProxy.getUserid());
        }
    	service.saveOrUpdate(entity, false);
    	SubFeeApplyVO vo = BeanMapper.map(entity, SubFeeApplyVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SubFeeApplyVO> queryDetail(Long id) {
    	SubFeeApplyEntity entity = service.selectById(id);
    	SubFeeApplyVO vo = BeanMapper.map(entity, SubFeeApplyVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SubFeeApplyVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (SubFeeApplyVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(SubFeeApplyVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SubFeeApplyVO>> queryList(@RequestBody QueryParam param) {
        this.getQueryParam(param);
        param.getParams().put("sourceType", new Parameter(QueryParam.EQ, PlanConstant.SOURCE_TYPE_EL));// 自制
        IPage<SubFeeApplyEntity> page = service.queryPage(param,false);
        IPage<SubFeeApplyVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), SubFeeApplyVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * @Description queryListBySupplier 查询供方列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryListBySupplier", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SubFeeApplyVO>> queryListBySupplier(@RequestBody QueryParam param) {
        this.getQueryParam(param);
        param.getParams().put("sourceType", new Parameter(QueryParam.EQ, PlanConstant.SOURCE_TYPE_SUPPLIER));// 供方发起
        IPage<SubFeeApplyEntity> page = service.queryPage(param,false);
        IPage<SubFeeApplyVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SubFeeApplyVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    private void getQueryParam(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */}

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        this.getQueryParam(param);
        param.getParams().put("sourceType", new Parameter(QueryParam.EQ, PlanConstant.SOURCE_TYPE_EL));// 自制
        param.setPageIndex(1);
        param.setPageSize(-1);
        List<SubFeeApplyEntity> list = service.queryList(param);
        List<SubFeeApplyVO> records = BeanMapper.mapList(list, SubFeeApplyVO.class);
        records.forEach(vo->{
            vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
        });
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", records);
        ExcelExport.getInstance().export("SubFeeApply-export.xlsx", beans, response);
    }

    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExportBySupplier", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportBySupplier(@RequestBody QueryParam param, HttpServletResponse response) {
        this.getQueryParam(param);
        param.getParams().put("sourceType", new Parameter(QueryParam.EQ, PlanConstant.SOURCE_TYPE_SUPPLIER));// 供方发起
        param.setPageIndex(1);
        param.setPageSize(-1);
        List<SubFeeApplyEntity> list = service.queryList(param);
        List<SubFeeApplyVO> records = BeanMapper.mapList(list, SubFeeApplyVO.class);
        records.forEach(vo->{
            vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
            vo.setApplyType(PlanConstant.APPLY_TYPE.get(vo.getApplyType()));
        });
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", records);
        ExcelExport.getInstance().export("SubFeeApplyBySupplier-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refSubFeeApplyData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<SubFeeApplyVO>> refSubFeeApplyData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<SubFeeApplyEntity> page = service.queryPage(param,false);
        IPage<SubFeeApplyVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SubFeeApplyVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * 保存同步单据
     * @param request
     * @return
     */
    @RequestMapping(value = "/saveSyncBill", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Long> saveSyncBill(HttpServletRequest request) {
        return CommonResponse.success("接收成功！", service.saveSyncBill(request));
    }

    /**
     * 确认状态回写
     *
     * @param request
     * @return
     */
    @PostMapping(value = "/supSignSync")
    @ResponseBody
    public CommonResponse<String> supSignSync(HttpServletRequest request) {
        String msg = service.updateBillSupSignSyncInfo(request);
        if (StringUtils.isNotBlank(msg)) {
            return CommonResponse.error(msg);
        }
        return CommonResponse.success("签字状态回写成功！");
    }

    /**
     * 更新单据申请状态
     *
     * @param vo
     * @return
     */
    @PostMapping(value = "/updateApplyType")
    @ResponseBody
    public CommonResponse<String> updateApplyType(@RequestBody SubFeeApplyVO vo) {
        // 分包未打印更新审核信息
        if(PlanConstant.APPLY_TYPE_UN_PRINT.equals(vo.getApplyType())){
            SubFeeApplyEntity entity = service.selectById(vo.getId());
            UserContext user = sessionManager.getUserContext();
            entity.setSupOperateTime(new Date());
            entity.setSupOperatorPhone(user.getUserMobile());
            entity.setSupOperatorName(user.getUserName());
            entity.setSupOperatorUserCode(user.getUserCode());
            entity.setApplyType(PlanConstant.APPLY_TYPE_UN_PRINT.toString());// 分包未打印
            Long sourceId = service.pushBillToSupCenter(entity);
            return CommonResponse.success("操作成功！");
        }
        String msg = service.updateApplyType(vo);
        if(StringUtils.isNotBlank(msg)) {
            return CommonResponse.error(msg);
        }
        return CommonResponse.success("操作成功！");
    }

    @Autowired
    private SubFeeApplyBpmServiceImpl bpmService;

    @RequestMapping(value = "/queryApproveUser", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONArray> queryApproveUser(Long billId, String sign){
        return bpmService.queryApproveUser(billId, null, sign, null);
    }
}
