/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.pricelib.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.business.targetcost.vo.ParamsCheckDsVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.business.zdsmaterial.pricelib.bean.PriceGuideDetailEntity;
import com.ejianc.business.zdsmaterial.pricelib.bean.PriceHistoryEntity;
import com.ejianc.business.zdsmaterial.pricelib.mapper.PriceHistoryMapper;
import com.ejianc.business.zdsmaterial.pricelib.service.IPriceContractService;
import com.ejianc.business.zdsmaterial.pricelib.service.IPriceGuideDetailService;
import com.ejianc.business.zdsmaterial.pricelib.service.IPriceHistoryService;
import com.ejianc.business.zdsmaterial.pricelib.vo.HistoryTypeEnum;
import com.ejianc.business.zdsmaterial.pricelib.vo.MaterialPriceCheckCodeEnum;
import com.ejianc.business.zdsmaterial.pricelib.vo.MaterialPriceCheckTypeEnum;
import com.ejianc.business.zdsmaterial.pricelib.vo.MaterialPriceHistoryApiVO;
import com.ejianc.business.zdsmaterial.pricelib.vo.PriceHistoryVO;
import com.ejianc.business.zdsmaterial.pricelib.vo.PriceLibVO;
import com.ejianc.foundation.share.api.IPriceDepotParamSetApi;
import com.ejianc.foundation.share.consts.PrinceDepotEnum;
import com.ejianc.foundation.share.vo.dto.PriceDepotParamSetDTO;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.kit.time.DateUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="priceHistoryService")
public class PriceHistoryServiceImpl
extends BaseServiceImpl<PriceHistoryMapper, PriceHistoryEntity>
implements IPriceHistoryService {
    private static final String PRICE_CHECK_CODE = "";
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private IPriceDepotParamSetApi priceDepotParamSetApi;
    @Autowired
    private IPriceContractService priceContractService;
    @Autowired
    private IPriceGuideDetailService priceGuideDetailService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public void initPriceHistory() {
        this.logger.info("---\u5386\u53f2\u4ef7\u683cinit\u5f00\u59cb---");
        this.logger.info("---\u6570\u636e\u5168\u5220\u9664\u64cd\u4f5c\u5f00\u59cb---");
        ((PriceHistoryMapper)this.baseMapper).delPriceHistoryAll();
        this.logger.info("---\u6570\u636e\u63d2\u5165\u64cd\u4f5c\u5f00\u59cb---");
        this.logger.info("\u4f20\u5165\u53c2\u6570--{}", (Object)JSONObject.toJSONString((Object)PrinceDepotEnum.\u6750\u6599\u4ef7\u683c\u5e93.getCode()));
        CommonResponse commonResponse = this.priceDepotParamSetApi.queryPriceDepotParamSetList(PrinceDepotEnum.\u6750\u6599\u4ef7\u683c\u5e93.getCode());
        if (!commonResponse.isSuccess()) {
            throw new BusinessException(commonResponse.getMsg());
        }
        List data = (List)commonResponse.getData();
        this.logger.info("\u8fd4\u56de\u53c2\u6570--{}", (Object)JSONObject.toJSONString((Object)data));
        if (CollectionUtils.isEmpty((Collection)data)) {
            return;
        }
        Date nowDate = new Date();
        HashMap<String, PriceHistoryVO> fatherPriceHistoryMap = new HashMap<String, PriceHistoryVO>();
        HashMap<String, PriceHistoryVO> sonPriceHistoryMap = new HashMap<String, PriceHistoryVO>();
        for (PriceDepotParamSetDTO paramSetDTO : data) {
            Map<String, PriceHistoryVO> priceHistoryVOMap;
            List priceHistoryVOS;
            List<PriceLibVO> priceLibVOS;
            if (null == paramSetDTO.getSource()) continue;
            String description = HistoryTypeEnum.getEnumByStateCode((Integer)paramSetDTO.getSource()).getDescription();
            Integer code = HistoryTypeEnum.getEnumByStateCode((Integer)paramSetDTO.getSource()).getCode();
            Date beforeDate = this.getMonthBefore(nowDate, paramSetDTO.getCycle());
            this.logger.info("\u5f53\u524d\u65f6\u95f4--{}-\u524d-{}--\u4e2a\u6708\u65f6\u95f4--{}", new Object[]{DateFormatUtil.formatDate((String)"yyyy-MM-dd HH:mm:ss", (Date)nowDate), paramSetDTO.getCycle().toString(), DateFormatUtil.formatDate((String)"yyyy-MM-dd HH:mm:ss", (Date)beforeDate)});
            if (!paramSetDTO.getLeafFlag().booleanValue()) {
                priceLibVOS = this.priceContractService.queryPriceLibList(beforeDate, nowDate, paramSetDTO.getCategoryId());
                if (CollectionUtils.isEmpty(priceLibVOS)) continue;
                priceHistoryVOS = BeanMapper.mapList(priceLibVOS, PriceHistoryVO.class);
                priceHistoryVOMap = priceHistoryVOS.stream().map(item -> {
                    item.setId(item.getMaterialId());
                    item.setHistoryType(code);
                    return item;
                }).collect(Collectors.toMap(t -> t.getId().toString(), Function.identity(), (key1, key2) -> key2));
                fatherPriceHistoryMap.putAll(priceHistoryVOMap);
                this.logger.info("\u7236\u7ea7\u7c7b\u578b\uff1a{},{},\u6570\u636e\u6761\u6570\uff1a{}", new Object[]{description, code, priceHistoryVOS.size()});
                continue;
            }
            if (!StringUtils.isNotEmpty((CharSequence)paramSetDTO.getCategoryId()) || CollectionUtils.isEmpty(priceLibVOS = this.priceContractService.queryPriceLibList(beforeDate, nowDate, paramSetDTO.getCategoryId()))) continue;
            priceHistoryVOS = BeanMapper.mapList(priceLibVOS, PriceHistoryVO.class);
            priceHistoryVOMap = priceHistoryVOS.stream().map(item -> {
                item.setId(item.getMaterialId());
                item.setHistoryType(code);
                return item;
            }).collect(Collectors.toMap(t -> t.getId().toString(), Function.identity(), (key1, key2) -> key2));
            this.duplicates(sonPriceHistoryMap, priceHistoryVOMap);
            this.logger.info("\u5b50\u7ea7\u7c7b\u578b\uff1a{},{},\u6570\u636e\u6761\u6570\uff1a{},\u5b50\u7ea7\u5206\u7c7b\u5185\u7801\uff1a{}", new Object[]{description, code, priceHistoryVOS.size(), paramSetDTO.getCategoryId()});
        }
        this.duplicates(fatherPriceHistoryMap, sonPriceHistoryMap);
        if (!fatherPriceHistoryMap.isEmpty()) {
            List priceHistoryEntities = BeanMapper.mapList(fatherPriceHistoryMap.values(), PriceHistoryEntity.class);
            this.logger.info("\u4fdd\u5b58\u6570\u636e\u5927\u5c0f{}\u6761", (Object)priceHistoryEntities.size());
            super.saveOrUpdateBatch((Collection)priceHistoryEntities);
        }
        this.logger.info("---\u6570\u636e\u63d2\u5165\u64cd\u4f5c\u7ed3\u675f---");
    }

    public void duplicates(Map<String, PriceHistoryVO> oldMap, Map<String, PriceHistoryVO> nowMap) {
        if (!oldMap.isEmpty()) {
            for (String s : nowMap.keySet()) {
                if (!oldMap.containsKey(s)) continue;
                oldMap.remove(s);
            }
        }
        oldMap.putAll(nowMap);
    }

    public Date getMonthBefore(Date nowTime, BigDecimal num) {
        if (null == num) {
            num = new BigDecimal(0);
        }
        int month = num.intValue();
        Date beforeDate = DateUtil.subMonths((Date)nowTime, (int)month);
        return beforeDate;
    }

    @Override
    public MaterialPriceHistoryApiVO getMaterialPriceHistoryApiVO(Long materialId) {
        PriceHistoryEntity priceHistoryEntity = (PriceHistoryEntity)((Object)super.selectById((Serializable)materialId));
        if (priceHistoryEntity == null) {
            return new MaterialPriceHistoryApiVO();
        }
        MaterialPriceHistoryApiVO vo = (MaterialPriceHistoryApiVO)BeanMapper.map((Object)((Object)priceHistoryEntity), MaterialPriceHistoryApiVO.class);
        HashMap<Long, MaterialPriceHistoryApiVO> guidePriceMap = new HashMap<Long, MaterialPriceHistoryApiVO>();
        guidePriceMap.put(materialId, vo);
        this.queryPriceGuide(guidePriceMap);
        if (HistoryTypeEnum.\u5408\u540c\u5386\u53f2\u4ef7.getCode().equals(vo.getHistoryType())) {
            vo.setHistoryPriceArea(vo.getContractPriceArea());
            vo.setHistoryTaxPriceArea(vo.getContractTaxPriceArea());
        } else if (HistoryTypeEnum.\u7ed3\u7b97\u5386\u53f2\u4ef7.getCode().equals(vo.getHistoryType())) {
            vo.setHistoryPriceArea(vo.getSettlePriceArea());
            vo.setHistoryTaxPriceArea(vo.getSettleTaxPriceArea());
        } else if (HistoryTypeEnum.\u9a8c\u6536\u5386\u53f2\u4ef7.getCode().equals(vo.getHistoryType())) {
            vo.setHistoryPriceArea(vo.getCheckPriceArea());
            vo.setHistoryTaxPriceArea(vo.getCheckTaxPriceArea());
        }
        String guidePriceArea = ((MaterialPriceHistoryApiVO)guidePriceMap.get(vo.getMaterialId())).getGuidePriceArea() == null ? PRICE_CHECK_CODE : ((MaterialPriceHistoryApiVO)guidePriceMap.get(vo.getMaterialId())).getGuidePriceArea();
        vo.setGuidePriceArea(guidePriceArea);
        vo.setGuideTaxPriceArea(guidePriceArea);
        return vo;
    }

    @Override
    public Map<Long, MaterialPriceHistoryApiVO> getMaterialPriceHistoryApiVOMap(List<Long> materialIds) {
        Map<Long, Object> map = new HashMap<Long, MaterialPriceHistoryApiVO>();
        if (CollectionUtils.isEmpty(materialIds)) {
            return map;
        }
        List<MaterialPriceHistoryApiVO> materialPriceHistoryApiVOS = this.getMaterialPriceHistoryApiVOS(materialIds);
        if (CollectionUtils.isEmpty(materialPriceHistoryApiVOS)) {
            return map;
        }
        map = materialPriceHistoryApiVOS.stream().collect(Collectors.toMap(t -> t.getId(), Function.identity(), (key1, key2) -> key2));
        return map;
    }

    @Override
    public List<MaterialPriceHistoryApiVO> getMaterialPriceHistoryApiVOS(List<Long> materialIds) {
        if (CollectionUtils.isEmpty(materialIds)) {
            return new ArrayList<MaterialPriceHistoryApiVO>();
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("id", new Parameter("in", materialIds));
        List priceHistoryList = super.queryList(queryParam);
        if (CollectionUtils.isEmpty((Collection)priceHistoryList)) {
            return new ArrayList<MaterialPriceHistoryApiVO>();
        }
        List historyApiVOS = BeanMapper.mapList((Iterable)priceHistoryList, MaterialPriceHistoryApiVO.class);
        if (CollectionUtils.isNotEmpty((Collection)priceHistoryList)) {
            Map<Long, MaterialPriceHistoryApiVO> guidePriceMap = historyApiVOS.stream().collect(Collectors.toMap(MaterialPriceHistoryApiVO::getMaterialId, Function.identity(), (key1, key2) -> key2));
            this.queryPriceGuide(guidePriceMap);
            for (MaterialPriceHistoryApiVO vo : historyApiVOS) {
                if (HistoryTypeEnum.\u5408\u540c\u5386\u53f2\u4ef7.getCode().equals(vo.getHistoryType())) {
                    vo.setHistoryPriceArea(vo.getContractPriceArea());
                    vo.setHistoryTaxPriceArea(vo.getContractTaxPriceArea());
                } else if (HistoryTypeEnum.\u7ed3\u7b97\u5386\u53f2\u4ef7.getCode().equals(vo.getHistoryType())) {
                    vo.setHistoryPriceArea(vo.getSettlePriceArea());
                    vo.setHistoryTaxPriceArea(vo.getSettleTaxPriceArea());
                } else if (HistoryTypeEnum.\u9a8c\u6536\u5386\u53f2\u4ef7.getCode().equals(vo.getHistoryType())) {
                    vo.setHistoryPriceArea(vo.getCheckPriceArea());
                    vo.setHistoryTaxPriceArea(vo.getCheckTaxPriceArea());
                }
                String guidePriceArea = guidePriceMap.get(vo.getMaterialId()).getGuidePriceArea() == null ? PRICE_CHECK_CODE : guidePriceMap.get(vo.getMaterialId()).getGuidePriceArea();
                vo.setGuidePriceArea(guidePriceArea);
                vo.setGuideTaxPriceArea(guidePriceArea);
            }
        }
        return historyApiVOS;
    }

    private void queryPriceGuide(Map<Long, MaterialPriceHistoryApiVO> libMap) {
        if (libMap.isEmpty()) {
            return;
        }
        ArrayList<Long> materialIdList = new ArrayList<Long>(libMap.keySet());
        List<PriceGuideDetailEntity> list = this.priceGuideDetailService.queryPriceGuideDetailByMaterialIds(materialIdList);
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        Map guideMap = list.stream().collect(Collectors.toMap(PriceGuideDetailEntity::getMaterialId, Function.identity(), (key1, key2) -> key1));
        for (Map.Entry<Long, MaterialPriceHistoryApiVO> entry : libMap.entrySet()) {
            Long materialId = entry.getKey();
            MaterialPriceHistoryApiVO vo = entry.getValue();
            if (!guideMap.containsKey(materialId)) continue;
            PriceGuideDetailEntity guide = (PriceGuideDetailEntity)((Object)guideMap.get(materialId));
            BigDecimal min = guide.getMinMny() == null ? BigDecimal.ZERO : guide.getMinMny();
            BigDecimal max = guide.getMaxMny() == null ? BigDecimal.ZERO : guide.getMaxMny();
            min = min.divide(BigDecimal.ONE, 4, 4);
            max = max.divide(BigDecimal.ONE, 4, 4);
            vo.setGuidePriceArea(min + "-" + max);
        }
    }

    @Override
    public ParamsCheckVO priceCheckParams(MaterialPriceHistoryApiVO materialPriceHistoryApiVO) {
        StringBuffer stringBuffer;
        ParamsCheckDsVO paramsCheckDsVO;
        BigDecimal price;
        BigDecimal minPrice;
        BigDecimal maxPrice;
        String[] split;
        String getHistoryPriceArea;
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOS = new ArrayList<ParamsCheckVO>();
        List detailList = materialPriceHistoryApiVO.getMaterialPriceHistoryApiVOList();
        Integer priceCheckType = materialPriceHistoryApiVO.getPriceCheckType();
        if (priceCheckType == null) {
            this.logger.info("priceCheckType\u4e3a\u7a7a\u76f4\u63a5\u8fd4\u56de\u7ed3\u679c");
            return paramsCheckVO;
        }
        if (CollectionUtils.isEmpty((Collection)detailList)) {
            this.logger.info("detailList\u4e3a\u7a7a\u76f4\u63a5\u8fd4\u56de\u7ed3\u679c");
            return paramsCheckVO;
        }
        String MAX_CODE = PRICE_CHECK_CODE;
        String MIN_CODE = PRICE_CHECK_CODE;
        String name = MaterialPriceCheckTypeEnum.getEnumByCode((Integer)priceCheckType).getDescription();
        switch (priceCheckType) {
            case 1: {
                MAX_CODE = MaterialPriceCheckCodeEnum.\u6750\u6599\u91c7\u8d2d\u5408\u540c\u6700\u9ad8\u4ef7.getCode();
                MIN_CODE = MaterialPriceCheckCodeEnum.\u6750\u6599\u91c7\u8d2d\u5408\u540c\u6700\u4f4e\u4ef7.getCode();
                break;
            }
            case 2: {
                MAX_CODE = MaterialPriceCheckCodeEnum.\u6750\u6599\u91c7\u8d2d\u9a8c\u6536\u6700\u9ad8\u4ef7.getCode();
                MIN_CODE = MaterialPriceCheckCodeEnum.\u6750\u6599\u91c7\u8d2d\u9a8c\u6536\u6700\u4f4e\u4ef7.getCode();
                break;
            }
            case 3: {
                MAX_CODE = MaterialPriceCheckCodeEnum.\u6750\u6599\u91c7\u8d2d\u7ed3\u7b97\u6700\u9ad8\u4ef7.getCode();
                MIN_CODE = MaterialPriceCheckCodeEnum.\u6750\u6599\u91c7\u8d2d\u7ed3\u7b97\u6700\u4f4e\u4ef7.getCode();
                break;
            }
            case 4: {
                MAX_CODE = MaterialPriceCheckCodeEnum.\u6df7\u51dd\u571f\u91c7\u8d2d\u5408\u540c\u6700\u9ad8\u4ef7.getCode();
                MIN_CODE = MaterialPriceCheckCodeEnum.\u6df7\u51dd\u571f\u91c7\u8d2d\u5408\u540c\u6700\u4f4e\u4ef7.getCode();
                break;
            }
            case 5: {
                MAX_CODE = MaterialPriceCheckCodeEnum.\u6df7\u51dd\u571f\u91c7\u8d2d\u9a8c\u6536\u6700\u9ad8\u4ef7.getCode();
                MIN_CODE = MaterialPriceCheckCodeEnum.\u6df7\u51dd\u571f\u91c7\u8d2d\u9a8c\u6536\u6700\u4f4e\u4ef7.getCode();
                break;
            }
            case 6: {
                MAX_CODE = MaterialPriceCheckCodeEnum.\u6df7\u51dd\u571f\u91c7\u8d2d\u7ed3\u7b97\u6700\u9ad8\u4ef7.getCode();
                MIN_CODE = MaterialPriceCheckCodeEnum.\u6df7\u51dd\u571f\u91c7\u8d2d\u7ed3\u7b97\u6700\u4f4e\u4ef7.getCode();
            }
        }
        Long orgId = materialPriceHistoryApiVO.getOrgId();
        if (null == orgId) {
            this.logger.info("orgId\u4e3a\u7a7a");
            return paramsCheckVO;
        }
        CommonResponse maxParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(MAX_CODE, orgId);
        if (!maxParamByCode.isSuccess() && null == maxParamByCode.getData()) {
            this.logger.info(maxParamByCode.getMsg());
            return paramsCheckVO;
        }
        CommonResponse minParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(MIN_CODE, orgId);
        if (!minParamByCode.isSuccess() && null == minParamByCode.getData()) {
            this.logger.info(minParamByCode.getMsg());
            return paramsCheckVO;
        }
        List maxParamVOS = (List)maxParamByCode.getData();
        List minParamVOS = (List)minParamByCode.getData();
        this.logger.info(name + "\u5386\u53f2\u9ad8\u4ef7\u63a7\u5236\u4fe1\u606f\u8fd4\u56de\uff1a" + JSONObject.toJSONString((Object)maxParamVOS));
        this.logger.info(name + "\u5386\u53f2\u4f4e\u4ef7\u63a7\u5236\u4fe1\u606f\u8fd4\u56de\uff1a" + JSONObject.toJSONString((Object)minParamVOS));
        boolean flag = true;
        this.logger.info("\u4f20\u5165\u53c2\u6570--{}", (Object)JSONObject.toJSONString((Object)PrinceDepotEnum.\u6750\u6599\u4ef7\u683c\u5e93.getCode()));
        if (CollectionUtils.isNotEmpty((Collection)maxParamVOS)) {
            for (BillParamVO maxParamVO : maxParamVOS) {
                ParamsCheckVO paramsCheckVOMax = new ParamsCheckVO();
                ArrayList<ParamsCheckDsVO> checkDsVOSMax = new ArrayList<ParamsCheckDsVO>();
                BigDecimal roleValueMax = maxParamVO.getRoleValue();
                paramsCheckVOMax.setWarnType(paramsArray[maxParamVO.getControlType()]);
                for (MaterialPriceHistoryApiVO detailVO : detailList) {
                    BigDecimal maxPriceParam;
                    getHistoryPriceArea = PRICE_CHECK_CODE;
                    if (flag) {
                        getHistoryPriceArea = detailVO.getHistoryPriceArea();
                        if (StringUtils.isEmpty((CharSequence)getHistoryPriceArea)) {
                            getHistoryPriceArea = detailVO.getGuidePriceArea();
                        }
                    } else {
                        getHistoryPriceArea = detailVO.getGuidePriceArea();
                        if (StringUtils.isEmpty((CharSequence)getHistoryPriceArea)) {
                            getHistoryPriceArea = detailVO.getHistoryPriceArea();
                        }
                    }
                    if (getHistoryPriceArea == null || getHistoryPriceArea.isEmpty()) continue;
                    split = getHistoryPriceArea.split("-");
                    maxPrice = new BigDecimal(split[1]);
                    minPrice = new BigDecimal(split[0]);
                    this.logger.info("\u7269\u8d44\uff1a{}--\u9ad8\u4ef7\uff1a{}---\u4f4e\u4ef7\uff1a{}", new Object[]{detailVO.getMaterialName() + detailVO.getSpec(), split[1], split[0]});
                    if (maxPrice.compareTo(minPrice) == 0 || (price = detailVO.getPrice() == null ? BigDecimal.ZERO : detailVO.getPrice().setScale(4, 4)).compareTo(maxPriceParam = ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)maxPrice, (BigDecimal)roleValueMax), (BigDecimal)new BigDecimal("100")).setScale(4, 4)) <= 0) continue;
                    paramsCheckDsVO = new ParamsCheckDsVO();
                    paramsCheckDsVO.setOrgName(maxParamVO.getOrgName());
                    paramsCheckDsVO.setWarnItem(detailVO.getMaterialName() + (detailVO.getSpec() == null ? PRICE_CHECK_CODE : "+" + detailVO.getSpec()));
                    paramsCheckDsVO.setWarnName(name + "\u4ef7\u5927\u4e8e\u5386\u53f2\u6700\u9ad8\u4ef7");
                    stringBuffer = new StringBuffer();
                    stringBuffer.append(name + "\u5355\u4ef7\uff1a").append(price).append("\uff0c\u5386\u53f2\u4ef7\u683c\u533a\u95f4:(").append(getHistoryPriceArea).append("),\u5386\u53f2\u6700\u9ad8\u4ef7*").append(roleValueMax).append("%:").append(maxPriceParam).append("\uff0c\u8d85\u51fa\u6700\u9ad8\u4ef7\uff1a").append(ComputeUtil.safeSub((BigDecimal)price, (BigDecimal)maxPriceParam).setScale(4, 4));
                    paramsCheckDsVO.setContent(stringBuffer.toString());
                    checkDsVOSMax.add(paramsCheckDsVO);
                }
                paramsCheckVOMax.setDataSource(checkDsVOSMax);
                paramsCheckVOS.add(paramsCheckVOMax);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)minParamVOS)) {
            for (BillParamVO minParamVO : minParamVOS) {
                ParamsCheckVO paramsCheckVOMin = new ParamsCheckVO();
                ArrayList<ParamsCheckDsVO> checkDsVOSMin = new ArrayList<ParamsCheckDsVO>();
                BigDecimal roleValueMin = minParamVO.getRoleValue();
                paramsCheckVOMin.setWarnType(paramsArray[minParamVO.getControlType()]);
                for (MaterialPriceHistoryApiVO detailVO : detailList) {
                    BigDecimal minPriceParam;
                    getHistoryPriceArea = PRICE_CHECK_CODE;
                    if (flag) {
                        getHistoryPriceArea = detailVO.getHistoryPriceArea();
                        if (StringUtils.isEmpty((CharSequence)getHistoryPriceArea)) {
                            getHistoryPriceArea = detailVO.getGuidePriceArea();
                        }
                    } else {
                        getHistoryPriceArea = detailVO.getGuidePriceArea();
                        if (StringUtils.isEmpty((CharSequence)getHistoryPriceArea)) {
                            getHistoryPriceArea = detailVO.getHistoryPriceArea();
                        }
                    }
                    if (getHistoryPriceArea == null || getHistoryPriceArea.isEmpty()) continue;
                    split = getHistoryPriceArea.split("-");
                    maxPrice = new BigDecimal(split[1]);
                    minPrice = new BigDecimal(split[0]);
                    this.logger.info("\u7269\u8d44\uff1a{}--\u9ad8\u4ef7\uff1a{}---\u4f4e\u4ef7\uff1a{}", new Object[]{detailVO.getMaterialName() + detailVO.getSpec(), split[1], split[0]});
                    if (maxPrice.compareTo(minPrice) == 0 || (price = detailVO.getPrice() == null ? BigDecimal.ZERO : detailVO.getPrice().setScale(4, 4)).compareTo(minPriceParam = ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)minPrice, (BigDecimal)roleValueMin), (BigDecimal)new BigDecimal("100")).setScale(4, 4)) >= 0) continue;
                    paramsCheckDsVO = new ParamsCheckDsVO();
                    paramsCheckDsVO.setOrgName(minParamVO.getOrgName());
                    paramsCheckDsVO.setWarnItem(detailVO.getMaterialName() + (detailVO.getSpec() == null ? PRICE_CHECK_CODE : "+" + detailVO.getSpec()));
                    paramsCheckDsVO.setWarnName(name + "\u4ef7\u5c0f\u4e8e\u5386\u53f2\u6700\u4f4e\u4ef7");
                    stringBuffer = new StringBuffer();
                    stringBuffer.append(name + "\u5355\u4ef7\uff1a").append(price).append("\uff0c\u5386\u53f2\u4ef7\u683c\u533a\u95f4:(").append(getHistoryPriceArea).append("),\u5386\u53f2\u6700\u4f4e\u4ef7*").append(roleValueMin).append("%:").append(minPriceParam).append("\uff0c\u4f4e\u4e8e\u6700\u4f4e\u4ef7\uff1a").append(ComputeUtil.safeSub((BigDecimal)minPriceParam, (BigDecimal)price).setScale(4, 4));
                    paramsCheckDsVO.setContent(stringBuffer.toString());
                    checkDsVOSMin.add(paramsCheckDsVO);
                }
                paramsCheckVOMin.setDataSource(checkDsVOSMin);
                paramsCheckVOS.add(paramsCheckVOMin);
            }
        }
        String[] paramsArr = new String[]{"alert", "warn", "none"};
        HashMap<String, List> map = new HashMap<String, List>();
        if (CollectionUtils.isNotEmpty(paramsCheckVOS)) {
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if (map.containsKey(warnType)) {
                    List checkDsVOS = (List)map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType, checkDsVOS);
                    continue;
                }
                map.put(warnType, checkVO.getDataSource());
            }
        }
        for (String s : paramsArr) {
            if (!map.containsKey(s)) continue;
            paramsCheckVO.setWarnType(s);
            paramsCheckVO.setDataSource((List)map.get(s));
            if (CollectionUtils.isEmpty((Collection)paramsCheckVO.getDataSource())) {
                paramsCheckVO.setWarnType("none");
                continue;
            }
            return paramsCheckVO;
        }
        return paramsCheckVO;
    }

    @Override
    public Boolean historyPriceShow(Integer priceCheckType) {
        Boolean flag = true;
        return flag;
    }
}

