package com.ejianc.business.zdsmaterial.material.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.zdsmaterial.material.bean.MaterialCategoryEntity;
import com.ejianc.business.zdsmaterial.material.service.IMaterialCategoryService;
import com.ejianc.business.zdsmaterial.material.vo.MaterialCategorySettingsVO;
import com.ejianc.business.zdsmaterial.material.vo.MaterialCategoryVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ResultAsTree;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.zdsmaterial.material.mapper.MaterialCategorySettingsMapper;
import com.ejianc.business.zdsmaterial.material.bean.MaterialCategorySettingsEntity;
import com.ejianc.business.zdsmaterial.material.service.IMaterialCategorySettingsService;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 采购计划控制方式
 * 
 * @author generator
 * 
 */
@Service("materialCategorySettingsService")
public class MaterialCategorySettingsServiceImpl extends BaseServiceImpl<MaterialCategorySettingsMapper, MaterialCategorySettingsEntity> implements IMaterialCategorySettingsService{

    @Autowired
    private MaterialCategorySettingsMapper mapper;

    @Autowired
    private IMaterialCategoryService categoryService;

    @Override
    public CommonResponse<MaterialCategorySettingsVO> saveOrUpdate(MaterialCategorySettingsVO saveOrUpdateVO) {
        CommonResponse<Boolean> booleanCommonResponse = betweenMinAndMaxRation(saveOrUpdateVO);
        if (!booleanCommonResponse.isSuccess()){
            throw new BusinessException("网络异常 请联系管理员处理！");
        }
        if (!booleanCommonResponse.getData()){
            throw new BusinessException("控制范围开始和结束区间不允许出现在已有区间内!");
        }

        QueryWrapper<MaterialCategorySettingsEntity> queryWrapper = new QueryWrapper<>();
        if (null!=saveOrUpdateVO.getId()){
            queryWrapper.ne("id",saveOrUpdateVO.getId());
        }
        if (null==saveOrUpdateVO.getCategoryId()){
            throw new BusinessException("物料类型不能为空！");
        }
        queryWrapper.eq("category_id",saveOrUpdateVO.getCategoryId());
        queryWrapper.eq("control_mode",saveOrUpdateVO.getControlMode());
        MaterialCategorySettingsEntity entity = BeanMapper.map(saveOrUpdateVO, MaterialCategorySettingsEntity.class);
        super.saveOrUpdate(entity, false);
        MaterialCategorySettingsVO vo = BeanMapper.map(entity, MaterialCategorySettingsVO.class);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    @Override
    public CommonResponse<JSONObject> queryCategoryList(QueryParam param){
        Map<String,Object> condition = new HashMap<>();
        for(Map.Entry<String, Parameter> entry:param.getParams().entrySet()) {
            condition.put(entry.getKey(), entry.getValue().getValue());
        }
        condition.put("tenantId", InvocationInfoProxy.getTenantid());
        List<MaterialCategoryVO> dataList = categoryService.queryListAndRuledFlag(condition);
        List<Map> resultMapList = BeanMapper.mapList(dataList, Map.class);
        resultMapList.forEach(l-> {
            if(l.get("leafFlag").equals(false)){
                l.put("children", new ArrayList<>());
            }
        });

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("data", ResultAsTree.createTreeData(resultMapList));
        return CommonResponse.success("查询成功", jsonObject);
    }
    @Override
    public CommonResponse<Boolean> betweenMinAndMaxRation(MaterialCategorySettingsVO vo){
        long l = mapper.betweenMinAndMaxRation(vo);
        return CommonResponse.success(l > 0?Boolean.FALSE:Boolean.TRUE) ;
    }
    @Override
    public Map<Long,List<MaterialCategorySettingsEntity>> returnSettings(List<Long> ids){
//        QueryWrapper<MaterialCategoryEntity> categoryQueryWrapper = new QueryWrapper<>();
//        categoryQueryWrapper.eq("tenant_id",InvocationInfoProxy.getTenantid());
//        categoryQueryWrapper.in("id",ids);
        List<MaterialCategoryVO> categoryList = categoryService.queryCategoryListByIds(ids);
        List<String> allCategoryIds = new ArrayList<>();
        List<String> collect = categoryList.stream().map(e -> e.getInnerCode()).collect(Collectors.toList());
        for (String e :collect){
            List<String> strings = Arrays.asList(e.split("\\|"));
            allCategoryIds.addAll(strings);
        }


        //无组织过滤  本人  全部

        QueryWrapper<MaterialCategoryEntity> categoryAllQueryWrapper = new QueryWrapper<>();
        categoryAllQueryWrapper.eq("tenant_id",InvocationInfoProxy.getTenantid());
        categoryAllQueryWrapper.in("id",allCategoryIds);
        List<MaterialCategoryEntity> materialCategoryEntities = categoryService.list(categoryAllQueryWrapper);
        Map<Long, MaterialCategoryEntity> allCategory = materialCategoryEntities.stream().collect(Collectors.toMap(e -> e.getId(), e -> e));


        QueryWrapper<MaterialCategorySettingsEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("tenant_id",InvocationInfoProxy.getTenantid());
        queryWrapper.in("category_id",allCategoryIds);
        List<MaterialCategorySettingsEntity> oneSettings = super.list(queryWrapper);

        Map<Long,List<MaterialCategorySettingsEntity>> endMaps = new HashMap<>();
        if (null!=oneSettings&& CollectionUtils.isNotEmpty(oneSettings)){
            Map<Long, List<MaterialCategorySettingsEntity>> collect1 = oneSettings.stream().collect(Collectors.groupingBy(e -> e.getCategoryId()));
            //有些是有3个
            Map<String, MaterialCategorySettingsEntity> allSettings = oneSettings.stream().collect(Collectors.toMap(e -> e.getCategoryId()+"_"+e.getControlMode(), e -> e));
            for (Map.Entry<Long, MaterialCategoryEntity> entry : allCategory.entrySet()) {
                entry.getValue().setRuledFlag(collect1.keySet().contains(entry.getKey())?1:0);
            }
            for (Long l :ids){
                List<MaterialCategorySettingsEntity> materialCategorySettingsEntity = checkCategoryId(allCategory, allSettings, l);
                if (null!=materialCategorySettingsEntity){
                    endMaps.put(l,materialCategorySettingsEntity);
                }
            }
        }
        return endMaps;
    }

    public List<MaterialCategorySettingsEntity> checkCategoryId(Map<Long, MaterialCategoryEntity> allCategory, Map<String, MaterialCategorySettingsEntity> allSettings, Long checkId){
        if (allCategory.containsKey(checkId)){
            MaterialCategoryEntity entity = allCategory.get(checkId);
            if (1==entity.getRuledFlag()){
                List<MaterialCategorySettingsEntity> list = new ArrayList<>() ;
                if (allSettings.containsKey(checkId+"_1")){
                    list.add(allSettings.get(checkId+"_1"));
                }
                if (allSettings.containsKey(checkId+"_2")){
                    list.add(allSettings.get(checkId+"_2"));
                }
                if (allSettings.containsKey(checkId+"_3")){
                    list.add(allSettings.get(checkId+"_3"));
                }
                return list;
            }else {
                if (null!=entity.getParentId()){
                    return  checkCategoryId(allCategory, allSettings, entity.getParentId());
                }
            }
        }
        return null;
    }

}
