/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.sub.settle.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdsmaterial.sub.settle.bean.SubSettleEntity;
import com.ejianc.business.zdsmaterial.sub.settle.service.ISubSettleService;
import com.ejianc.business.zdsmaterial.sub.settle.vo.SubSettleFileVO;
import com.ejianc.business.zdsmaterial.sub.settle.vo.SubSettleTemplateVO;
import com.ejianc.business.zdsmaterial.sub.settle.vo.SubSettleVO;
import com.ejianc.business.zdssupplier.sub.api.ISubLinkerApi;
import com.ejianc.business.zdssupplier.sub.api.ISubManagerApi;
import com.ejianc.business.zdssupplier.sub.vo.LinkerVO;
import com.ejianc.business.zdssupplier.sub.vo.SupplierManagerVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.http.HttpClientUtils;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.EnvironmentTools;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"subSettle"})
@Api(value="\u5206\u5305\u7ed3\u7b97\u7ba1\u7406", tags={"\u5206\u5305\u7ed3\u7b97\u7ba1\u7406"})
public class SubSettleController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "SUB_SETTLE";
    @Autowired
    private ISubSettleService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IAttachmentApi attachmentApi;
    private final Long DEFAULT_TMPLE_FILE = 852598949071032396L;
    private final String templateSourceType = "subTemplateFile";
    @Autowired
    private ISubLinkerApi subLinkerApi;
    @Autowired
    private ISubManagerApi subManagerApi;
    @Autowired
    private IUserApi userApi;
    @Autowired
    private EnvironmentTools environmentTools;

    @ApiOperation(value="\u65b0\u589e\u6216\u8005\u4fee\u6539")
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<SubSettleVO> saveOrUpdate(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody SubSettleVO saveOrUpdateVO) {
        SubSettleEntity entity;
        if (null == saveOrUpdateVO.getId() && CollectionUtils.isNotEmpty((Collection)saveOrUpdateVO.getSubSettleTemplateList())) {
            for (SubSettleTemplateVO item : saveOrUpdateVO.getSubSettleTemplateList()) {
                CommonResponse attachResp;
                if (!this.DEFAULT_TMPLE_FILE.equals(item.getAttachmentId())) continue;
                if (null == item.getId()) {
                    item.setId(Long.valueOf(IdWorker.getId()));
                }
                if (!(attachResp = this.attachmentApi.copyFile(this.DEFAULT_TMPLE_FILE.toString(), item.getId().toString(), "EJCBT202403000003", "subTemplateFile", false)).isSuccess()) {
                    return CommonResponse.error((String)"\u6587\u4ef6\u4fdd\u5b58\u5931\u8d25!");
                }
                ArrayList<Long> attachIds = new ArrayList<Long>();
                attachIds.add(((AttachmentVO)attachResp.getData()).getId());
                item.setAttachIds(attachIds);
            }
        }
        if ((entity = (SubSettleEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, SubSettleEntity.class))).getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        entity.setCreateUserId(this.sessionManager.getUserContext().getUserId());
        if (null == entity.getSubLinkId()) {
            return CommonResponse.error((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u4e59\u65b9\u8054\u7cfb\u4eba\u4fe1\u606f\u4e3a\u7a7a!");
        }
        if (null != entity.getSubLinkId()) {
            CommonResponse linkerResp = this.subLinkerApi.getOneById(entity.getSubLinkId());
            if (!linkerResp.isSuccess()) {
                this.logger.error("\u7ed3\u7b97\u5355\u4fdd\u5b58\u5931\u8d25\uff0c\u67e5\u8be2\u4e59\u65b9\u8054\u7cfb\u4ebaid-{}\u4fe1\u606f\u5931\u8d25-{}", (Object)entity.getSubLinkId(), (Object)JSONObject.toJSONString((Object)linkerResp));
                return CommonResponse.error((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u67e5\u8be2\u4e59\u65b9\u8054\u7cfb\u4eba\u4fe1\u606f\u5931\u8d25\uff01");
            }
            if (null == linkerResp.getData()) {
                this.logger.error("\u7ed3\u7b97\u5355\u4fdd\u5b58\u5931\u8d25\uff0c\u67e5\u8be2\u4e59\u65b9\u8054\u7cfb\u4ebaid-{}\u4fe1\u606f\u4e3a\u7a7a-{}", (Object)entity.getSubLinkId(), (Object)JSONObject.toJSONString((Object)linkerResp));
                return CommonResponse.error((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u672a\u67e5\u8be2\u5339\u914d\u7684\u4e59\u65b9\u8054\u7cfb\u4eba\u4fe1\u606f\uff01");
            }
            if (null == ((LinkerVO)linkerResp.getData()).getSupUserId()) {
                return CommonResponse.error((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u4e59\u65b9\u8054\u7cfb\u4eba\u672a\u5f00\u901a\u534f\u540c\u8d26\u53f7\uff0c\u8bf7\u5f00\u901a\u8054\u7cfb\u4eba\u534f\u540c\u8d26\u53f7\uff01");
            }
            entity.setSupSubLinkId(((LinkerVO)linkerResp.getData()).getSupUserId());
        }
        if (null != entity.getSubManagerId()) {
            CommonResponse mResp = this.subManagerApi.getById(entity.getSubManagerId().toString());
            if (!mResp.isSuccess()) {
                this.logger.error("\u7ed3\u7b97\u5355\u4fdd\u5b58\u5931\u8d25\uff0c\u67e5\u8be2\u4e59\u65b9\u8054\u7cfb\u4ebaid-{}\u4fe1\u606f\u5931\u8d25-{}", (Object)entity.getSubManagerId(), (Object)JSONObject.toJSONString((Object)mResp));
                return CommonResponse.error((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u67e5\u8be2\u4e59\u65b9\u9879\u76ee\u7ecf\u7406\u4fe1\u606f\u5931\u8d25\uff01");
            }
            if (null == mResp.getData()) {
                this.logger.error("\u7ed3\u7b97\u5355\u4fdd\u5b58\u5931\u8d25\uff0c\u67e5\u8be2\u4e59\u65b9\u8054\u7cfb\u4ebaid-{}\u4fe1\u606f\u4e3a\u7a7a-{}", (Object)entity.getSubManagerId(), (Object)JSONObject.toJSONString((Object)mResp));
                return CommonResponse.error((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u672a\u67e5\u8be2\u5339\u914d\u7684\u4e59\u65b9\u9879\u76ee\u7ecf\u7406\u4fe1\u606f\uff01");
            }
            if (null == ((SupplierManagerVO)mResp.getData()).getSupUserId()) {
                this.logger.error("\u7ed3\u7b97\u5355\uff1a\u4e59\u65b9\u9879\u76ee\u7ecf\u7406id-{}\u672a\u5f00\u901a\u534f\u540c\u8d26\u53f7", (Object)entity.getSubManagerId());
            } else {
                entity.setSupSubManagerId(((SupplierManagerVO)mResp.getData()).getSupUserId());
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        SubSettleVO vo = (SubSettleVO)BeanMapper.map((Object)((Object)entity), SubSettleVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u67e5\u8be2\u8be6\u60c5")
    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SubSettleVO> queryDetail(@RequestParam Long id) {
        SubSettleEntity entity = (SubSettleEntity)((Object)this.service.selectById(id));
        SubSettleVO vo = (SubSettleVO)BeanMapper.map((Object)((Object)entity), SubSettleVO.class);
        if (CollectionUtils.isNotEmpty((Collection)vo.getSubSettleFileList())) {
            List fileIds = vo.getSubSettleFileList().stream().filter(item -> null != item.getAttachmentId()).map(item -> item.getAttachmentId()).collect(Collectors.toList());
            HashMap<Long, AttachmentVO> attachmentVOMap = new HashMap<Long, AttachmentVO>();
            if (CollectionUtils.isNotEmpty(fileIds)) {
                CommonResponse attchResp = this.attachmentApi.queryAllByIds(fileIds);
                if (!attchResp.isSuccess()) {
                    return CommonResponse.error((String)"\u83b7\u53d6\u9644\u4ef6\u4fe1\u606f\u5931\u8d25");
                }
                for (AttachmentVO item2 : (List)attchResp.getData()) {
                    attachmentVOMap.put(item2.getId(), item2);
                }
            }
            for (SubSettleFileVO file : vo.getSubSettleFileList()) {
                if (attachmentVOMap.containsKey(file.getAttachmentId())) continue;
                file.setAttachmentId(null);
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    private void initContext(Long userId) {
        String initContextUrl = this.environmentTools.getBaseHost() + "ejc-idm-web/user/context/getBytenantid?tenantId=999999";
        initContextUrl = initContextUrl + "&userId=" + userId.toString();
        String responseStr = HttpClientUtils.getInstance().getSync(initContextUrl);
        CommonResponse userContextResponse = (CommonResponse)JSON.parseObject((String)responseStr, CommonResponse.class);
        try {
            if (userContextResponse.isSuccess()) {
                JSONObject userContext = ((JSONObject)userContextResponse.getData()).getJSONObject("userContext");
                StringBuilder authtoken = new StringBuilder();
                if (null != userContext) {
                    authtoken.append("userType=").append(userContext.get((Object)"userType")).append(";userCode=").append(userContext.get((Object)"userCode")).append(";orgId=").append(userContext.get((Object)"orgId")).append(";tenantid=").append(userContext.get((Object)"tenantid")).append(";token=").append(userContext.get((Object)"token")).append(";u_logints=").append(userContext.get((Object)"u_logints")).append(";u_usercode=").append(userContext.get((Object)"u_usercode")).append(";userId=").append(userContext.get((Object)"userId"));
                }
                if (authtoken.length() > 0) {
                    InvocationInfoProxy.setExtendAttribute((Object)"authority", (Object)authtoken.toString());
                    InvocationInfoProxy.setParameter((String)"authority", (String)authtoken.toString());
                }
                if (null != userContext) {
                    InvocationInfoProxy.setTenantid((Long)userContext.getLong("tenantid"));
                    InvocationInfoProxy.setUserid((Long)userContext.getLong("userId"));
                    InvocationInfoProxy.setUsercode((String)userContext.getString("userCode"));
                    InvocationInfoProxy.setOrgId((Long)userContext.getLong("orgId"));
                }
            }
        }
        catch (Exception e) {
            this.logger.error("\u521d\u59cb\u5316\u5f02\u6b65\u4efb\u52a1\u4e0a\u4e0b\u6587\u5f02\u5e38\uff1a", (Throwable)e);
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u8be6\u60c5")
    @RequestMapping(value={"/noAuthDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SubSettleVO> noAuthDetail(@RequestParam Long id) {
        SubSettleEntity entity = (SubSettleEntity)((Object)this.service.selectById(id));
        SubSettleVO vo = (SubSettleVO)BeanMapper.map((Object)((Object)entity), SubSettleVO.class);
        this.initContext(vo.getMatWorkerId());
        CommonResponse userByUserId = this.userApi.findUserByUserId(vo.getMatWorkerId());
        if (!userByUserId.isSuccess()) {
            this.logger.info("\u67e5\u8be2\u91c7\u8d2d\u5de5\u7a0b\u5e08\u7f51\u7edc\u4fe1\u606f\u5f02\u5e38", (Object)userByUserId.getMsg());
            throw new BusinessException("\u67e5\u8be2\u91c7\u8d2d\u5de5\u7a0b\u5e08\u4fe1\u606f\u5931\u8d25!");
        }
        vo.setMatWorkerCode(((UserVO)userByUserId.getData()).getUserCode());
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u5ba1\u6838\u901a\u8fc7/\u9a73\u56de\u63a5\u53e3")
    @RequestMapping(value={"/updateApproveStatus"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SubSettleVO> updateApproveStatus(@RequestParam Long id, @RequestParam Integer fillStatus, @RequestParam(required=false) String rejectCause) {
        String s = this.service.updateApproveStatus(id, fillStatus, rejectCause);
        return CommonResponse.success((String)s);
    }

    @PostMapping(value={"subSettleCommitSyncBill"})
    public CommonResponse<String> subSettleCommitSyncBill(HttpServletRequest request) {
        return this.service.subSettleCommitSyncBill(request);
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u5355\u636e")
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SubSettleVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (SubSettleVO subSettleVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SubSettleVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("projectManagementName");
        fuzzyFields.add("subContractName");
        fuzzyFields.add("subContractCode");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("subLinkName");
        fuzzyFields.add("priceType");
        fuzzyFields.add("specialtyType");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("parentOrgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("orgId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SubSettleVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @ApiOperation(value="\u5bfc\u51fa")
    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("projectManagementName");
        fuzzyFields.add("subContractName");
        fuzzyFields.add("subContractCode");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("subLinkName");
        fuzzyFields.add("priceType");
        fuzzyFields.add("specialtyType");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("parentOrgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("orgId", new Parameter("in", departmentIds));
        }
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        List subSettleVOList = BeanMapper.mapList((Iterable)list, SubSettleVO.class);
        for (SubSettleVO subSettleVO : subSettleVOList) {
            if (subSettleVO.getFillStatus() == 1) {
                subSettleVO.setFillStatusName("\u5f85\u5206\u5305\u4e0a\u4f20\u8d44\u6599");
            }
            if (subSettleVO.getFillStatus() == 2) {
                subSettleVO.setFillStatusName("\u5df2\u4e0a\u4f20\u8d44\u6599");
            }
            if (subSettleVO.getFillStatus() != 3) continue;
            subSettleVO.setFillStatusName("\u5ba1\u6838\u901a\u8fc7");
        }
        beans.put("records", subSettleVOList);
        ExcelExport.getInstance().export("SubSettle-export.xlsx", beans, response);
    }

    @ApiOperation(value="\u53c2\u7167")
    @RequestMapping(value={"/refSubSettleData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<SubSettleVO>> refSubSettleData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SubSettleVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

