package com.ejianc.business.zdsmaterial.material.controller;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdsmaterial.cons.PlanConstant;
import com.ejianc.business.zdsmaterial.material.bean.MatSupplierManagerEntity;
import com.ejianc.business.zdsmaterial.material.bean.MaterialCategoryEntity;
import com.ejianc.business.zdsmaterial.material.service.IMatSupplierManagerService;
import com.ejianc.business.zdsmaterial.material.service.IMaterialCategoryService;
import com.ejianc.business.zdsmaterial.material.vo.MatSupplierManagerVO;
import com.ejianc.business.zdsmaterial.material.vo.MaterialCategoryVO;
import com.ejianc.business.zdsmaterial.util.ZDSInterfaceCommonUtil;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author CJ
 * @Description:
 * @date 2024/5/9 13:50
 */
@RestController
@RequestMapping(value = "/matSupManager/")
public class MatSupplierManagerController {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IMatSupplierManagerService service;

    @Autowired
    private IMaterialCategoryService categoryService;

    @Autowired
    private IEmployeeApi employeeApi;

    private final String MATERIAL_MANAGER_SYNC_TO_ERP_URL = "/cefoc/yql/ReceiveC_SD_GoodsTypeSubBList";

    @PostMapping(value = "saveOrUpdate")
    public CommonResponse<String> saveOrUpdateManagers(@RequestBody List<MatSupplierManagerVO> vos) {
        List<MatSupplierManagerVO> saveList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(vos)) {
            List<Long> empIds = vos.stream().map(MatSupplierManagerVO::getManagerId).collect(Collectors.toList());
            MaterialCategoryEntity category = categoryService.getById(vos.get(0).getCategoryId());

            //查询已存在的人员信息 过滤掉
            List<Long> existsEmpIds = service.getAllByCategoryIdAndEmpIds(category.getId(), empIds);

            vos.stream().filter(item -> !existsEmpIds.contains(item.getManagerId())).forEach(item -> {
                item.setCategoryName(category.getName());
                item.setCategoryInnerCode(category.getInnerCode());
                if(null == item.getId()) {
                    item.setId(IdWorker.getId());
                }
                saveList.add(item);
            });
        }
        if(CollectionUtils.isNotEmpty(saveList)) {
            List<MatSupplierManagerEntity> saveEntityList = BeanMapper.mapList(saveList, MatSupplierManagerEntity.class);
            service.saveOrUpdateBatch(saveEntityList, saveEntityList.size(), false);

            //推送ERP
            boolean syncResult = syncToErp(saveEntityList, PlanConstant.INTEGER_YES);
            if(!syncResult) {
                CommonResponse.success("操作失败, 审核人信息推送ERP系统失败！");
            }
        }

        return CommonResponse.success("操作成功！");
    }

    @PostMapping(value = "syncToErp")
    public CommonResponse<String> syncToErpServ(@RequestBody List<Long> syncIds,
                                            @RequestParam(required = false) Integer enableStatus) {
        List<MatSupplierManagerEntity> delList = service.getAllByIds(syncIds);
        if(CollectionUtils.isNotEmpty(delList)) {
            //删除项推送ERP
            syncToErp(delList, null !=enableStatus ? enableStatus : PlanConstant.INTEGER_NO);
        }
        return CommonResponse.success();
    }

    private boolean syncToErp(List<MatSupplierManagerEntity> saveEntityList, Integer enableStatus) {
        logger.info("***********************物资审核人推送ERP任务启动，本次待推送数据：{}条****************************************", saveEntityList.size());
        String reqUrl = ZDSInterfaceCommonUtil.getErpReqHost() + MATERIAL_MANAGER_SYNC_TO_ERP_URL;
        Map<String, String> headers = null;
        String reqResp = null;
        try {
            //查询审核人信息
            List<Long> empIds = saveEntityList.stream().map(MatSupplierManagerEntity::getManagerId).collect(Collectors.toList());
            CommonResponse<List<EmployeeVO>> userResp = employeeApi.getByIds(empIds);
            if(!userResp.isSuccess()) {
                logger.error("临时档案审核人推送任务执行ERP失败，根据用户Id列表-[{}]查询用户信息失败，", JSONObject.toJSONString(empIds, SerializerFeature.PrettyFormat),
                        JSONObject.toJSONString(userResp, SerializerFeature.PrettyFormat));
                return false;
            }
            if(CollectionUtils.isEmpty(userResp.getData())) {
                logger.error("临时档案审核人推送任务执行ERP失败，根据用户Id列表-[{}]查询用户信息为空，", JSONObject.toJSONString(empIds, SerializerFeature.PrettyFormat));
                return false;
            }
            Map<Long, String> userSourceMap = userResp.getData().stream().filter(item -> StringUtils.isNotBlank(item.getSourceId()))
                    .collect(Collectors.toMap(item -> item.getId(), item -> item.getSourceId()));

            //查询物资分类信息
            List<Long> categoryIds = saveEntityList.stream().map(MatSupplierManagerEntity::getCategoryId).collect(Collectors.toList());
            List<MaterialCategoryVO> categorys = categoryService.getAllByIds(categoryIds);
            Map<Long, String> categorySourceMap = categorys.stream().collect(Collectors.toMap(item -> item.getId(), item -> item.getSourceId()));

            List<Map<String, Object>> syncDataList = new ArrayList<>();
            Map<String, Object> tmp = null;
            for(MatSupplierManagerEntity syncItem : saveEntityList) {
                tmp = new HashMap<>();
                if(!userSourceMap.containsKey(syncItem.getManagerId())) {
                    logger.info("物资分类审核人【{}】对应审核人SID为空，跳过推送ERP系统", JSONObject.toJSONString(syncItem, SerializerFeature.PrettyFormat));
                    continue;
                }
                tmp.put("Title_ID", syncItem.getManagerCode()); //审核人工号
                tmp.put("Title", syncItem.getManagerName()); //审核人名称
                tmp.put("Title_Sid", userSourceMap.get(syncItem.getManagerId())); //审核人SID
                tmp.put("GoodsType_FK", categorySourceMap.get(syncItem.getCategoryId())); //物资分类SID
                tmp.put("C_SD_GoodsTypeSubBOID", ZDSInterfaceCommonUtil.changeLongToGUID(syncItem.getId())); //SID主键
                tmp.put("YQL_SID", syncItem.getId().toString()); //主键
                tmp.put("IsEnable", enableStatus); //1为启用
                tmp.put("Sort_ID", 0); //排序号
                tmp.put("Memo", ""); //备注
                tmp.put("SYS_Deleted", PlanConstant.INTEGER_YES.equals(enableStatus) ? PlanConstant.INTEGER_NO : PlanConstant.INTEGER_YES); //1为删除
                syncDataList.add(tmp);
            }
            if(CollectionUtils.isEmpty(syncDataList)) {
                logger.info("本次可推送物资分类审核人列表为空，物资审核人推送任务结束。。。。。。");
                return true;
            }

            headers = ZDSInterfaceCommonUtil.getErpHeaders();
            reqResp = HttpTookit.postByJson(reqUrl,
                    JSONObject.toJSONString(syncDataList), headers, ZDSInterfaceCommonUtil.CONN_TIME_OUT, ZDSInterfaceCommonUtil.READ_TIME_OUT);
            JSONObject syncResultJson = JSONObject.parseObject(reqResp);

            if("ok".equals(syncResultJson.getString("Status"))) {
                logger.error("物资审核人推送ERP，请求结果返回成功，处理结果：{}", syncResultJson.getString("info"));
            } else {
                logger.error("物资审核人推送ERP失败：请求地址-{},参数-{},header-{},结果-{}",
                        reqUrl, JSONObject.toJSONString(saveEntityList), JSONObject.toJSONString(headers, SerializerFeature.PrettyFormat), reqResp);
                return false;
            }
        } catch (Exception e) {
            logger.error("物资审核人推送ERP异常，：请求地址-{},参数-{},header-{},结果：{}",
                    reqUrl, JSONObject.toJSONString(saveEntityList), JSONObject.toJSONString(headers, SerializerFeature.PrettyFormat), reqResp, e);
        }

        return true;
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MatSupplierManagerVO> vos) {
        List<Long> delIds = vos.stream().map(MatSupplierManagerVO::getId).collect(Collectors.toList());
        List<MatSupplierManagerEntity> delList = service.getAllByIds(delIds);
        if(CollectionUtils.isNotEmpty(delList)) {
            //删除项推送ERP
            syncToErp(delList, PlanConstant.INTEGER_NO);
        }
        service.removeByIds(delIds,true);

        return CommonResponse.success("删除成功！");
    }

    /**
     * 查询物资分类树
     *
     * @param param
     * @return
     */
    @RequestMapping(value = "queryCategoryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryCategoryList(@RequestBody QueryParam param) {
        return CommonResponse.success(service.queryCategoryList(param));
    }


    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<MatSupplierManagerVO>> queryList(@RequestBody QueryParam param) {

        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("managerName");
        fuzzyFields.add("managerCode");
        fuzzyFields.add("managerPostName");

        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        IPage<MatSupplierManagerEntity> page = service.queryPage(param,false);

        IPage<MatSupplierManagerVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), MatSupplierManagerVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List<MatSupplierManagerVO> exportList = service.getExportList();

        Map<String, Object> beans = new HashMap<>();
        beans.put("records", exportList);
        ExcelExport.getInstance().export("MatSupManager-export.xlsx", beans, response);
    }

}
