/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.erp.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.business.zdsmaterial.erp.bean.SubContractEntity;
import com.ejianc.business.zdsmaterial.erp.mapper.SubContractMapper;
import com.ejianc.business.zdsmaterial.erp.service.ISubContractDetailService;
import com.ejianc.business.zdsmaterial.erp.service.ISubContractService;
import com.ejianc.business.zdsmaterial.sub.fee.vo.AuditorContractDetailVO;
import com.ejianc.business.zdsmaterial.sub.fee.vo.AuditorSetVO;
import com.ejianc.business.zdssupplier.sub.vo.SupplierVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service(value="subContractService")
public class SubContractServiceImpl
extends BaseServiceImpl<SubContractMapper, SubContractEntity>
implements ISubContractService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private SubContractMapper mapper;
    @Autowired
    private ISubContractDetailService detailService;

    @Override
    public List<SubContractEntity> getAllBySourceIds(List<String> sourceIds) {
        if (CollectionUtils.isEmpty(sourceIds)) {
            return null;
        }
        QueryWrapper query = new QueryWrapper();
        query.in((Object)"source_contract_id", sourceIds);
        query.in((Object)"tenant_id", new Object[]{InvocationInfoProxy.getTenantid()});
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        List list = super.list((Wrapper)query);
        return list;
    }

    @Override
    public void AuditorSetStatus(AuditorSetVO vo) {
        List contractIdS;
        Collection subContractEntities;
        List contractDetailList = vo.getContractDetailList();
        List auditorContractDetailVOStream = contractDetailList.stream().filter(e -> null != e.getStationCode() && e.getStationCode().equals("001")).collect(Collectors.toList());
        if (auditorContractDetailVOStream != null && auditorContractDetailVOStream.size() > 0 && CollectionUtils.isNotEmpty((Collection)(subContractEntities = super.listByIds(contractIdS = auditorContractDetailVOStream.stream().map(AuditorContractDetailVO::getContractId).collect(Collectors.toList()))))) {
            Map<Long, List<AuditorContractDetailVO>> collect = auditorContractDetailVOStream.stream().collect(Collectors.groupingBy(c -> c.getContractId()));
            subContractEntities.stream().forEach(item -> {
                List auditorContractDetailVOS = (List)collect.get(item.getId());
                this.logger.info("*********************auditorContractDetailVOS{}*********************", (Object)JSONObject.toJSONString((Object)auditorContractDetailVOS));
                for (AuditorContractDetailVO detailVO : auditorContractDetailVOS) {
                    if (detailVO.getRowState() != null && detailVO.getRowState().equals("add")) {
                        item.setAuditWorkerId(detailVO.getUserId());
                        item.setAuditWorkerName(detailVO.getUserName());
                        continue;
                    }
                    if (detailVO.getRowState() == null || !detailVO.getRowState().equals("del")) continue;
                    item.setAuditWorkerId(null);
                    item.setAuditWorkerName(null);
                }
                this.logger.info("*********************item setAuditWorkerId{}*********************", (Object)item.getAuditWorkerId());
            });
            super.saveOrUpdateBatch(subContractEntities, subContractEntities.size());
        }
    }

    @Override
    public Integer performanceNum(Long linkerId, String linkerSid, Long supplierId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (null != linkerId || StringUtils.isNotEmpty((CharSequence)linkerSid)) {
            ((QueryWrapper)((QueryWrapper)queryWrapper.eq((Object)"party_contact_id", (Object)linkerId)).or()).eq((Object)"party_contact_s_id", (Object)linkerSid);
        }
        if (null != supplierId) {
            queryWrapper.eq((Object)"supplier_id", (Object)supplierId);
        }
        queryWrapper.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        int count = super.count((Wrapper)queryWrapper);
        return count;
    }

    @Override
    public Integer finishSettleNum(Long linkerId, String linkerSid, Long supplierId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"is_finish", (Object)1);
        queryWrapper.eq((Object)"is_sett", (Object)0);
        queryWrapper.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        if (null != linkerId || StringUtils.isNotEmpty((CharSequence)linkerSid)) {
            queryWrapper.and(q -> (QueryWrapper)((QueryWrapper)((QueryWrapper)q.eq((Object)"party_contact_id", (Object)linkerId)).or()).eq((Object)"party_contact_s_id", (Object)linkerSid));
        }
        if (null != supplierId) {
            queryWrapper.eq((Object)"supplier_id", (Object)supplierId);
        }
        int count = super.count((Wrapper)queryWrapper);
        return count;
    }

    @Override
    public Integer settleNum(Long linkerId, String linkerSid, Long supplierId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"is_sett", (Object)1);
        queryWrapper.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        if (null != linkerId || StringUtils.isNotEmpty((CharSequence)linkerSid)) {
            queryWrapper.and(q -> (QueryWrapper)((QueryWrapper)((QueryWrapper)q.eq((Object)"party_contact_id", (Object)linkerId)).or()).eq((Object)"pro_manager_sid_party_b_id", (Object)linkerSid));
        }
        if (null != supplierId) {
            queryWrapper.eq((Object)"supplier_id", (Object)supplierId);
        }
        int count = super.count((Wrapper)queryWrapper);
        return count;
    }

    @Override
    public BigDecimal thisYearContractMny(Long linkerId, String linkerSid, Long supplierId) {
        List<SubContractEntity> subContractEntities = this.mapper.queryNowYearList(linkerId, linkerSid, supplierId);
        if (subContractEntities != null && subContractEntities.size() > 0) {
            BigDecimal sum = subContractEntities.stream().map(SubContractEntity::getContractMoney).reduce(BigDecimal.ZERO, BigDecimal::add);
            return sum;
        }
        return BigDecimal.ZERO;
    }

    @Override
    @Async(value="maContextCommonTask")
    public void cancelContract(List<Long> delContractIds) {
        UpdateWrapper update = new UpdateWrapper();
        update.in((Object)"id", delContractIds);
        update.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        update.set((Object)"dr", (Object)1);
        update.set((Object)"update_time", (Object)new Date());
        super.update((Wrapper)update);
        this.detailService.cancelByContractIds(delContractIds);
    }

    @Override
    public List<SupplierVO> getAllSubSupInfoBySourceIds(List<String> supSourceIds) {
        return this.mapper.getAllSubSupInfoBySourceIds(supSourceIds);
    }

    @Override
    public List<String> getSyncList() {
        return this.mapper.getSyncList();
    }

    @Override
    public void updateSyncResult(String sourceContractId, String result) {
        this.mapper.updateSyncResult(sourceContractId, result);
    }

    @Override
    public SupplierVO getSubSupInfoByTenant(Long supTenant) {
        return this.mapper.getSubSupInfoByTenant(supTenant);
    }

    @Override
    public SupplierVO getSubSupInfoById(Long supplierId) {
        return this.mapper.getSubSupInfoById(supplierId);
    }
}

