package com.ejianc.business.zdsmaterial.pricelib.enums;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 移除状态
 */
public enum OutFlagEnum {

    /**
     * 是否移除（0-否未移除，1-是）
     */
    未移除(0, "未移除"),
    /**
     * 是否移除（0-否未移除，1-是）
     */
    已移除(1, "已移除"),
    ;


    private Integer code;
    private String description;
    private static Map<Integer, OutFlagEnum> enumMap = new HashMap<>();

    OutFlagEnum(Integer code, String description) {
        this.code = code;
        this.description = description;
    }

    public Integer getCode() {
        return code;
    }

    public String getDescription() {
        return description;
    }

    static {
        enumMap = EnumSet.allOf(OutFlagEnum.class).stream().collect(Collectors.toMap(OutFlagEnum::getCode, Function.identity(), (k1, k2) -> k2));
    }

    public static OutFlagEnum getEnumByCode(Integer code) {
        return enumMap.get(code);
    }
}
