/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.plan.control.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdsmaterial.material.bean.MaterialCategoryEntity;
import com.ejianc.business.zdsmaterial.material.service.IMaterialCategoryService;
import com.ejianc.business.zdsmaterial.pick.bean.ProSubRangeEntity;
import com.ejianc.business.zdsmaterial.pick.service.IProPickSettingService;
import com.ejianc.business.zdsmaterial.pick.service.IProSubRangeService;
import com.ejianc.business.zdsmaterial.plan.control.bean.ControlPlanSumDetailEntity;
import com.ejianc.business.zdsmaterial.plan.control.bean.ControlPlanSumEntity;
import com.ejianc.business.zdsmaterial.plan.control.service.IControlPlanSumDetailService;
import com.ejianc.business.zdsmaterial.plan.control.service.IControlPlanSumService;
import com.ejianc.business.zdsmaterial.plan.control.vo.ControlPlanSumDetailVO;
import com.ejianc.business.zdsmaterial.util.ResultAsTree;
import com.ejianc.business.zdsmaterial.util.SeparatorUtil;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"controlPlanSumDetail"})
public class ControlPlanSumDetailController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IControlPlanSumService sumService;
    @Autowired
    private IControlPlanSumDetailService service;
    @Autowired
    private IProPickSettingService settingService;
    @Autowired
    private IProSubRangeService rangeService;
    @Autowired
    private IMaterialCategoryService categoryService;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ControlPlanSumDetailVO> saveOrUpdate(@RequestBody ControlPlanSumDetailVO saveOrUpdateVO) {
        ControlPlanSumDetailEntity entity = (ControlPlanSumDetailEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, ControlPlanSumDetailEntity.class));
        this.service.saveOrUpdate((Object)entity, false);
        ControlPlanSumDetailVO vo = (ControlPlanSumDetailVO)BeanMapper.map((Object)((Object)entity), ControlPlanSumDetailVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ControlPlanSumDetailVO> queryDetail(Long id) {
        ControlPlanSumDetailEntity entity = (ControlPlanSumDetailEntity)((Object)this.service.selectById(id));
        ControlPlanSumDetailVO vo = (ControlPlanSumDetailVO)BeanMapper.map((Object)((Object)entity), ControlPlanSumDetailVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ControlPlanSumDetailVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (ControlPlanSumDetailVO controlPlanSumDetailVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ControlPlanSumDetailVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("orgId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ControlPlanSumDetailVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelSubExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody List<Long> planIds, HttpServletResponse response) {
        QueryWrapper query = new QueryWrapper();
        query.in((Object)"id", planIds);
        List planList = this.sumService.list((Wrapper)query);
        ArrayList<Long> projectIds = new ArrayList<Long>(planList.stream().map(ControlPlanSumEntity::getProjectId).collect(Collectors.toSet()));
        List<JSONObject> list = this.service.querySubByPlanIds(planIds, projectIds);
        HashMap<String, List<JSONObject>> beans = new HashMap<String, List<JSONObject>>();
        beans.put("records", list);
        ExcelExport.getInstance().export("ControlPlanSumDetail-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refSumMaterialTypeTree"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Map<String, Object>> refSumMaterialTypeTree(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Long projectId = null;
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            if (_con.containsKey((Object)"projectId")) {
                projectId = _con.getLong("projectId");
            }
            if (_con.containsKey((Object)"contractId")) {
                Long contractId = _con.getLong("contractId");
                List<Long> typeIds = this.filterMaterialTypeIds(projectId, contractId);
                if (CollectionUtils.isNotEmpty(typeIds)) {
                    param.getParams().put("materialTypeId", new Parameter("in", typeIds));
                } else {
                    param.getParams().put("0", new Parameter("eq", (Object)1));
                }
            }
        }
        if (projectId == null) {
            throw new BusinessException("\u9879\u76ee\u4e3b\u952e\u5fc5\u8f93\uff01");
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("projectId", new Parameter("eq", (Object)projectId));
        List list = this.sumService.queryList(queryParam);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return new ArrayList<Map<String, Object>>();
        }
        param.getParams().put("planId", new Parameter("eq", (Object)((ControlPlanSumEntity)((Object)list.get(0))).getId()));
        List dataList = this.service.queryList(param);
        List<Long> typeIds = dataList.stream().map(ControlPlanSumDetailEntity::getMaterialTypeId).collect(Collectors.toList());
        List<MaterialCategoryEntity> typeList = this.getMaterialTypeUpList(typeIds);
        if (StringUtils.isNotEmpty((CharSequence)searchText)) {
            typeList = typeList.stream().filter(x -> x.getName().contains(searchText)).map(x -> {
                x.setParentId(null);
                return x;
            }).collect(Collectors.toList());
        }
        return ResultAsTree.createTree(typeList);
    }

    private List<MaterialCategoryEntity> getMaterialTypeUpList(List<Long> typeIds) {
        QueryWrapper query = new QueryWrapper();
        query.in((Object)"id", typeIds);
        query.orderByDesc((Object)"inner_code");
        List categorys = this.categoryService.list((Wrapper)query);
        if (CollectionUtils.isEmpty((Collection)categorys)) {
            return new ArrayList<MaterialCategoryEntity>();
        }
        QueryWrapper ew = new QueryWrapper();
        ew.eq((Object)"enabled", (Object)1);
        ew.and(q -> {
            for (MaterialCategoryEntity m : categorys) {
                List<String> innerCodes = SeparatorUtil.substringPre(m.getInnerCode());
                q.or(iq -> (QueryWrapper)iq.in((Object)"inner_code", (Collection)innerCodes));
            }
            return q;
        });
        List list = this.categoryService.list((Wrapper)ew);
        return list;
    }

    private List<MaterialCategoryEntity> getMaterialTypeDownList(List<Long> typeIds) {
        QueryWrapper query = new QueryWrapper();
        query.in((Object)"id", typeIds);
        query.orderByDesc((Object)"inner_code");
        List categorys = this.categoryService.list((Wrapper)query);
        if (CollectionUtils.isEmpty((Collection)categorys)) {
            return new ArrayList<MaterialCategoryEntity>();
        }
        QueryWrapper ew = new QueryWrapper();
        ew.eq((Object)"enabled", (Object)1);
        ew.and(q -> {
            for (MaterialCategoryEntity m : categorys) {
                q.or(iq -> (QueryWrapper)iq.likeRight((Object)"inner_code", (Object)m.getInnerCode()));
            }
            return q;
        });
        List list = this.categoryService.list((Wrapper)ew);
        return list;
    }

    @RequestMapping(value={"/refControlPlanSumDetailData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ControlPlanSumDetailVO>> refControlPlanSumDetailData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, @RequestParam(required=false) String relyCondition, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        List<Object> typeIdList = new ArrayList();
        if (StringUtils.isNotEmpty((CharSequence)relyCondition)) {
            Long materialTypeId = Long.parseLong(relyCondition.split("=")[1]);
            List<MaterialCategoryEntity> typeList = this.getMaterialTypeDownList(new ArrayList<Long>(Arrays.asList(materialTypeId)));
            typeIdList = typeList.stream().map(BaseEntity::getId).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(typeIdList)) {
                param.getParams().put("materialTypeId", new Parameter("in", typeIdList));
            } else {
                param.getParams().put("0", new Parameter("eq", (Object)1));
            }
        }
        Long projectId = null;
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            if (_con.containsKey((Object)"projectId")) {
                projectId = _con.getLong("projectId");
            }
            if (_con.containsKey((Object)"contractId")) {
                Long contractId = _con.getLong("contractId");
                List<Long> typeIds = this.filterMaterialTypeIds(projectId, contractId);
                if (CollectionUtils.isNotEmpty(typeIdList)) {
                    typeIds.retainAll(typeIdList);
                }
                if (CollectionUtils.isNotEmpty(typeIds)) {
                    param.getParams().put("materialTypeId", new Parameter("in", typeIds));
                } else {
                    param.getParams().put("0", new Parameter("eq", (Object)1));
                }
            }
        }
        if (projectId == null) {
            throw new BusinessException("\u9879\u76ee\u4e3b\u952e\u5fc5\u8f93\uff01");
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("projectId", new Parameter("eq", (Object)projectId));
        List list = this.sumService.queryList(queryParam);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return CommonResponse.success((String)"\u8be5\u9879\u76ee\u4e0d\u5b58\u5728\u7269\u8d44\u603b\u63a7\u8ba1\u5212\u6c47\u603b\u5355\uff01", (Object)new Page());
        }
        param.getParams().put("planId", new Parameter("eq", (Object)((ControlPlanSumEntity)((Object)list.get(0))).getId()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List records = BeanMapper.mapList((Iterable)page.getRecords(), ControlPlanSumDetailVO.class);
        records.forEach(item -> item.setSurplusPlanNum(ComputeUtil.safeSub((BigDecimal)item.getNum(), (BigDecimal)item.getPlanNum())));
        pageData.setRecords(records);
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private List<Long> filterMaterialTypeIds(@RequestParam(value="projectId") Long projectId, @RequestParam(value="contractId") Long contractId) {
        QueryParam param = new QueryParam();
        param.getParams().put("projectId", new Parameter("eq", (Object)projectId));
        List list = this.settingService.queryList(param);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return new ArrayList<Long>();
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter("eq", (Object)contractId));
        List rangeList = this.rangeService.queryList(queryParam);
        if (CollectionUtils.isEmpty((Collection)rangeList)) {
            return new ArrayList<Long>();
        }
        List typeIds = rangeList.stream().map(ProSubRangeEntity::getMaterialTypeId).collect(Collectors.toList());
        QueryWrapper query = new QueryWrapper();
        query.in((Object)"id", typeIds);
        query.orderByDesc((Object)"inner_code");
        List categorys = this.categoryService.list((Wrapper)query);
        if (CollectionUtils.isEmpty((Collection)categorys)) {
            return new ArrayList<Long>();
        }
        QueryWrapper listQuery = new QueryWrapper();
        listQuery.select(new String[]{"id"});
        listQuery.eq((Object)"enabled", (Object)1);
        listQuery.eq((Object)"property_flag", (Object)1);
        listQuery.and(q -> {
            for (MaterialCategoryEntity m : categorys) {
                q.or(iq -> (QueryWrapper)iq.likeRight((Object)"inner_code", (Object)m.getInnerCode()));
            }
            return q;
        });
        List idList = this.categoryService.listObjs((Wrapper)listQuery);
        List<Long> ids = idList.stream().map(item -> Long.valueOf(item.toString())).collect(Collectors.toList());
        return ids;
    }
}

