package com.ejianc.business.zdsmaterial.out.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 处置申请
 * 
 * @author generator
 * 
 */
 @TableName("ejc_material_dispose")
public class DisposeEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="project_id")
    private Long projectId; // 项目主键
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="project_code")
    private String projectCode; // 项目编码
    @TableField(value="org_id")
    private Long orgId; // 所属单位主键
    @TableField(value="org_name")
    private String orgName; // 所属单位名称
    @TableField(value="org_code")
    private String orgCode; // 所属单位编码
    @TableField(value="material_type_names")
    private String materialTypeNames; // 物料分类名称
    @TableField(value="employee_id")
    private Long employeeId; // 经办人id
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）
    @TableField(value="bill_date")
    private Date billDate; // 处置时间
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 上级组织id
    @TableField(value="parent_org_name")
    private String parentOrgName; // 上级组织name
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 上级组织编码
    @TableField(value="dispose_type")
    private Integer disposeType; // 处置方式，1-战略,2-询比价
    @TableField(value="apply_mny")
    private BigDecimal applyMny; // 申请金额
    @TableField(value="apply_tax_mny")
    private BigDecimal applyTaxMny; // 申请金额含税
    @TableField(value="dispose_mny")
    private BigDecimal disposeMny; // 预估处置金额
    @TableField(value="dispose_tax_mny")
    private BigDecimal disposeTaxMny; // 预估处置金额含税
    @TableField(value="actual_dispose_mny")
    private BigDecimal actualDisposeMny; // 实际处置金额
    @TableField(value="actual_dispose_tax_mny")
    private BigDecimal actualDisposeTaxMny; // 实际处置金额含税
    @TableField(value = "create_user_id")
    private Long createUserId;// 制单人Id

    @TableField(value = "rec_mny_flag")
    private String recMnyFlag; //收款标识：0-未收款，1-已收款
    @TableField(value = "rec_mny")
    private BigDecimal recMny; //收款金额
    @TableField(value = "rec_date")
    private Date recDate; //收款状态更新日期

    @TableField(value = "sec_org_name")
    private String secOrgName;//项目直属二级单位名称
    @TableField(value = "sec_org_code")
    private String secOrgCode; //项目直属二级单位编码
    @TableField(value = "sec_org_id")
    private Long secOrgId; //项目直属二级单位Id

    @TableField(exist=false)
    @SubEntity(serviceName="disposeDetailService",pidName = "disposeId")
    private List<DisposeDetailEntity> disposeDetailList = new ArrayList<>(); // 处置申请明细表

    public String getSecOrgName() {
        return secOrgName;
    }

    public void setSecOrgName(String secOrgName) {
        this.secOrgName = secOrgName;
    }

    public String getSecOrgCode() {
        return secOrgCode;
    }

    public void setSecOrgCode(String secOrgCode) {
        this.secOrgCode = secOrgCode;
    }

    public Long getSecOrgId() {
        return secOrgId;
    }

    public void setSecOrgId(Long secOrgId) {
        this.secOrgId = secOrgId;
    }

    public String getRecMnyFlag() {
        return recMnyFlag;
    }

    public void setRecMnyFlag(String recMnyFlag) {
        this.recMnyFlag = recMnyFlag;
    }

    public BigDecimal getRecMny() {
        return recMny;
    }

    public void setRecMny(BigDecimal recMny) {
        this.recMny = recMny;
    }

    public Date getRecDate() {
        return recDate;
    }

    public void setRecDate(Date recDate) {
        this.recDate = recDate;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getMaterialTypeNames() {
        return materialTypeNames;
    }

    public void setMaterialTypeNames(String materialTypeNames) {
        this.materialTypeNames = materialTypeNames;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Date getBillDate() {
        return billDate;
    }

    public void setBillDate(Date billDate) {
        this.billDate = billDate;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public Integer getDisposeType() {
        return disposeType;
    }

    public void setDisposeType(Integer disposeType) {
        this.disposeType = disposeType;
    }
    public BigDecimal getApplyMny() {
        return applyMny;
    }

    public void setApplyMny(BigDecimal applyMny) {
        this.applyMny = applyMny;
    }
    public BigDecimal getApplyTaxMny() {
        return applyTaxMny;
    }

    public void setApplyTaxMny(BigDecimal applyTaxMny) {
        this.applyTaxMny = applyTaxMny;
    }
    public BigDecimal getDisposeMny() {
        return disposeMny;
    }

    public void setDisposeMny(BigDecimal disposeMny) {
        this.disposeMny = disposeMny;
    }
    public BigDecimal getDisposeTaxMny() {
        return disposeTaxMny;
    }

    public void setDisposeTaxMny(BigDecimal disposeTaxMny) {
        this.disposeTaxMny = disposeTaxMny;
    }
    public BigDecimal getActualDisposeMny() {
        return actualDisposeMny;
    }

    public void setActualDisposeMny(BigDecimal actualDisposeMny) {
        this.actualDisposeMny = actualDisposeMny;
    }
    public BigDecimal getActualDisposeTaxMny() {
        return actualDisposeTaxMny;
    }

    public void setActualDisposeTaxMny(BigDecimal actualDisposeTaxMny) {
        this.actualDisposeTaxMny = actualDisposeTaxMny;
    }

    public Long getCreateUserId() {
        return createUserId;
    }

    public void setCreateUserId(Long createUserId) {
        this.createUserId = createUserId;
    }

    public List<DisposeDetailEntity> getDisposeDetailList() {
        return disposeDetailList;
    }

    public void setDisposeDetailList(List<DisposeDetailEntity> disposeDetailList) {
        this.disposeDetailList = disposeDetailList;
    }
}
