package com.ejianc.business.zdsmaterial.out.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.zdsmaterial.cons.PlanConstant;
import com.ejianc.business.zdsmaterial.out.bean.DisposeDetailEntity;
import com.ejianc.business.zdsmaterial.out.bean.DisposeEntity;
import com.ejianc.business.zdsmaterial.out.mapper.DisposeMapper;
import com.ejianc.business.zdsmaterial.out.service.IDisposeService;
import com.ejianc.business.zdsmaterial.out.vo.DisposeDetailVO;
import com.ejianc.business.zdsmaterial.out.vo.DisposeVO;
import com.ejianc.business.zdsmaterial.util.DetailListUtil;
import com.ejianc.business.zdsstore.api.IStoreFlowApi;
import com.ejianc.business.zdsstore.api.IStoreManageApi;
import com.ejianc.business.zdsstore.consts.InOutTypeEnum;
import com.ejianc.business.zdsstore.util.StoreManageUtil;
import com.ejianc.business.zdsstore.vo.FlowVO;
import com.ejianc.business.zdsstore.vo.StoreManageVO;
import com.ejianc.business.zdsstore.vo.SurplusVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 处置申请
 * 
 * @author generator
 * 
 */
@Service("disposeService")
public class DisposeServiceImpl extends BaseServiceImpl<DisposeMapper, DisposeEntity> implements IDisposeService{
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private static final String BILL_CODE = "ZDS_MATERIAL_DISPOSE";//此处需要根据实际修改

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IStoreManageApi storeManageApi;

    @Autowired
    private IStoreFlowApi storeFlowApi;

    @Autowired
    private DisposeMapper mapper;

    @Autowired
    private IOrgApi orgApi;

    @Override
    public DisposeVO saveOrUpdate(DisposeVO saveOrUpdateVO) {
        Boolean flag = false;
        Boolean required = false;
        for(DisposeDetailVO e : saveOrUpdateVO.getDisposeDetailList()){
            if(!"del".equals(e.getRowState())){
                flag = true;
                if(e.getBrandId() == null){
                    required = true;
                }
            }
        };
        if(!flag){
            throw new BusinessException("材料明细不能为空!");
        }
//        if(required){
//            throw new BusinessException("子表品牌不能为空!");
//        }

        // 校验出库数量
        this.validateStoreNum(saveOrUpdateVO);

        DisposeEntity entity = BeanMapper.map(saveOrUpdateVO, DisposeEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            entity.setRecMnyFlag(PlanConstant.STRING_NO); //收款状态：默认未收款
        }
        if(entity.getCreateUserId() == null){
            entity.setCreateUserId(InvocationInfoProxy.getUserid());
        }

        //设置项目直属二级单位信息
        CommonResponse<List<OrgVO>> orgResp = orgApi.findParentsByOrgId(entity.getParentOrgId());
        if(!orgResp.isSuccess() || CollectionUtils.isEmpty(orgResp.getData())) {
            logger.error("根据组织id-{}查询其上级组织信息列表失败, ", entity.getParentOrgId(),
                    JSONObject.toJSONString(orgResp));
            throw new BusinessException("操作失败，查询组织信息失败！");
        }

        Long secOrgId = null;
        Map<Long, OrgVO> orgMap = new HashMap<>();
        for(OrgVO org : orgResp.getData()) {
            orgMap.put(org.getId(), org);
            if(org.getId().equals(entity.getParentOrgId())) {
                String[] orgIdsArr = org.getInnerCode().split("\\|");
                secOrgId = orgIdsArr.length >= 2 ? Long.valueOf(orgIdsArr[1]) : Long.valueOf(orgIdsArr[0]);
            }
        }
        if(null != secOrgId && orgMap.containsKey(secOrgId)) {
            entity.setSecOrgCode(orgMap.get(secOrgId).getCode());
            entity.setSecOrgId(orgMap.get(secOrgId).getId());
            entity.setSecOrgName(orgMap.get(secOrgId).getName());
        } else {
            logger.error("获取组织id-{}对应二级单位信息为空！", entity.getParentOrgId());
        }


        super.saveOrUpdate(entity, false);
//        // 调用库存逻辑
//        Boolean outEffectiveON = false;
//        if("1,3".contains(String.valueOf(entity.getBillState()))){
//            outEffectiveON = true;
//        }
//        this.inOutStore(entity, outEffectiveON);
        return this.queryDetail(entity.getId());
    }

    @Override
    public String del(List<Long> ids) {
//        List<DisposeEntity> list = new ArrayList<>(super.listByIds(ids));
//        DetailListUtil.setDetailList(list);
//        list.forEach(e->{
//            // 调用库存删除
//            this.inOutStoreRollback(e, false);
//        });
        super.removeByIds(ids,true);
        return "删除成功！";
    }

    @Override
    public Boolean inOutStore(DisposeEntity entity, Boolean outEffectiveON) {
        Map<Long, List<DisposeDetailEntity>> map = entity.getDisposeDetailList().stream().filter(x->x.getStoreId() != null).
                collect(Collectors.groupingBy(DisposeDetailEntity::getStoreId));
        if(map.values().stream().flatMap(Collection::stream).count() == 0){
            return true;
        }
        for(Long storeId : map.keySet()){
            StoreManageVO storeManageVO = new StoreManageVO();
            storeManageVO.setStoreId(storeId);
            storeManageVO.setSourceId(entity.getId());
            storeManageVO.setInOutTypeEnum(InOutTypeEnum.材料处置);
            storeManageVO.setOutEffectiveON(outEffectiveON);
            ArrayList<FlowVO> flowVOS = new ArrayList<>();
            for(DisposeDetailEntity t : map.get(storeId)){
                FlowVO flowVO = StoreManageUtil.getFlowVO(InOutTypeEnum.材料处置, 0);
                flowVO.setStoreId(t.getStoreId());
                flowVO.setStoreName(t.getStoreName());
                flowVO.setProjectId(entity.getProjectId());
                flowVO.setProjectName(entity.getProjectName());
                flowVO.setOrgId(entity.getOrgId());
                flowVO.setOrgName(entity.getOrgName());
                flowVO.setParentOrgId(entity.getParentOrgId());
                flowVO.setParentOrgName(entity.getParentOrgName());
                flowVO.setParentOrgCode(entity.getParentOrgCode());
                flowVO.setEmployeeId(entity.getEmployeeId());
                flowVO.setEmployeeName(entity.getEmployeeName());
                flowVO.setMaterialCategoryId(t.getMaterialTypeId());
                flowVO.setMaterialCategoryName(t.getMaterialTypeName());
                flowVO.setMaterialCategoryCode(t.getMaterialTypeCode());
                flowVO.setMaterialId(t.getMaterialId());
                flowVO.setMaterialCode(t.getMaterialCode());
                flowVO.setMaterialName(t.getMaterialName());
                flowVO.setMaterialSpec(t.getPropertyValue());
                flowVO.setBrandId(t.getBrandId());
                flowVO.setBrandName(t.getBrandName());
                flowVO.setProductCode(t.getProductCode());
                flowVO.setMaterialUnitId(t.getUnitId());
                flowVO.setMaterialUnitName(t.getUnitName());
                flowVO.setSourceBillDetailRemark(t.getMemo());
                flowVO.setTaxRate(t.getTaxRate());
                flowVO.setTaxPrice(t.getTaxPrice());
                flowVO.setPrice(t.getPrice());
                flowVO.setNum(t.getNum());

                BigDecimal taxMny = t.getTaxMny();
                BigDecimal mny = t.getMny();
                BigDecimal tax = ComputeUtil.safeSub(t.getTaxMny(), t.getMny());
                if(t.getActualTaxMny() != null){
                    taxMny = t.getActualTaxMny();
                    mny = t.getActualMny();
                    tax = ComputeUtil.safeSub(t.getActualTaxMny(), t.getActualMny());
                }
                flowVO.setTaxMny(taxMny);
                flowVO.setMny(mny);
                flowVO.setTax(tax);

                flowVO.setSourceId(entity.getId());
                flowVO.setSourceDetailId(t.getId());
                flowVO.setSourceBillCode(entity.getBillCode());
                flowVO.setSourceBillDate(entity.getBillDate());
                flowVO.setRowState(t.getRowState());
                flowVO.setSourceBillTypeCode(PlanConstant.DISPOSE_BILL_TYPE);
                flowVO.setSourceBillTypeName("处置申请");
                flowVO.setSourceType(0);//  0-自制,1-订单
                flowVO.setSourceBillRemark(entity.getMemo());
                flowVOS.add(flowVO);
            }
            storeManageVO.setFlowVOList(flowVOS);
            logger.info("调用库存参数：————"+JSONObject.toJSONString(storeManageVO));
            CommonResponse<StoreManageVO> response = storeManageApi.inOutStore(storeManageVO);
            if(!response.isSuccess()) {
                throw new BusinessException("调用库存管理失败,错误信息："+response.getMsg());
            }
        }
        return true;
    }

    @Override
    public Boolean inOutStoreRollback(DisposeEntity entity, Boolean outEffectiveON) {
        Map<Long, List<DisposeDetailEntity>> map = entity.getDisposeDetailList().stream().filter(x->x.getStoreId() != null).
                collect(Collectors.groupingBy(DisposeDetailEntity::getStoreId));
        for(Long storeId : map.keySet()){
            StoreManageVO storeManageVO = new StoreManageVO();
            storeManageVO.setStoreId(storeId);
//            List<Long> ids = map.get(storeId).stream().map(DisposeDetailEntity::getId).collect(Collectors.toList());
            storeManageVO.setSourceIdsForRollBack(new ArrayList<>(Arrays.asList(entity.getId())));
            storeManageVO.setInOutTypeEnum(InOutTypeEnum.材料处置);
            storeManageVO.setOutEffectiveON(outEffectiveON);
            logger.info("调用库存参数：————"+JSONObject.toJSONString(storeManageVO));
            CommonResponse<StoreManageVO> response = storeManageApi.inOutStoreRollback(storeManageVO);
            if(!response.isSuccess()) {
                throw new BusinessException("调用库存管理失败,错误信息："+response.getMsg());
            }
        }
        return true;
    }

    @Override
    public DisposeVO queryDetail(Long id) {
        DisposeEntity entity = super.selectById(id);
        DisposeVO vo = BeanMapper.map(entity, DisposeVO.class);
        if(BillStateEnum.COMMITED_STATE.equals(entity.getBillState()) || BillStateEnum.PASSED_STATE.equals(entity.getBillState()) ){
            return vo;
        }
        // 获取库存数量
        Map<String, SurplusVO> storeMap = this.getStoreMap(vo);
        List<DisposeDetailVO> detailList = vo.getDisposeDetailList();
        for(DisposeDetailVO detail : detailList){
            String key = detail.getMaterialId() + "-" + detail.getBrandId();
            if(storeMap.containsKey(key)){
                detail.setSurplusNum(storeMap.get(key).getSurplusNum());
            } else {
                detail.setSurplusNum(BigDecimal.ZERO);
            }
            // 库存保存即占用，剩余可用量不包含占用量，导致剩余可用量无法包含自身，校验不通过
            detail.setSurplusNum(ComputeUtil.safeAdd(detail.getSurplusNum(), detail.getNum()));
        }
        return vo;
    }

    @Override
    public Boolean validateStoreNum(DisposeVO vo) {
        // 获取库存数量
        Map<String, SurplusVO> storeMap = this.getStoreMap(vo);
        List<DisposeDetailVO> detailList = vo.getDisposeDetailList();
        for(DisposeDetailVO detail : detailList){
            String key = detail.getMaterialId() + "-" + detail.getBrandId();
            if(storeMap.containsKey(key)){
                detail.setSurplusNum(storeMap.get(key).getSurplusNum());
                if(vo.getId() != null){
                    // 库存保存即占用，剩余可用量不包含占用量，导致剩余可用量无法包含自身，校验不通过
                    detail.setSurplusNum(ComputeUtil.safeAdd(detail.getSurplusNum(), detail.getNum()));
                }
                if(ComputeUtil.isLessThan(detail.getSurplusNum(), detail.getNum())){
                    throw new BusinessException("【" + detail.getMaterialCode() + "】本次处置申请数量小于剩余可处置数量，不允许处置");
                }
            }
        }
        return true;
    }

    @Override
    public int pageCount(Map<String, Object> queryParam) {
        return mapper.pageCount(queryParam);
    }

    @Override
    public List<JSONObject> pageList(Map<String, Object> queryParam) {
        return mapper.pageList(queryParam);
    }

    @Override
    public List<DisposeEntity> getAllByIds(List<Long> ids) {
        QueryWrapper<DisposeEntity> query = new QueryWrapper<>();
        query.in("id", ids);
        query.eq("dr", BaseVO.DR_UNDELETE);
        return super.list(query);
    }

    /**
     * 获取库存数量
     * @param vo
     * @return
     */
    private Map<String, SurplusVO> getStoreMap(DisposeVO vo){
        Map<Long, List<DisposeDetailVO>> map = vo.getDisposeDetailList().stream().filter(x->x.getStoreId() != null).
                collect(Collectors.groupingBy(DisposeDetailVO::getStoreId));
        Map<String, SurplusVO> storeMap = new HashMap<>();
        if(map.values().stream().flatMap(Collection::stream).count() == 0){
            return storeMap;
        }
        for(Long storeId : map.keySet()){
            ArrayList<SurplusVO> vos = new ArrayList<>();
            for(DisposeDetailVO t : map.get(storeId)){
                SurplusVO surplusVO = new SurplusVO();
                surplusVO.setStoreId(t.getStoreId());
                surplusVO.setMaterialCategoryId(t.getMaterialTypeId());
                surplusVO.setMaterialId(t.getMaterialId());
                surplusVO.setBrandId(t.getBrandId());
                vos.add(surplusVO);
            }
            logger.info("调用库存参数：————"+JSONObject.toJSONString(vos));
            CommonResponse<List<SurplusVO>> response = storeFlowApi.getNewSurplusNum(vos);
            if(!response.isSuccess() || CollectionUtils.isEmpty(response.getData())){
                continue;
            }
            Map<String, SurplusVO> priceMap = response.getData().stream().
                    collect(Collectors.toMap(k ->k.getMaterialId() + "-" + k.getBrandId(), (k) -> k));
            storeMap.putAll(priceMap);
        }
        return storeMap;
    }
}
